/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.Sensor;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Sensor.class)
public class ShadowSensor {
    @RealObject
    private Sensor realSensor;
    private float maximumRange = 0.0f;

    public static Sensor newInstance(int type) {
        Sensor sensor = (Sensor)Shadow.newInstanceOf(Sensor.class);
        ((SensorReflector)Reflector.reflector(SensorReflector.class, (Object)sensor)).setTypeCompat(type);
        return sensor;
    }

    public void setWakeUpFlag(boolean wakeup) {
        int wakeUpSensorMask = ((SensorReflector)Reflector.reflector(SensorReflector.class)).getWakeUpSensorFlag();
        if (wakeup) {
            this.setMask(wakeUpSensorMask);
        } else {
            this.clearMask(wakeUpSensorMask);
        }
    }

    public void setMaximumRange(float range) {
        this.maximumRange = range;
    }

    @Implementation
    protected float getMaximumRange() {
        return this.maximumRange;
    }

    public void setMinDelay(int delay) {
        ((SensorReflector)Reflector.reflector(SensorReflector.class, (Object)this.realSensor)).setMinDelay(delay);
    }

    private void setMask(int mask) {
        SensorReflector sensorReflector = (SensorReflector)Reflector.reflector(SensorReflector.class, (Object)this.realSensor);
        sensorReflector.setFlags(sensorReflector.getFlags() | mask);
    }

    private void clearMask(int mask) {
        SensorReflector sensorReflector = (SensorReflector)Reflector.reflector(SensorReflector.class, (Object)this.realSensor);
        sensorReflector.setFlags(sensorReflector.getFlags() & ~mask);
    }

    public void setName(String name) {
        ((SensorReflector)Reflector.reflector(SensorReflector.class, (Object)this.realSensor)).setName(name);
    }

    @ForType(value=Sensor.class)
    static interface SensorReflector {
        @Accessor(value="mType")
        public void setTypeField(int var1);

        public void setType(int var1);

        default public void setTypeCompat(int type) {
            if (RuntimeEnvironment.getApiLevel() >= 23) {
                this.setType(type);
            } else {
                this.setTypeField(type);
            }
        }

        @Accessor(value="mFlags")
        public int getFlags();

        @Accessor(value="mFlags")
        public void setFlags(int var1);

        @Accessor(value="mName")
        public void setName(String var1);

        @Accessor(value="mMinDelay")
        public void setMinDelay(int var1);

        @Static
        @Accessor(value="SENSOR_FLAG_WAKE_UP_SENSOR")
        public int getWakeUpSensorFlag();
    }
}

