package org.robolectric.shadows;

import static android.os.Build.VERSION_CODES.N_MR1;
import static android.os.Build.VERSION_CODES.O;

import android.graphics.Matrix;
import android.graphics.RectF;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.MatrixNatives;
import org.robolectric.versioning.AndroidVersions.U;
import org.robolectric.versioning.AndroidVersions.V;

/** Shadow for {@link Matrix} that is backed by native code */
@Implements(
    value = Matrix.class,
    minSdk = O,
    isInAndroidSdk = false,
    callNativeMethodsByDefault = true)
public class ShadowNativeMatrix extends ShadowMatrix {

  @Implementation(maxSdk = N_MR1)
  protected static long native_create(long nSrcOrZero) {
    return nCreate(nSrcOrZero);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static long nCreate(long nSrcOrZero) {
    DefaultNativeRuntimeLoader.injectAndLoad();
    return MatrixNatives.nCreate(nSrcOrZero);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static long nGetNativeFinalizer() {
    return MatrixNatives.nGetNativeFinalizer();
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static boolean nSetRectToRect(long nObject, RectF src, RectF dst, int stf) {
    return MatrixNatives.nSetRectToRect(nObject, src, dst, stf);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static boolean nSetPolyToPoly(
      long nObject, float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
    return MatrixNatives.nSetPolyToPoly(nObject, src, srcIndex, dst, dstIndex, pointCount);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nMapPoints(
      long nObject,
      float[] dst,
      int dstIndex,
      float[] src,
      int srcIndex,
      int ptCount,
      boolean isPts) {
    MatrixNatives.nMapPoints(nObject, dst, dstIndex, src, srcIndex, ptCount, isPts);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static boolean nMapRect(long nObject, RectF dst, RectF src) {
    return MatrixNatives.nMapRect(nObject, dst, src);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nGetValues(long nObject, float[] values) {
    MatrixNatives.nGetValues(nObject, values);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetValues(long nObject, float[] values) {
    MatrixNatives.nSetValues(nObject, values);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static boolean nIsIdentity(long nObject) {
    return MatrixNatives.nIsIdentity(nObject);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static boolean nIsAffine(long nObject) {
    return MatrixNatives.nIsAffine(nObject);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static boolean nRectStaysRect(long nObject) {
    return MatrixNatives.nRectStaysRect(nObject);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nReset(long nObject) {
    MatrixNatives.nReset(nObject);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSet(long nObject, long nOther) {
    MatrixNatives.nSet(nObject, nOther);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetTranslate(long nObject, float dx, float dy) {
    MatrixNatives.nSetTranslate(nObject, dx, dy);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetScale(long nObject, float sx, float sy, float px, float py) {
    MatrixNatives.nSetScale(nObject, sx, sy, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetScale(long nObject, float sx, float sy) {
    MatrixNatives.nSetScale(nObject, sx, sy);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetRotate(long nObject, float degrees, float px, float py) {
    MatrixNatives.nSetRotate(nObject, degrees, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetRotate(long nObject, float degrees) {
    MatrixNatives.nSetRotate(nObject, degrees);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetSinCos(
      long nObject, float sinValue, float cosValue, float px, float py) {
    MatrixNatives.nSetSinCos(nObject, sinValue, cosValue, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetSinCos(long nObject, float sinValue, float cosValue) {
    MatrixNatives.nSetSinCos(nObject, sinValue, cosValue);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetSkew(long nObject, float kx, float ky, float px, float py) {
    MatrixNatives.nSetSkew(nObject, kx, ky, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetSkew(long nObject, float kx, float ky) {
    MatrixNatives.nSetSkew(nObject, kx, ky);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nSetConcat(long nObject, long nA, long nB) {
    MatrixNatives.nSetConcat(nObject, nA, nB);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPreTranslate(long nObject, float dx, float dy) {
    MatrixNatives.nPreTranslate(nObject, dx, dy);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPreScale(long nObject, float sx, float sy, float px, float py) {
    MatrixNatives.nPreScale(nObject, sx, sy, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPreScale(long nObject, float sx, float sy) {
    MatrixNatives.nPreScale(nObject, sx, sy);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPreRotate(long nObject, float degrees, float px, float py) {
    MatrixNatives.nPreRotate(nObject, degrees, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPreRotate(long nObject, float degrees) {
    MatrixNatives.nPreRotate(nObject, degrees);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPreSkew(long nObject, float kx, float ky, float px, float py) {
    MatrixNatives.nPreSkew(nObject, kx, ky, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPreSkew(long nObject, float kx, float ky) {
    MatrixNatives.nPreSkew(nObject, kx, ky);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPreConcat(long nObject, long nOtherMatrix) {
    MatrixNatives.nPreConcat(nObject, nOtherMatrix);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPostTranslate(long nObject, float dx, float dy) {
    MatrixNatives.nPostTranslate(nObject, dx, dy);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPostScale(long nObject, float sx, float sy, float px, float py) {
    MatrixNatives.nPostScale(nObject, sx, sy, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPostScale(long nObject, float sx, float sy) {
    MatrixNatives.nPostScale(nObject, sx, sy);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPostRotate(long nObject, float degrees, float px, float py) {
    MatrixNatives.nPostRotate(nObject, degrees, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPostRotate(long nObject, float degrees) {
    MatrixNatives.nPostRotate(nObject, degrees);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPostSkew(long nObject, float kx, float ky, float px, float py) {
    MatrixNatives.nPostSkew(nObject, kx, ky, px, py);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPostSkew(long nObject, float kx, float ky) {
    MatrixNatives.nPostSkew(nObject, kx, ky);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static void nPostConcat(long nObject, long nOtherMatrix) {
    MatrixNatives.nPostConcat(nObject, nOtherMatrix);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static boolean nInvert(long nObject, long nInverse) {
    return MatrixNatives.nInvert(nObject, nInverse);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static float nMapRadius(long nObject, float radius) {
    return MatrixNatives.nMapRadius(nObject, radius);
  }

  @Implementation(minSdk = O, maxSdk = U.SDK_INT)
  protected static boolean nEquals(long nA, long nB) {
    return MatrixNatives.nEquals(nA, nB);
  }

  @Override
  public List<String> getPreOperations() {
    throw new UnsupportedOperationException("Legacy ShadowMatrix APIs are not supported");
  }

  @Override
  public List<String> getPostOperations() {
    throw new UnsupportedOperationException("Legacy ShadowMatrix APIs are not supported");
  }

  @Override
  public Map<String, String> getSetOperations() {
    throw new UnsupportedOperationException("Legacy ShadowMatrix APIs are not supported");
  }

  @Override
  public String getDescription() {
    throw new UnsupportedOperationException("Legacy ShadowMatrix APIs are not supported");
  }

  /** Shadow for {@link Matrix.ExtraNatives} that contains native functions. */
  @Implements(
      className = "android.graphics.Matrix$ExtraNatives",
      isInAndroidSdk = false,
      callNativeMethodsByDefault = true,
      shadowPicker = ShadowNativeMatrix.ShadowExtraNatives.Picker.class,
      minSdk = V.SDK_INT)
  @SuppressWarnings("robolectric.internal.IgnoreMissingClass")
  public static class ShadowExtraNatives {
    /** Shadow picker for {@link Matrix.ExtraNatives}. */
    public static final class Picker extends GraphicsShadowPicker<Object> {
      public Picker() {
        super(null, ShadowNativeMatrix.ShadowExtraNatives.class);
      }
    }
  }
}
