/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.fakes;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;

public class RoboMenuItem
implements MenuItem {
    private int itemId;
    private int groupId;
    @Nullable
    private CharSequence title;
    @Nullable
    private CharSequence titleCondensed;
    private boolean enabled = true;
    private boolean checked = false;
    private boolean checkable = false;
    private boolean visible = true;
    private boolean expanded = false;
    @Nullable
    private MenuItem.OnMenuItemClickListener menuItemClickListener;
    @Nullable
    public Drawable icon;
    @Nullable
    private Intent intent;
    @Nullable
    private SubMenu subMenu;
    @Nullable
    private View actionView;
    @Nullable
    private MenuItem.OnActionExpandListener actionExpandListener;
    private int order;
    @Nonnull
    private final Context context;
    private char numericChar;
    private char alphaChar;
    @Nullable
    private ActionProvider actionProvider;

    public RoboMenuItem() {
        this((Context)RuntimeEnvironment.getApplication());
    }

    public RoboMenuItem(@Nonnull Context context) {
        this.context = context;
    }

    public RoboMenuItem(int itemId) {
        this();
        this.itemId = itemId;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Nonnull
    public MenuItem setTitle(@Nullable CharSequence title) {
        this.title = title;
        return this;
    }

    @Nonnull
    public MenuItem setTitle(int title) {
        this.title = title == 0 ? null : this.context.getString(title);
        return this;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.title;
    }

    @Nonnull
    public MenuItem setTitleCondensed(@Nullable CharSequence title) {
        this.titleCondensed = title;
        return this;
    }

    @Nullable
    public CharSequence getTitleCondensed() {
        return this.titleCondensed;
    }

    @Nonnull
    public MenuItem setIcon(@Nullable Drawable icon) {
        this.icon = icon;
        return this;
    }

    @Nonnull
    public MenuItem setIcon(int iconRes) {
        this.icon = iconRes == 0 ? null : this.context.getDrawable(iconRes);
        return this;
    }

    @Nullable
    public Drawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public MenuItem setIntent(@Nullable Intent intent) {
        this.intent = intent;
        return this;
    }

    @Nullable
    public Intent getIntent() {
        return this.intent;
    }

    @Nonnull
    public MenuItem setShortcut(char numericChar, char alphaChar) {
        return this;
    }

    @Nonnull
    public MenuItem setNumericShortcut(char numericChar) {
        this.numericChar = numericChar;
        return this;
    }

    public char getNumericShortcut() {
        return this.numericChar;
    }

    @Nonnull
    public MenuItem setAlphabeticShortcut(char alphaChar) {
        this.alphaChar = alphaChar;
        return this;
    }

    public char getAlphabeticShortcut() {
        return this.alphaChar;
    }

    @Nonnull
    public MenuItem setCheckable(boolean checkable) {
        this.checkable = checkable;
        return this;
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    @Nonnull
    public MenuItem setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Nonnull
    public MenuItem setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Nonnull
    public MenuItem setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasSubMenu() {
        return this.subMenu != null;
    }

    @Nullable
    public SubMenu getSubMenu() {
        return this.subMenu;
    }

    public void setSubMenu(@Nullable SubMenu subMenu) {
        this.subMenu = subMenu;
    }

    @Nonnull
    public MenuItem setOnMenuItemClickListener(@Nullable MenuItem.OnMenuItemClickListener menuItemClickListener) {
        this.menuItemClickListener = menuItemClickListener;
        return this;
    }

    @Nullable
    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return null;
    }

    public void click() {
        if (this.enabled && this.menuItemClickListener != null) {
            this.menuItemClickListener.onMenuItemClick((MenuItem)this);
        } else if (this.enabled && this.intent != null) {
            this.context.startActivity(this.intent);
        }
    }

    public void setShowAsAction(int actionEnum) {
    }

    @Nonnull
    public MenuItem setShowAsActionFlags(int actionEnum) {
        return this;
    }

    @Nonnull
    public MenuItem setActionView(@Nullable View view) {
        this.actionView = view;
        return this;
    }

    @Nonnull
    public MenuItem setActionView(int resId) {
        this.actionView = LayoutInflater.from((Context)this.context).inflate(resId, null);
        return this;
    }

    @Nullable
    public View getActionView() {
        return this.actionView;
    }

    @Nonnull
    public MenuItem setActionProvider(@Nullable ActionProvider actionProvider) {
        this.actionProvider = actionProvider;
        return this;
    }

    @Nullable
    public ActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public boolean expandActionView() {
        if (this.actionView != null) {
            if (this.actionExpandListener != null) {
                this.actionExpandListener.onMenuItemActionExpand((MenuItem)this);
            }
            this.expanded = true;
            return true;
        }
        return false;
    }

    public boolean collapseActionView() {
        if (this.actionView != null) {
            if (this.actionExpandListener != null) {
                this.actionExpandListener.onMenuItemActionCollapse((MenuItem)this);
            }
            this.expanded = false;
            return true;
        }
        return false;
    }

    public boolean isActionViewExpanded() {
        return this.expanded;
    }

    @Nonnull
    public MenuItem setOnActionExpandListener(@Nullable MenuItem.OnActionExpandListener listener) {
        this.actionExpandListener = listener;
        return this;
    }
}

