/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.app.ambientcontext.AmbientContextEventRequest;
import android.app.ambientcontext.AmbientContextManager;
import com.android.internal.annotations.GuardedBy;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=AmbientContextManager.class, minSdk=33, isInAndroidSdk=false)
public class ShadowAmbientContextManager {
    private static final Object lock = new Object();
    @Nullable
    @GuardedBy(value={"lock"})
    private static AmbientContextEventRequest lastRegisterObserverRequest;
    @GuardedBy(value={"lock"})
    private static Integer ambientContextServiceStatus;
    @Nullable
    @GuardedBy(value={"lock"})
    private static Set<Integer> lastRequestedEventCodesForConsentActivity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void registerObserver(AmbientContextEventRequest request, PendingIntent resultPendingIntent, Executor executor, Consumer<Integer> statusConsumer) {
        Object object = lock;
        synchronized (object) {
            lastRegisterObserverRequest = request;
            statusConsumer.accept(ambientContextServiceStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void unregisterObserver() {
        Object object = lock;
        synchronized (object) {
            lastRegisterObserverRequest = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AmbientContextEventRequest getLastRegisterObserverRequest() {
        Object object = lock;
        synchronized (object) {
            return lastRegisterObserverRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void queryAmbientContextServiceStatus(Set<Integer> eventTypes, Executor executor, Consumer<Integer> consumer) {
        Object object = lock;
        synchronized (object) {
            consumer.accept(ambientContextServiceStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAmbientContextServiceStatus(Integer status) {
        Object object = lock;
        synchronized (object) {
            ambientContextServiceStatus = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void startConsentActivity(Set<Integer> eventTypes) {
        Object object = lock;
        synchronized (object) {
            lastRequestedEventCodesForConsentActivity = eventTypes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Set<Integer> getLastRequestedEventCodesForConsentActivity() {
        Object object = lock;
        synchronized (object) {
            return lastRequestedEventCodesForConsentActivity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            lastRegisterObserverRequest = null;
            ambientContextServiceStatus = 2;
            lastRequestedEventCodesForConsentActivity = null;
        }
    }

    static {
        ambientContextServiceStatus = 2;
    }
}

