/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioSystem;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=AudioSystem.class, isInAndroidSdk=false)
public class ShadowAudioSystem {
    private static final int MAX_CHANNEL_COUNT = 8;
    private static final int MAX_SAMPLE_RATE = 192000;
    private static final int MIN_SAMPLE_RATE = 4000;
    private static final Table<AudioFormat, Integer, Integer> directPlaybackSupportTable = Tables.synchronizedTable((Table)HashBasedTable.create());
    private static final Table<OffloadSupportFormat, Integer, Integer> offloadPlaybackSupportTable = Tables.synchronizedTable((Table)HashBasedTable.create());
    private static final Multimap<OffloadSupportFormat, Integer> offloadSupportedMap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

    @Implementation(minSdk=31)
    protected static int native_getMaxChannelCount() {
        return 8;
    }

    @Implementation(minSdk=31)
    protected static int native_getMaxSampleRate() {
        return 192000;
    }

    @Implementation(minSdk=31)
    protected static int native_getMinSampleRate() {
        return 4000;
    }

    @Implementation(minSdk=29, maxSdk=30)
    protected static int native_get_FCC_8() {
        return 8;
    }

    public static void setDirectPlaybackSupport(@Nonnull AudioFormat format, @Nonnull AudioAttributes attr, int directPlaybackSupport) {
        Objects.requireNonNull(format, "Illegal null AudioFormat");
        Objects.requireNonNull(attr, "Illegal null AudioAttributes");
        directPlaybackSupportTable.put((Object)format, (Object)attr.getUsage(), (Object)directPlaybackSupport);
    }

    @Implementation(minSdk=33)
    protected static int getDirectPlaybackSupport(@Nonnull AudioFormat format, @Nonnull AudioAttributes attr) {
        return Optional.ofNullable((Integer)directPlaybackSupportTable.get((Object)format, (Object)attr.getUsage())).orElse(0);
    }

    public static void setOffloadPlaybackSupport(@Nonnull AudioFormat format, @Nonnull AudioAttributes attr, int offloadSupport) {
        Objects.requireNonNull(format, "Illegal null AudioFormat");
        Objects.requireNonNull(attr, "Illegal null AudioAttributes");
        offloadPlaybackSupportTable.put((Object)new OffloadSupportFormat(format.getEncoding(), format.getSampleRate(), format.getChannelMask(), format.getChannelIndexMask()), (Object)attr.getVolumeControlStream(), (Object)offloadSupport);
    }

    public static void setOffloadSupported(@Nonnull AudioFormat format, @Nonnull AudioAttributes attr, boolean supported) {
        OffloadSupportFormat offloadSupportFormat = new OffloadSupportFormat(format.getEncoding(), format.getSampleRate(), format.getChannelMask(), format.getChannelIndexMask());
        if (supported) {
            offloadSupportedMap.put((Object)offloadSupportFormat, (Object)attr.getVolumeControlStream());
        } else {
            offloadSupportedMap.remove((Object)offloadSupportFormat, (Object)attr.getVolumeControlStream());
        }
    }

    @Implementation(minSdk=29, maxSdk=30)
    protected static boolean native_is_offload_supported(int encoding, int sampleRate, int channelMask, int channelIndexMask, int streamType) {
        return offloadSupportedMap.containsEntry((Object)new OffloadSupportFormat(encoding, sampleRate, channelMask, channelIndexMask), (Object)streamType);
    }

    @Implementation(minSdk=31)
    protected static int native_get_offload_support(int encoding, int sampleRate, int channelMask, int channelIndexMask, int streamType) {
        return Optional.ofNullable((Integer)offloadPlaybackSupportTable.get((Object)new OffloadSupportFormat(encoding, sampleRate, channelMask, channelIndexMask), (Object)streamType)).orElse(0);
    }

    @Resetter
    public static void reset() {
        directPlaybackSupportTable.clear();
        offloadPlaybackSupportTable.clear();
        offloadSupportedMap.clear();
    }

    private static class OffloadSupportFormat {
        public final int encoding;
        public final int sampleRate;
        public final int channelMask;
        public final int channelIndexMask;

        public OffloadSupportFormat(int encoding, int sampleRate, int channelMask, int channelIndexMask) {
            this.encoding = encoding;
            this.sampleRate = sampleRate;
            this.channelMask = channelMask;
            this.channelIndexMask = channelIndexMask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OffloadSupportFormat)) {
                return false;
            }
            OffloadSupportFormat that = (OffloadSupportFormat)o;
            return this.encoding == that.encoding && this.sampleRate == that.sampleRate && this.channelMask == that.channelMask && this.channelIndexMask == that.channelIndexMask;
        }

        public int hashCode() {
            int result = this.encoding;
            result = 31 * result + this.sampleRate;
            result = 31 * result + this.channelMask;
            result = 31 * result + this.channelIndexMask;
            return result;
        }
    }
}

