/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothPan;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=BluetoothPan.class, isInAndroidSdk=false)
public class ShadowBluetoothPan {
    private final Map<BluetoothDevice, Integer> bluetoothDevices = new HashMap<BluetoothDevice, Integer>();

    public void addDevice(BluetoothDevice bluetoothDevice, int connectionState) {
        this.bluetoothDevices.put(bluetoothDevice, connectionState);
    }

    public void removeDevice(BluetoothDevice bluetoothDevice) {
        this.bluetoothDevices.remove(bluetoothDevice);
    }

    @Implementation
    protected List<BluetoothDevice> getConnectedDevices() {
        return this.getDevicesMatchingConnectionStates(new int[]{2});
    }

    @Implementation
    protected List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        ArrayList<BluetoothDevice> deviceList = new ArrayList<BluetoothDevice>();
        for (Map.Entry<BluetoothDevice, Integer> entry : this.bluetoothDevices.entrySet()) {
            for (int state : states) {
                if (entry.getValue() != state) continue;
                deviceList.add(entry.getKey());
            }
        }
        return ImmutableList.copyOf(deviceList);
    }
}

