/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteAccessPermException;
import android.database.sqlite.SQLiteBindOrColumnIndexOutOfRangeException;
import android.database.sqlite.SQLiteBlobTooBigException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDatatypeMismatchException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteMisuseException;
import android.database.sqlite.SQLiteOutOfMemoryException;
import android.database.sqlite.SQLiteReadOnlyDatabaseException;
import android.database.sqlite.SQLiteTableLockedException;
import android.os.OperationCanceledException;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowLegacyCursorWindow;
import org.robolectric.shadows.ShadowSQLiteConnection;
import org.robolectric.shadows.util.SQLiteLibraryLoader;
import org.robolectric.util.PerfStatsCollector;

@Implements(value=SQLiteConnection.class, isInAndroidSdk=false)
public class ShadowLegacySQLiteConnection
extends ShadowSQLiteConnection {
    private static final String IN_MEMORY_PATH = ":memory:";
    private static final Connections CONNECTIONS = new Connections();
    private static final Pattern COLLATE_LOCALIZED_UNICODE_PATTERN = Pattern.compile("\\s+COLLATE\\s+(LOCALIZED|UNICODE)", 2);
    private static final int IGNORED_REINDEX_STMT = -2;

    @Implementation(maxSdk=26)
    protected static long nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile) {
        SQLiteLibraryLoader.load();
        return CONNECTIONS.open(path);
    }

    @Implementation(minSdk=27)
    protected static long nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile, int lookasideSlotSize, int lookasideSlotCount) {
        return ShadowLegacySQLiteConnection.nativeOpen(path, openFlags, label, enableTrace, enableProfile);
    }

    @Implementation
    protected static long nativePrepareStatement(long connectionPtr, String sql) {
        String newSql = ShadowLegacySQLiteConnection.convertSQLWithLocalizedUnicodeCollator(sql);
        return CONNECTIONS.prepareStatement(connectionPtr, newSql);
    }

    static String convertSQLWithLocalizedUnicodeCollator(String sql) {
        Matcher matcher = COLLATE_LOCALIZED_UNICODE_PATTERN.matcher(sql);
        return matcher.replaceAll(" COLLATE NOCASE");
    }

    @Resetter
    public static void reset() {
        CONNECTIONS.reset();
    }

    @Implementation(maxSdk=35)
    protected static void nativeClose(long connectionPtr) {
        CONNECTIONS.close(connectionPtr);
    }

    @Implementation(minSdk=36)
    protected static void nativeClose(long connectionPtr, boolean fast) {
        CONNECTIONS.close(connectionPtr);
    }

    @Implementation
    protected static void nativeFinalizeStatement(long connectionPtr, long statementPtr) {
        CONNECTIONS.finalizeStmt(connectionPtr, statementPtr);
    }

    @Implementation
    protected static int nativeGetParameterCount(long connectionPtr, long statementPtr) {
        return CONNECTIONS.getParameterCount(connectionPtr, statementPtr);
    }

    @Implementation
    protected static boolean nativeIsReadOnly(long connectionPtr, long statementPtr) {
        return CONNECTIONS.isReadOnly(connectionPtr, statementPtr);
    }

    @Implementation
    protected static long nativeExecuteForLong(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForLong(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=32)
    protected static void nativeExecute(long connectionPtr, long statementPtr) {
        CONNECTIONS.executeStatement(connectionPtr, statementPtr);
    }

    @Implementation(minSdk=33)
    protected static void nativeExecute(long connectionPtr, long statementPtr, boolean isPragmaStmt) {
        CONNECTIONS.executeStatement(connectionPtr, statementPtr);
    }

    @Implementation
    protected static String nativeExecuteForString(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForString(connectionPtr, statementPtr);
    }

    @Implementation
    protected static int nativeGetColumnCount(long connectionPtr, long statementPtr) {
        return CONNECTIONS.getColumnCount(connectionPtr, statementPtr);
    }

    @Implementation
    protected static String nativeGetColumnName(long connectionPtr, long statementPtr, int index) {
        return CONNECTIONS.getColumnName(connectionPtr, statementPtr, index);
    }

    @Implementation
    protected static void nativeBindNull(long connectionPtr, long statementPtr, int index) {
        CONNECTIONS.bindNull(connectionPtr, statementPtr, index);
    }

    @Implementation
    protected static void nativeBindLong(long connectionPtr, long statementPtr, int index, long value) {
        CONNECTIONS.bindLong(connectionPtr, statementPtr, index, value);
    }

    @Implementation
    protected static void nativeBindDouble(long connectionPtr, long statementPtr, int index, double value) {
        CONNECTIONS.bindDouble(connectionPtr, statementPtr, index, value);
    }

    @Implementation
    protected static void nativeBindString(long connectionPtr, long statementPtr, int index, String value) {
        CONNECTIONS.bindString(connectionPtr, statementPtr, index, value);
    }

    @Implementation
    protected static void nativeBindBlob(long connectionPtr, long statementPtr, int index, byte[] value) {
        CONNECTIONS.bindBlob(connectionPtr, statementPtr, index, value);
    }

    @Implementation
    protected static void nativeRegisterLocalizedCollators(long connectionPtr, String locale) {
    }

    @Implementation
    protected static int nativeExecuteForChangedRowCount(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForChangedRowCount(connectionPtr, statementPtr);
    }

    @Implementation
    protected static long nativeExecuteForLastInsertedRowId(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForLastInsertedRowId(connectionPtr, statementPtr);
    }

    @Implementation
    protected static long nativeExecuteForCursorWindow(long connectionPtr, long statementPtr, long windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return CONNECTIONS.executeForCursorWindow(connectionPtr, statementPtr, windowPtr);
    }

    @Implementation
    protected static void nativeResetStatementAndClearBindings(long connectionPtr, long statementPtr) {
        CONNECTIONS.resetStatementAndClearBindings(connectionPtr, statementPtr);
    }

    @Implementation
    protected static void nativeCancel(long connectionPtr) {
        CONNECTIONS.cancel(connectionPtr);
    }

    @Implementation
    protected static void nativeResetCancel(long connectionPtr, boolean cancelable) {
    }

    @Implementation(maxSdk=29)
    protected static void nativeRegisterCustomFunction(long connectionPtr, SQLiteCustomFunction function) {
    }

    @Implementation
    protected static int nativeExecuteForBlobFileDescriptor(long connectionPtr, long statementPtr) {
        return -1;
    }

    @Implementation
    protected static int nativeGetDbLookaside(long connectionPtr) {
        return 0;
    }

    static class Connections {
        private final Object lock = new Object();
        private final AtomicLong pointerCounter = new AtomicLong(0L);
        private final Map<Long, SQLiteStatement> statementsMap = new HashMap<Long, SQLiteStatement>();
        private final Map<Long, com.almworks.sqlite4java.SQLiteConnection> connectionsMap = new HashMap<Long, com.almworks.sqlite4java.SQLiteConnection>();
        private final Map<Long, List<Long>> statementPtrsForConnection = new HashMap<Long, List<Long>>();
        private ExecutorService dbExecutor = Executors.newSingleThreadExecutor(Connections.threadFactory());
        private static final ImmutableMap<Integer, String> ERROR_CODE_MAP;

        Connections() {
        }

        static ThreadFactory threadFactory() {
            ThreadFactory delegate = Executors.defaultThreadFactory();
            return r -> {
                Thread worker = delegate.newThread(r);
                worker.setName(ShadowLegacySQLiteConnection.class.getSimpleName() + " worker");
                return worker;
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        com.almworks.sqlite4java.SQLiteConnection getConnection(long connectionPtr) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection connection = this.connectionsMap.get(connectionPtr);
                if (connection == null) {
                    throw new IllegalStateException("Illegal connection pointer " + connectionPtr + ". Current pointers for thread " + Thread.currentThread() + " " + this.connectionsMap.keySet());
                }
                return connection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SQLiteStatement getStatement(long connectionPtr, long statementPtr) {
            Object object = this.lock;
            synchronized (object) {
                this.getConnection(connectionPtr);
                SQLiteStatement statement = this.statementsMap.get(statementPtr);
                if (statement == null) {
                    throw new IllegalArgumentException("Invalid prepared statement pointer: " + statementPtr + ". Current pointers: " + this.statementsMap.keySet());
                }
                if (statement.isDisposed()) {
                    throw new IllegalStateException("Statement " + statementPtr + " " + statement + " is disposed");
                }
                return statement;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long open(String path) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection dbConnection = this.execute(() -> {
                    com.almworks.sqlite4java.SQLiteConnection connection = ShadowSQLiteConnection.useInMemoryDatabase.get() || ShadowLegacySQLiteConnection.IN_MEMORY_PATH.equals(path) ? new com.almworks.sqlite4java.SQLiteConnection() : new com.almworks.sqlite4java.SQLiteConnection(new File(path));
                    connection.open();
                    return connection;
                });
                long connectionPtr = this.pointerCounter.incrementAndGet();
                this.connectionsMap.put(connectionPtr, dbConnection);
                this.statementPtrsForConnection.put(connectionPtr, new ArrayList());
                return connectionPtr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long prepareStatement(long connectionPtr, String sql) {
            if ("REINDEX LOCALIZED".equals(sql)) {
                return -2L;
            }
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                SQLiteStatement statement = this.execute(() -> connection.prepare(sql));
                long statementPtr = this.pointerCounter.incrementAndGet();
                this.statementsMap.put(statementPtr, statement);
                this.statementPtrsForConnection.get(connectionPtr).add(statementPtr);
                return statementPtr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(long connectionPtr) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                this.execute(() -> {
                    connection.dispose();
                    return null;
                });
                this.connectionsMap.remove(connectionPtr);
                this.statementPtrsForConnection.remove(connectionPtr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            ArrayList<com.almworks.sqlite4java.SQLiteConnection> openConnections;
            ExecutorService oldDbExecutor;
            Object object = this.lock;
            synchronized (object) {
                oldDbExecutor = this.dbExecutor;
                openConnections = new ArrayList<com.almworks.sqlite4java.SQLiteConnection>(this.connectionsMap.values());
                this.dbExecutor = Executors.newSingleThreadExecutor(Connections.threadFactory());
                this.connectionsMap.clear();
                this.statementsMap.clear();
                this.statementPtrsForConnection.clear();
            }
            Connections.shutdownDbExecutor(oldDbExecutor, openConnections);
        }

        private static void shutdownDbExecutor(ExecutorService executorService, Collection<com.almworks.sqlite4java.SQLiteConnection> connections) {
            for (com.almworks.sqlite4java.SQLiteConnection connection : connections) {
                Connections.getFuture(executorService.submit(() -> {
                    connection.dispose();
                    return null;
                }));
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finalizeStmt(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                this.statementsMap.remove(statementPtr);
                this.execute(() -> {
                    statement.dispose();
                    return null;
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel(long connectionPtr) {
            Object object = this.lock;
            synchronized (object) {
                this.getConnection(connectionPtr);
                for (Long statementPtr : this.statementPtrsForConnection.get(connectionPtr)) {
                    SQLiteStatement statement = this.statementsMap.get(statementPtr);
                    if (statement == null) continue;
                    this.execute(() -> {
                        statement.cancel();
                        return null;
                    });
                }
            }
        }

        int getParameterCount(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return 0;
            }
            return this.executeStatementOperation(connectionPtr, statementPtr, SQLiteStatement::getBindParameterCount);
        }

        boolean isReadOnly(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return true;
            }
            return this.executeStatementOperation(connectionPtr, statementPtr, SQLiteStatement::isReadOnly);
        }

        long executeForLong(long connectionPtr, long statementPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, statement -> {
                if (!statement.step()) {
                    throw new SQLiteException(101, "No rows returned from query");
                }
                return statement.columnLong(0);
            });
        }

        void executeStatement(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return;
            }
            this.executeStatementOperation(connectionPtr, statementPtr, statement -> {
                statement.stepThrough();
                return null;
            });
        }

        String executeForString(long connectionPtr, long statementPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, statement -> {
                if (!statement.step()) {
                    throw new SQLiteException(101, "No rows returned from query");
                }
                return statement.columnString(0);
            });
        }

        int getColumnCount(long connectionPtr, long statementPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, SQLiteStatement::columnCount);
        }

        String getColumnName(long connectionPtr, long statementPtr, int index) {
            return this.executeStatementOperation(connectionPtr, statementPtr, statement -> statement.getColumnName(index));
        }

        void bindNull(long connectionPtr, long statementPtr, int index) {
            this.executeStatementOperation(connectionPtr, statementPtr, statement -> {
                statement.bindNull(index);
                return null;
            });
        }

        void bindLong(long connectionPtr, long statementPtr, int index, long value) {
            this.executeStatementOperation(connectionPtr, statementPtr, statement -> {
                statement.bind(index, value);
                return null;
            });
        }

        void bindDouble(long connectionPtr, long statementPtr, int index, double value) {
            this.executeStatementOperation(connectionPtr, statementPtr, statement -> {
                statement.bind(index, value);
                return null;
            });
        }

        void bindString(long connectionPtr, long statementPtr, int index, String value) {
            this.executeStatementOperation(connectionPtr, statementPtr, statement -> {
                statement.bind(index, value);
                return null;
            });
        }

        void bindBlob(long connectionPtr, long statementPtr, int index, byte[] value) {
            this.executeStatementOperation(connectionPtr, statementPtr, statement -> {
                statement.bind(index, value);
                return null;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int executeForChangedRowCount(long connectionPtr, long statementPtr) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                return this.execute(() -> {
                    if (statement.step()) {
                        throw new android.database.sqlite.SQLiteException("Queries can be performed using SQLiteDatabase query or rawQuery methods only.");
                    }
                    return connection.getChanges();
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long executeForLastInsertedRowId(long connectionPtr, long statementPtr) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                return this.execute(() -> {
                    statement.stepThrough();
                    return connection.getChanges() > 0 ? connection.getLastInsertId() : -1L;
                });
            }
        }

        long executeForCursorWindow(long connectionPtr, long statementPtr, long windowPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, statement -> ShadowLegacyCursorWindow.setData(windowPtr, statement)).intValue();
        }

        void resetStatementAndClearBindings(long connectionPtr, long statementPtr) {
            this.executeStatementOperation(connectionPtr, statementPtr, statement -> {
                statement.reset(true);
                return null;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T executeStatementOperation(long connectionPtr, long statementPtr, StatementOperation<T> statementOperation) {
            Object object = this.lock;
            synchronized (object) {
                SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                return (T)this.execute(() -> statementOperation.call(statement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T execute(Callable<T> work) {
            Object object = this.lock;
            synchronized (object) {
                return (T)PerfStatsCollector.getInstance().measure("sqlite", () -> Connections.getFuture(this.dbExecutor.submit(work)));
            }
        }

        private static <T> T getFuture(Future<T> future) {
            try {
                return (T)Uninterruptibles.getUninterruptibly(future);
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof SQLiteException) {
                    SQLiteException sqliteException = (SQLiteException)t;
                    RuntimeException sqlException = Connections.getSqliteException(sqliteException.getMessage(), sqliteException.getErrorCode());
                    sqlException.initCause(e);
                    throw sqlException;
                }
                if (t instanceof android.database.sqlite.SQLiteException) {
                    throw (android.database.sqlite.SQLiteException)t;
                }
                throw new RuntimeException(e);
            }
        }

        private static RuntimeException getSqliteException(String sqliteErrorMessage, int errorCode) {
            int baseErrorCode = errorCode & 0xFF;
            String errorMessageWithoutCode = sqliteErrorMessage.replaceAll("^\\[\\d+] ?", "");
            StringBuilder fullMessage = new StringBuilder(errorMessageWithoutCode);
            fullMessage.append(" (code ");
            fullMessage.append(errorCode);
            String errorCodeMessage = (String)ERROR_CODE_MAP.getOrDefault((Object)errorCode, (Object)"");
            if (!((String)MoreObjects.firstNonNull((Object)errorCodeMessage, (Object)"")).isEmpty()) {
                fullMessage.append(" ").append(errorCodeMessage);
            }
            fullMessage.append(")");
            String message = fullMessage.toString();
            switch (baseErrorCode) {
                case 4: {
                    return new SQLiteAbortException(message);
                }
                case 3: {
                    return new SQLiteAccessPermException(message);
                }
                case 25: {
                    return new SQLiteBindOrColumnIndexOutOfRangeException(message);
                }
                case 18: {
                    return new SQLiteBlobTooBigException(message);
                }
                case 14: {
                    return new SQLiteCantOpenDatabaseException(message);
                }
                case 19: {
                    return new SQLiteConstraintException(message);
                }
                case 11: 
                case 26: {
                    return new SQLiteDatabaseCorruptException(message);
                }
                case 5: {
                    return new SQLiteDatabaseLockedException(message);
                }
                case 20: {
                    return new SQLiteDatatypeMismatchException(message);
                }
                case 10: {
                    return new SQLiteDiskIOException(message);
                }
                case 101: {
                    return new SQLiteDoneException(message);
                }
                case 13: {
                    return new SQLiteFullException(message);
                }
                case 21: {
                    return new SQLiteMisuseException(message);
                }
                case 7: {
                    return new SQLiteOutOfMemoryException(message);
                }
                case 8: {
                    return new SQLiteReadOnlyDatabaseException(message);
                }
                case 6: {
                    return new SQLiteTableLockedException(message);
                }
                case 9: {
                    return new OperationCanceledException(message);
                }
            }
            return new android.database.sqlite.SQLiteException(message + ", base error code: " + baseErrorCode);
        }

        static {
            HashMap<Integer, String> errorCodeMap = new HashMap<Integer, String>();
            errorCodeMap.put(4, "SQLITE_ABORT");
            errorCodeMap.put(23, "SQLITE_AUTH");
            errorCodeMap.put(5, "SQLITE_BUSY");
            errorCodeMap.put(14, "SQLITE_CANTOPEN");
            errorCodeMap.put(19, "SQLITE_CONSTRAINT");
            errorCodeMap.put(11, "SQLITE_CORRUPT");
            errorCodeMap.put(101, "SQLITE_DONE");
            errorCodeMap.put(16, "SQLITE_EMPTY");
            errorCodeMap.put(1, "SQLITE_ERROR");
            errorCodeMap.put(24, "SQLITE_FORMAT");
            errorCodeMap.put(13, "SQLITE_FULL");
            errorCodeMap.put(2, "SQLITE_INTERNAL");
            errorCodeMap.put(9, "SQLITE_INTERRUPT");
            errorCodeMap.put(10, "SQLITE_IOERR");
            errorCodeMap.put(6, "SQLITE_LOCKED");
            errorCodeMap.put(20, "SQLITE_MISMATCH");
            errorCodeMap.put(21, "SQLITE_MISUSE");
            errorCodeMap.put(22, "SQLITE_NOLFS");
            errorCodeMap.put(7, "SQLITE_NOMEM");
            errorCodeMap.put(26, "SQLITE_NOTADB");
            errorCodeMap.put(12, "SQLITE_NOTFOUND");
            errorCodeMap.put(27, "SQLITE_NOTICE");
            errorCodeMap.put(0, "SQLITE_OK");
            errorCodeMap.put(3, "SQLITE_PERM");
            errorCodeMap.put(15, "SQLITE_PROTOCOL");
            errorCodeMap.put(25, "SQLITE_RANGE");
            errorCodeMap.put(8, "SQLITE_READONLY");
            errorCodeMap.put(100, "SQLITE_ROW");
            errorCodeMap.put(17, "SQLITE_SCHEMA");
            errorCodeMap.put(18, "SQLITE_TOOBIG");
            errorCodeMap.put(28, "SQLITE_WARNING");
            errorCodeMap.put(516, "SQLITE_ABORT_ROLLBACK");
            errorCodeMap.put(261, "SQLITE_BUSY_RECOVERY");
            errorCodeMap.put(517, "SQLITE_BUSY_SNAPSHOT");
            errorCodeMap.put(1038, "SQLITE_CANTOPEN_CONVPATH");
            errorCodeMap.put(782, "SQLITE_CANTOPEN_FULLPATH");
            errorCodeMap.put(526, "SQLITE_CANTOPEN_ISDIR");
            errorCodeMap.put(270, "SQLITE_CANTOPEN_NOTEMPDIR");
            errorCodeMap.put(275, "SQLITE_CONSTRAINT_CHECK");
            errorCodeMap.put(531, "SQLITE_CONSTRAINT_COMMITHOOK");
            errorCodeMap.put(787, "SQLITE_CONSTRAINT_FOREIGNKEY");
            errorCodeMap.put(1043, "SQLITE_CONSTRAINT_FUNCTION");
            errorCodeMap.put(1299, "SQLITE_CONSTRAINT_NOTNULL");
            errorCodeMap.put(1555, "SQLITE_CONSTRAINT_PRIMARYKEY");
            errorCodeMap.put(2579, "SQLITE_CONSTRAINT_ROWID");
            errorCodeMap.put(1811, "SQLITE_CONSTRAINT_TRIGGER");
            errorCodeMap.put(2067, "SQLITE_CONSTRAINT_UNIQUE");
            errorCodeMap.put(2323, "SQLITE_CONSTRAINT_VTAB");
            errorCodeMap.put(267, "SQLITE_CORRUPT_VTAB");
            errorCodeMap.put(3338, "SQLITE_IOERR_ACCESS");
            errorCodeMap.put(2826, "SQLITE_IOERR_BLOCKED");
            errorCodeMap.put(3594, "SQLITE_IOERR_CHECKRESERVEDLOCK");
            errorCodeMap.put(4106, "SQLITE_IOERR_CLOSE");
            errorCodeMap.put(6666, "SQLITE_IOERR_CONVPATH");
            errorCodeMap.put(2570, "SQLITE_IOERR_DELETE");
            errorCodeMap.put(5898, "SQLITE_IOERR_DELETE_NOENT");
            errorCodeMap.put(4362, "SQLITE_IOERR_DIR_CLOSE");
            errorCodeMap.put(1290, "SQLITE_IOERR_DIR_FSYNC");
            errorCodeMap.put(1802, "SQLITE_IOERR_FSTAT");
            errorCodeMap.put(1034, "SQLITE_IOERR_FSYNC");
            errorCodeMap.put(6410, "SQLITE_IOERR_GETTEMPPATH");
            errorCodeMap.put(3850, "SQLITE_IOERR_LOCK");
            errorCodeMap.put(6154, "SQLITE_IOERR_MMAP");
            errorCodeMap.put(3082, "SQLITE_IOERR_NOMEM");
            errorCodeMap.put(2314, "SQLITE_IOERR_RDLOCK");
            errorCodeMap.put(266, "SQLITE_IOERR_READ");
            errorCodeMap.put(5642, "SQLITE_IOERR_SEEK");
            errorCodeMap.put(5130, "SQLITE_IOERR_SHMLOCK");
            errorCodeMap.put(5386, "SQLITE_IOERR_SHMMAP");
            errorCodeMap.put(4618, "SQLITE_IOERR_SHMOPEN");
            errorCodeMap.put(4874, "SQLITE_IOERR_SHMSIZE");
            errorCodeMap.put(522, "SQLITE_IOERR_SHORT_READ");
            errorCodeMap.put(1546, "SQLITE_IOERR_TRUNCATE");
            errorCodeMap.put(2058, "SQLITE_IOERR_UNLOCK");
            errorCodeMap.put(778, "SQLITE_IOERR_WRITE");
            errorCodeMap.put(262, "SQLITE_LOCKED_SHAREDCACHE");
            errorCodeMap.put(539, "SQLITE_NOTICE_RECOVER_ROLLBACK");
            errorCodeMap.put(283, "SQLITE_NOTICE_RECOVER_WAL");
            errorCodeMap.put(256, "SQLITE_OK_LOAD_PERMANENTLY");
            errorCodeMap.put(520, "SQLITE_READONLY_CANTLOCK");
            errorCodeMap.put(1032, "SQLITE_READONLY_DBMOVED");
            errorCodeMap.put(264, "SQLITE_READONLY_RECOVERY");
            errorCodeMap.put(776, "SQLITE_READONLY_ROLLBACK");
            errorCodeMap.put(284, "SQLITE_WARNING_AUTOINDEX");
            ERROR_CODE_MAP = ImmutableMap.copyOf(errorCodeMap);
        }

        static interface StatementOperation<T> {
            public T call(SQLiteStatement var1) throws Exception;
        }
    }
}

