/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.ImageDecoder;
import android.graphics.Rect;
import android.util.Size;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.ImageDecoderNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowImageDecoder;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=ImageDecoder.class, minSdk=28, shadowPicker=Picker.class, callNativeMethodsByDefault=true)
public class ShadowNativeImageDecoder {
    @Implementation(minSdk=28, maxSdk=29)
    protected static ImageDecoder createFromAsset(AssetManager.AssetInputStream ais, ImageDecoder.Source source) throws IOException {
        return ShadowNativeImageDecoder.createFromAsset(ais, false, source);
    }

    @Implementation(minSdk=30)
    protected static ImageDecoder createFromAsset(AssetManager.AssetInputStream ais, boolean preferAnimation, ImageDecoder.Source source) throws IOException {
        int bytesRead;
        int capacity = ais.available();
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
        buffer.order(ByteOrder.nativeOrder());
        byte[] buf = new byte[8192];
        while ((bytesRead = ais.read(buf)) != -1) {
            buffer.put(buf, 0, bytesRead);
        }
        if (ais.read() != -1) {
            throw new IOException("Unable to access full contents of asset");
        }
        if (RuntimeEnvironment.getApiLevel() > 34) {
            return ((ImageDecoderReflector)Reflector.reflector(ImageDecoderReflector.class)).nCreate(buffer, 0, bytesRead, preferAnimation, source);
        }
        return ShadowNativeImageDecoder.nCreate(buffer, 0, bytesRead, preferAnimation, source);
    }

    @Implementation(minSdk=28, maxSdk=29)
    protected static ImageDecoder nCreate(long asset, ImageDecoder.Source src) throws IOException {
        return ShadowNativeImageDecoder.nCreate(asset, false, src);
    }

    @Implementation(minSdk=30)
    protected static ImageDecoder nCreate(long asset, boolean preferAnimation, ImageDecoder.Source src) throws IOException {
        throw new UnsupportedEncodingException();
    }

    @Implementation(minSdk=28, maxSdk=29)
    protected static ImageDecoder nCreate(ByteBuffer buffer, int position, int limit, ImageDecoder.Source src) throws IOException {
        return ShadowNativeImageDecoder.nCreate(buffer, position, limit, false, src);
    }

    @Implementation(minSdk=30, maxSdk=34)
    protected static ImageDecoder nCreate(ByteBuffer buffer, int position, int limit, boolean preferAnimation, ImageDecoder.Source src) throws IOException {
        return ImageDecoderNatives.nCreate((ByteBuffer)buffer, (int)position, (int)limit, (boolean)preferAnimation, (ImageDecoder.Source)src);
    }

    @Implementation(minSdk=28, maxSdk=29)
    protected static ImageDecoder nCreate(byte[] data, int offset, int length, ImageDecoder.Source src) throws IOException {
        return ShadowNativeImageDecoder.nCreate(data, offset, length, false, src);
    }

    @Implementation(minSdk=30, maxSdk=34)
    protected static ImageDecoder nCreate(byte[] data, int offset, int length, boolean preferAnimation, ImageDecoder.Source src) throws IOException {
        return ImageDecoderNatives.nCreate((byte[])data, (int)offset, (int)length, (boolean)preferAnimation, (ImageDecoder.Source)src);
    }

    @Implementation(minSdk=28, maxSdk=29)
    protected static ImageDecoder nCreate(InputStream is, byte[] storage, ImageDecoder.Source src) throws IOException {
        return ShadowNativeImageDecoder.nCreate(is, storage, false, src);
    }

    @Implementation(minSdk=30, maxSdk=34)
    protected static ImageDecoder nCreate(InputStream is, byte[] storage, boolean preferAnimation, ImageDecoder.Source src) throws IOException {
        return ImageDecoderNatives.nCreate((InputStream)is, (byte[])storage, (boolean)preferAnimation, (ImageDecoder.Source)src);
    }

    @Implementation(maxSdk=29)
    protected static ImageDecoder nCreate(FileDescriptor fd, ImageDecoder.Source src) throws IOException {
        return ShadowNativeImageDecoder.nCreate(fd, -1L, false, src);
    }

    @Implementation(minSdk=30, maxSdk=30)
    protected static ImageDecoder nCreate(FileDescriptor fd, boolean preferAnimation, ImageDecoder.Source src) throws IOException {
        return ShadowNativeImageDecoder.nCreate(fd, -1L, preferAnimation, src);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static ImageDecoder nCreate(FileDescriptor fd, long length, boolean preferAnimation, ImageDecoder.Source src) throws IOException {
        return ImageDecoderNatives.nCreate((FileDescriptor)fd, (long)length, (boolean)preferAnimation, (ImageDecoder.Source)src);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected static Bitmap nDecodeBitmap(long nativePtr, ImageDecoder decoder, boolean doPostProcess, int width, int height, Rect cropRect, boolean mutable, int allocator, boolean unpremulRequired, boolean conserveMemory, boolean decodeAsAlphaMask, ColorSpace desiredColorSpace) throws IOException {
        return ShadowNativeImageDecoder.nDecodeBitmap(nativePtr, decoder, doPostProcess, width, height, cropRect, mutable, allocator, unpremulRequired, conserveMemory, decodeAsAlphaMask, 0L, false);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static Bitmap nDecodeBitmap(long nativePtr, ImageDecoder decoder, boolean doPostProcess, int width, int height, Rect cropRect, boolean mutable, int allocator, boolean unpremulRequired, boolean conserveMemory, boolean decodeAsAlphaMask, long desiredColorSpace, boolean extended) throws IOException {
        return ImageDecoderNatives.nDecodeBitmap((long)nativePtr, (ImageDecoder)decoder, (boolean)doPostProcess, (int)width, (int)height, (Rect)cropRect, (boolean)mutable, (int)allocator, (boolean)unpremulRequired, (boolean)conserveMemory, (boolean)decodeAsAlphaMask, (long)desiredColorSpace, (boolean)extended);
    }

    @Implementation(maxSdk=34)
    protected static Size nGetSampledSize(long nativePtr, int sampleSize) {
        return ImageDecoderNatives.nGetSampledSize((long)nativePtr, (int)sampleSize);
    }

    @Implementation(maxSdk=34)
    protected static void nGetPadding(long nativePtr, Rect outRect) {
        ImageDecoderNatives.nGetPadding((long)nativePtr, (Rect)outRect);
    }

    @Implementation(maxSdk=34)
    protected static void nClose(long nativePtr) {
        ImageDecoderNatives.nClose((long)nativePtr);
    }

    @Implementation(maxSdk=34)
    protected static String nGetMimeType(long nativePtr) {
        return ImageDecoderNatives.nGetMimeType((long)nativePtr);
    }

    @Implementation(maxSdk=34)
    protected static ColorSpace nGetColorSpace(long nativePtr) {
        return ImageDecoderNatives.nGetColorSpace((long)nativePtr);
    }

    static {
        DefaultNativeRuntimeLoader.injectAndLoad();
    }

    @ForType(value=ImageDecoder.class)
    static interface ImageDecoderReflector {
        @Static
        public ImageDecoder nCreate(ByteBuffer var1, int var2, int var3, boolean var4, ImageDecoder.Source var5);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowImageDecoder.class, ShadowNativeImageDecoder.class);
        }
    }
}

