/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.os.Bundle;
import android.provider.Settings;
import android.service.voice.VoiceInteractionService;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowService;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=VoiceInteractionService.class)
public class ShadowVoiceInteractionService
extends ShadowService {
    private final List<Bundle> hintBundles = Collections.synchronizedList(new ArrayList());
    private final List<Bundle> sessionBundles = Collections.synchronizedList(new ArrayList());
    @RealObject
    private VoiceInteractionService realVic;

    public static void setActiveService(@Nullable ComponentName activeService) {
        Settings.Secure.putString((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"voice_interaction_service", (String)(activeService == null ? "" : activeService.flattenToString()));
    }

    @Implementation(minSdk=29)
    protected void setUiHints(Bundle hints) {
        ((VoiceInteractionServiceReflector)Reflector.reflector(VoiceInteractionServiceReflector.class, (Object)this.realVic)).setUiHints(hints);
        this.hintBundles.add(hints);
    }

    @Implementation(minSdk=23)
    protected void showSession(Bundle args, int flags) {
        ((VoiceInteractionServiceReflector)Reflector.reflector(VoiceInteractionServiceReflector.class, (Object)this.realVic)).showSession(args, flags);
        this.sessionBundles.add(args);
    }

    public List<Bundle> getPreviousUiHintBundles() {
        return Collections.unmodifiableList(this.hintBundles);
    }

    @Nullable
    public Bundle getLastUiHintBundle() {
        if (this.hintBundles.isEmpty()) {
            return null;
        }
        return this.hintBundles.get(this.hintBundles.size() - 1);
    }

    @Nullable
    public Bundle getLastSessionBundle() {
        return (Bundle)Iterables.getLast(this.sessionBundles, null);
    }

    @ForType(value=VoiceInteractionService.class)
    static interface VoiceInteractionServiceReflector {
        @Direct
        public void showSession(Bundle var1, int var2);

        @Direct
        public void setUiHints(Bundle var1);
    }
}

