/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.WallpaperInfo;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.util.MathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.Logger;
import org.xmlpull.v1.XmlPullParserException;

@Implements(value=WallpaperManager.class)
public class ShadowWallpaperManager {
    private static final String TAG = "ShadowWallpaperManager";
    private static Bitmap lockScreenImage = null;
    private static Bitmap homeScreenImage = null;
    private static Rect lockScreenVisibleCropHint = null;
    private static Rect homeScreenVisibleCropHint = null;
    private static boolean isWallpaperAllowed = true;
    private static boolean isWallpaperSupported = true;
    private static WallpaperInfo wallpaperInfo = null;
    private static final List<WallpaperCommandRecord> wallpaperCommandRecords = new ArrayList<WallpaperCommandRecord>();
    private static final AtomicInteger wallpaperId = new AtomicInteger(0);
    private static int lockScreenId;
    private static int homeScreenId;
    private static int lockScreenResId;
    private static int homeScreenResId;
    private static float wallpaperDimAmount;
    private static final ArrayList<Float> allWallpaperDimAmounts;

    @Implementation
    protected void sendWallpaperCommand(IBinder windowToken, String action, int x, int y, int z, Bundle extras) {
        wallpaperCommandRecords.add(new WallpaperCommandRecord(windowToken, action, x, y, z, extras));
    }

    @Implementation(maxSdk=23)
    protected void setResource(int resid) {
        this.setResource(resid, 3);
    }

    @Implementation(minSdk=24)
    protected int setResource(int resid, int which) {
        if ((which & 3) == 0) {
            return 0;
        }
        if ((which & 1) == 1) {
            homeScreenResId = resid;
            homeScreenId = wallpaperId.incrementAndGet();
        }
        if ((which & 2) == 2) {
            lockScreenResId = resid;
            lockScreenId = (which & 1) == 1 ? -1 : wallpaperId.incrementAndGet();
        }
        return (which & 1) == 1 ? homeScreenId : lockScreenId;
    }

    @Implementation
    protected boolean hasResourceWallpaper(int resid) {
        return resid == lockScreenResId || resid == homeScreenResId;
    }

    @Implementation(minSdk=24)
    protected int setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup, int which) {
        if ((which & 3) == 0) {
            return 0;
        }
        if ((which & 2) == 2) {
            lockScreenImage = fullImage;
            lockScreenVisibleCropHint = visibleCropHint;
            lockScreenId = (which & 1) == 1 ? -1 : wallpaperId.incrementAndGet();
            wallpaperInfo = null;
        }
        if ((which & 1) == 1) {
            homeScreenImage = fullImage;
            homeScreenVisibleCropHint = visibleCropHint;
            homeScreenId = wallpaperId.incrementAndGet();
            wallpaperInfo = null;
        }
        return 1;
    }

    @Nullable
    public Bitmap getBitmap(int which) {
        if (which == 2) {
            return lockScreenImage;
        }
        if (which == 1) {
            return homeScreenImage;
        }
        return null;
    }

    @Nullable
    public Rect getVisibleCropHint(int which) {
        if (which == 2) {
            return lockScreenVisibleCropHint;
        }
        if (which == 1) {
            return homeScreenVisibleCropHint;
        }
        return null;
    }

    @Implementation(minSdk=24)
    @Nullable
    protected ParcelFileDescriptor getWallpaperFile(int which) {
        if (which == 1 && homeScreenImage != null) {
            return ShadowWallpaperManager.createParcelFileDescriptorFromBitmap(homeScreenImage, "home_wallpaper");
        }
        if (which == 2 && lockScreenImage != null) {
            return ShadowWallpaperManager.createParcelFileDescriptorFromBitmap(lockScreenImage, "lock_screen_wallpaper");
        }
        return null;
    }

    @Implementation(minSdk=24)
    protected int getWallpaperId(int which) {
        if (which == 2) {
            return lockScreenId;
        }
        if (which == 1) {
            return homeScreenId;
        }
        return -1;
    }

    @Implementation(minSdk=24)
    protected boolean isSetWallpaperAllowed() {
        return isWallpaperAllowed;
    }

    public void setIsSetWallpaperAllowed(boolean allowed) {
        isWallpaperAllowed = allowed;
    }

    @Implementation(minSdk=23)
    protected boolean isWallpaperSupported() {
        return isWallpaperSupported;
    }

    public void setIsWallpaperSupported(boolean supported) {
        isWallpaperSupported = supported;
    }

    @Implementation(minSdk=24)
    protected int setStream(InputStream bitmapData, Rect visibleCropHint, boolean allowBackup, int which) {
        if ((which & 3) == 0) {
            return 0;
        }
        if ((which & 2) == 2) {
            lockScreenImage = BitmapFactory.decodeStream((InputStream)bitmapData);
            lockScreenVisibleCropHint = visibleCropHint;
        }
        if ((which & 1) == 1) {
            homeScreenImage = BitmapFactory.decodeStream((InputStream)bitmapData);
            homeScreenVisibleCropHint = visibleCropHint;
        }
        return 1;
    }

    @SystemApi
    @Implementation(minSdk=23)
    @RequiresPermission(value="android.permission.SET_WALLPAPER_COMPONENT")
    protected boolean setWallpaperComponent(ComponentName wallpaperService) throws IOException, XmlPullParserException {
        ShadowWallpaperManager.enforceWallpaperComponentPermission();
        Intent wallpaperServiceIntent = new Intent().setComponent(wallpaperService);
        List resolveInfoList = RuntimeEnvironment.getApplication().getPackageManager().queryIntentServices(wallpaperServiceIntent, 128);
        if (resolveInfoList.size() != 1) {
            throw new IllegalArgumentException("Can't locate the given wallpaper service: " + wallpaperService);
        }
        wallpaperInfo = new WallpaperInfo((Context)RuntimeEnvironment.getApplication(), (ResolveInfo)resolveInfoList.get(0));
        lockScreenImage = null;
        homeScreenImage = null;
        return true;
    }

    @Implementation
    protected WallpaperInfo getWallpaperInfo() {
        return wallpaperInfo;
    }

    @Implementation(minSdk=33)
    protected void setWallpaperDimAmount(float dimAmount) {
        wallpaperDimAmount = MathUtils.saturate((float)dimAmount);
        allWallpaperDimAmounts.add(Float.valueOf(dimAmount));
    }

    public List<Float> getAllWallpaperDimAmounts() {
        return Collections.unmodifiableList(allWallpaperDimAmounts);
    }

    @Implementation(minSdk=33)
    protected float getWallpaperDimAmount() {
        return wallpaperDimAmount;
    }

    public List<WallpaperCommandRecord> getWallpaperCommandRecords() {
        return Collections.unmodifiableList(wallpaperCommandRecords);
    }

    private static void enforceWallpaperComponentPermission() {
        if (RuntimeEnvironment.getApplication().checkSelfPermission("android.permission.SET_WALLPAPER_COMPONENT") != 0) {
            throw new SecurityException("Permission android.permission.SET_WALLPAPER_COMPONENT isn't granted.");
        }
    }

    private static ParcelFileDescriptor createParcelFileDescriptorFromBitmap(Bitmap image, String fileName) {
        ParcelFileDescriptor parcelFileDescriptor;
        File tmpFile = new File(RuntimeEnvironment.getApplication().getCacheDir(), fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
        try {
            image.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)fileOutputStream);
            parcelFileDescriptor = ParcelFileDescriptor.open((File)tmpFile, (int)0x10000000);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error((String)"Fail to close file output stream when reading wallpaper from file", (Throwable)e);
                return null;
            }
        }
        fileOutputStream.close();
        return parcelFileDescriptor;
    }

    @Resetter
    public static void reset() {
        lockScreenImage = null;
        homeScreenImage = null;
        lockScreenVisibleCropHint = null;
        homeScreenVisibleCropHint = null;
        isWallpaperAllowed = true;
        isWallpaperSupported = true;
        wallpaperInfo = null;
        wallpaperCommandRecords.clear();
        wallpaperId.set(0);
        lockScreenId = 0;
        homeScreenId = 0;
        lockScreenResId = 0;
        homeScreenResId = 0;
        wallpaperDimAmount = 0.0f;
        allWallpaperDimAmounts.clear();
    }

    static {
        wallpaperDimAmount = 0.0f;
        allWallpaperDimAmounts = new ArrayList();
    }

    public static class WallpaperCommandRecord {
        public final IBinder windowToken;
        public final String action;
        public final int x;
        public final int y;
        public final int z;
        public final Bundle extras;

        WallpaperCommandRecord(IBinder windowToken, String action, int x, int y, int z, Bundle extras) {
            this.windowToken = windowToken;
            this.action = action;
            this.x = x;
            this.y = y;
            this.z = z;
            this.extras = extras;
        }
    }
}

