/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.wearable.WearableSensingManager;
import android.content.ComponentName;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.SharedMemory;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=WearableSensingManager.class, minSdk=34, isInAndroidSdk=false)
public class ShadowWearableSensingManager {
    private static Integer provideDataStreamResult = 1;
    private static Integer provideDataResult = 1;
    private static Integer startHotwordRecognitionResult = 1;
    private static Integer stopHotwordRecognitionResult = 1;
    private static final ArrayList<PersistableBundle> dataBundleList = new ArrayList();
    private static final ArrayList<SharedMemory> sharedMemoryList = new ArrayList();
    private static ParcelFileDescriptor lastParcelFileDescriptor;

    @Implementation
    protected void provideDataStream(ParcelFileDescriptor parcelFileDescriptor, Executor executor, Consumer<Integer> statusConsumer) {
        lastParcelFileDescriptor = parcelFileDescriptor;
        executor.execute(() -> statusConsumer.accept(provideDataStreamResult));
    }

    @Implementation
    protected void provideData(PersistableBundle data, SharedMemory sharedMemory, Executor executor, Consumer<Integer> statusConsumer) {
        dataBundleList.add(data);
        sharedMemoryList.add(sharedMemory);
        executor.execute(() -> statusConsumer.accept(provideDataResult));
    }

    @Implementation(minSdk=35)
    protected void startHotwordRecognition(@Nullable ComponentName targetVisComponentName, @Nonnull Executor executor, @Nonnull Consumer<Integer> statusConsumer) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(statusConsumer);
        executor.execute(() -> statusConsumer.accept(startHotwordRecognitionResult));
    }

    @Implementation(minSdk=35)
    protected void stopHotwordRecognition(@Nonnull Executor executor, @Nonnull Consumer<Integer> statusConsumer) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(statusConsumer);
        executor.execute(() -> statusConsumer.accept(stopHotwordRecognitionResult));
    }

    public void setProvideDataStreamResult(Integer provideDataStreamResult) {
        ShadowWearableSensingManager.provideDataStreamResult = provideDataStreamResult;
    }

    public void setProvideDataResult(Integer provideDataResult) {
        ShadowWearableSensingManager.provideDataResult = provideDataResult;
    }

    public void setStartHotwordRecognitionResult(@Nonnull Integer startHotwordRecognitionResult) {
        Objects.requireNonNull(startHotwordRecognitionResult);
        ShadowWearableSensingManager.startHotwordRecognitionResult = startHotwordRecognitionResult;
    }

    public void setStopHotwordRecognitionResult(@Nonnull Integer stopHotwordRecognitionResult) {
        Objects.requireNonNull(stopHotwordRecognitionResult);
        ShadowWearableSensingManager.stopHotwordRecognitionResult = stopHotwordRecognitionResult;
    }

    public ParcelFileDescriptor getLastParcelFileDescriptor() {
        return lastParcelFileDescriptor;
    }

    public PersistableBundle getLastDataBundle() {
        return dataBundleList.isEmpty() ? null : (PersistableBundle)Iterables.getLast(dataBundleList);
    }

    public List<PersistableBundle> getAllDataBundles() {
        return new ArrayList<PersistableBundle>(dataBundleList);
    }

    public SharedMemory getLastSharedMemory() {
        return sharedMemoryList.isEmpty() ? null : (SharedMemory)Iterables.getLast(sharedMemoryList);
    }

    public List<SharedMemory> getAllSharedMemories() {
        return new ArrayList<SharedMemory>(sharedMemoryList);
    }

    @Resetter
    public static void reset() {
        provideDataStreamResult = 1;
        provideDataResult = 1;
        startHotwordRecognitionResult = 1;
        stopHotwordRecognitionResult = 1;
        dataBundleList.clear();
        sharedMemoryList.clear();
        lastParcelFileDescriptor = null;
    }
}

