/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.PackageInfo;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebMessagePort;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewFactoryProvider;
import android.webkit.WebViewProvider;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.fakes.RoboWebMessagePort;
import org.robolectric.fakes.RoboWebSettings;
import org.robolectric.shadows.ShadowViewGroup;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=WebView.class)
public class ShadowWebView
extends ShadowViewGroup {
    @RealObject
    private WebView realWebView;
    private static final String HISTORY_KEY = "ShadowWebView.History";
    private static final String HISTORY_INDEX_KEY = "ShadowWebView.HistoryIndex";
    private static PackageInfo packageInfo = null;
    private final List<RoboWebMessagePort[]> allCreatedPorts = new ArrayList<RoboWebMessagePort[]>();
    private String lastUrl;
    private Map<String, String> lastAdditionalHttpHeaders;
    private final HashMap<String, Object> javascriptInterfaces = new HashMap();
    private final WebSettings webSettings = new RoboWebSettings();
    private WebViewClient webViewClient = null;
    private boolean clearCacheCalled = false;
    private boolean clearCacheIncludeDiskFiles = false;
    private boolean clearFormDataCalled = false;
    private boolean clearHistoryCalled = false;
    private boolean clearViewCalled = false;
    private boolean destroyCalled = false;
    private boolean onPauseCalled = false;
    private boolean onResumeCalled = false;
    private WebChromeClient webChromeClient;
    private boolean canGoBack;
    private Bitmap currentFavicon = null;
    private int goBackInvocations = 0;
    private int goForwardInvocations = 0;
    private int reloadInvocations = 0;
    private LoadData lastLoadData;
    private LoadDataWithBaseURL lastLoadDataWithBaseURL;
    private String originalUrl;
    private int historyIndex = -1;
    private ArrayList<String> history = new ArrayList();
    private String lastEvaluatedJavascript;
    private ValueCallback<String> lastEvaluatedJavascriptCallback;
    private boolean canGoBackIsSet;
    private PageLoadType pageLoadType = PageLoadType.UNDEFINED;
    private WebView.HitTestResult hitTestResult = new WebView.HitTestResult();
    private int backgroundColor = 0;
    private DownloadListener downloadListener;
    private static WebViewFactoryProvider webViewFactoryProvider;

    @HiddenApi
    @Implementation
    protected static WebViewFactoryProvider getFactory() {
        if (webViewFactoryProvider == null) {
            webViewFactoryProvider = (WebViewFactoryProvider)ReflectionHelpers.createDeepProxy(WebViewFactoryProvider.class);
        }
        return webViewFactoryProvider;
    }

    @HiddenApi
    @Implementation
    public void ensureProviderCreated() {
        ReflectionHelpers.setField((Object)this.realWebView, (String)"mProvider", (Object)ReflectionHelpers.createDeepProxy(WebViewProvider.class));
    }

    @Implementation
    protected void setLayoutParams(ViewGroup.LayoutParams params) {
        ReflectionHelpers.setField((Object)this.realWebView, (String)"mLayoutParams", (Object)params);
    }

    @Implementation
    protected void loadUrl(String url) {
        this.loadUrl(url, null);
    }

    @Implementation
    protected void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        this.originalUrl = url;
        this.lastUrl = url;
        this.lastAdditionalHttpHeaders = additionalHttpHeaders != null ? Collections.unmodifiableMap(additionalHttpHeaders) : null;
        this.performPageLoadType(url);
    }

    @Implementation
    protected void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        if (historyUrl != null) {
            this.originalUrl = historyUrl;
        }
        this.lastLoadDataWithBaseURL = new LoadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
        this.performPageLoadType(baseUrl);
    }

    @Implementation
    protected void loadData(String data, String mimeType, String encoding) {
        this.lastLoadData = new LoadData(data, mimeType, encoding);
        this.performPageLoadType(data);
    }

    public void pushEntryToHistory(String url) {
        this.history.subList(this.historyIndex + 1, this.history.size()).clear();
        this.history.add(url);
        ++this.historyIndex;
        this.originalUrl = url;
    }

    public void performNoPageLoadClientCallbacks() {
        this.pageLoadType = PageLoadType.UNDEFINED;
    }

    public void performSuccessfulPageLoadClientCallbacks() {
        this.pageLoadType = PageLoadType.SUCCESS;
    }

    private void performPageLoadType(String url) {
        switch (this.pageLoadType) {
            case SUCCESS: {
                this.performSuccessfulPageLoad(url);
                break;
            }
        }
    }

    private void performSuccessfulPageLoad(String url) {
        new Handler(Looper.getMainLooper()).post(() -> {
            if (this.webChromeClient != null) {
                this.webChromeClient.onProgressChanged(this.realWebView, 10);
            }
            if (this.webViewClient != null) {
                this.webViewClient.onPageStarted(this.realWebView, url, null);
            }
            if (this.webChromeClient != null) {
                this.webChromeClient.onProgressChanged(this.realWebView, 40);
                this.webChromeClient.onProgressChanged(this.realWebView, 80);
            }
            if (this.webViewClient != null && Build.VERSION.SDK_INT >= 23) {
                this.webViewClient.onPageCommitVisible(this.realWebView, url);
            }
            if (this.webChromeClient != null) {
                this.webChromeClient.onReceivedTitle(this.realWebView, url);
                this.webChromeClient.onProgressChanged(this.realWebView, 100);
            }
            if (this.webViewClient != null) {
                this.webViewClient.onPageFinished(this.realWebView, url);
            }
        });
    }

    public String getLastLoadedUrl() {
        return this.lastUrl;
    }

    @Implementation
    protected String getOriginalUrl() {
        return this.originalUrl;
    }

    @Implementation
    protected String getUrl() {
        return this.originalUrl;
    }

    @Implementation
    protected String getTitle() {
        return this.originalUrl;
    }

    public Map<String, String> getLastAdditionalHttpHeaders() {
        return this.lastAdditionalHttpHeaders;
    }

    @Implementation
    protected WebSettings getSettings() {
        return this.webSettings;
    }

    @Implementation
    protected void setWebViewClient(WebViewClient client) {
        this.webViewClient = client;
    }

    @Implementation
    protected void setWebChromeClient(WebChromeClient client) {
        this.webChromeClient = client;
    }

    @Implementation(minSdk=26)
    public WebViewClient getWebViewClient() {
        return this.webViewClient;
    }

    @Implementation
    protected void addJavascriptInterface(Object obj, String interfaceName) {
        this.javascriptInterfaces.put(interfaceName, obj);
    }

    public Object getJavascriptInterface(String interfaceName) {
        return this.javascriptInterfaces.get(interfaceName);
    }

    @Implementation
    protected void removeJavascriptInterface(String name) {
        this.javascriptInterfaces.remove(name);
    }

    @Implementation(minSdk=23)
    protected WebMessagePort[] createWebMessageChannel() {
        WebMessagePort[] ports = RoboWebMessagePort.createPair();
        this.allCreatedPorts.add((RoboWebMessagePort[])ports);
        return ports;
    }

    public List<RoboWebMessagePort[]> getCreatedPorts() {
        return ImmutableList.copyOf(this.allCreatedPorts);
    }

    @Implementation
    protected void clearCache(boolean includeDiskFiles) {
        this.clearCacheCalled = true;
        this.clearCacheIncludeDiskFiles = includeDiskFiles;
    }

    public boolean wasClearCacheCalled() {
        return this.clearCacheCalled;
    }

    public boolean didClearCacheIncludeDiskFiles() {
        return this.clearCacheIncludeDiskFiles;
    }

    @Implementation
    protected void clearFormData() {
        this.clearFormDataCalled = true;
    }

    public boolean wasClearFormDataCalled() {
        return this.clearFormDataCalled;
    }

    @Implementation
    protected void clearHistory() {
        this.clearHistoryCalled = true;
        this.history.clear();
        this.historyIndex = -1;
    }

    public boolean wasClearHistoryCalled() {
        return this.clearHistoryCalled;
    }

    @Implementation
    protected void reload() {
        ++this.reloadInvocations;
    }

    public int getReloadInvocations() {
        return this.reloadInvocations;
    }

    @Implementation
    protected void clearView() {
        this.clearViewCalled = true;
    }

    public boolean wasClearViewCalled() {
        return this.clearViewCalled;
    }

    @Implementation
    protected void onPause() {
        this.onPauseCalled = true;
    }

    public boolean wasOnPauseCalled() {
        return this.onPauseCalled;
    }

    @Implementation
    protected void onResume() {
        this.onResumeCalled = true;
    }

    public boolean wasOnResumeCalled() {
        return this.onResumeCalled;
    }

    @Implementation
    protected void destroy() {
        this.destroyCalled = true;
    }

    public boolean wasDestroyCalled() {
        return this.destroyCalled;
    }

    @Implementation(minSdk=26)
    public WebChromeClient getWebChromeClient() {
        return this.webChromeClient;
    }

    @Implementation
    protected boolean canGoBack() {
        if (this.canGoBackIsSet) {
            return this.canGoBack;
        }
        return this.historyIndex > 0;
    }

    @Implementation
    protected boolean canGoForward() {
        return this.historyIndex < this.history.size() - 1;
    }

    @Implementation
    protected void goBack() {
        if (this.canGoBack()) {
            ++this.goBackInvocations;
            if (this.canGoBackIsSet) {
                return;
            }
            --this.historyIndex;
            this.originalUrl = this.history.get(this.historyIndex);
        }
    }

    @Implementation
    protected void goForward() {
        if (this.canGoForward()) {
            ++this.goForwardInvocations;
            ++this.historyIndex;
            this.originalUrl = this.history.get(this.historyIndex);
        }
    }

    @Implementation
    protected void goBackOrForward(int steps) {
        if (steps == 0) {
            return;
        }
        if (steps > 0) {
            while (steps-- > 0) {
                this.goForward();
            }
            return;
        }
        while (steps++ < 0) {
            this.goBack();
        }
    }

    @Implementation
    protected WebBackForwardList copyBackForwardList() {
        return new BackForwardList(this.history, this.historyIndex);
    }

    @Implementation
    protected static String findAddress(String addr) {
        return null;
    }

    @Implementation(minSdk=26)
    protected static PackageInfo getCurrentWebViewPackage() {
        return packageInfo;
    }

    public static void setCurrentWebViewPackage(PackageInfo webViewPackageInfo) {
        packageInfo = webViewPackageInfo;
    }

    @Implementation
    protected Bitmap getFavicon() {
        return this.currentFavicon;
    }

    public void setFavicon(Bitmap favicon) {
        this.currentFavicon = favicon;
    }

    @Implementation
    protected void evaluateJavascript(String script, ValueCallback<String> callback) {
        this.lastEvaluatedJavascript = script;
        this.lastEvaluatedJavascriptCallback = callback;
    }

    public String getLastEvaluatedJavascript() {
        return this.lastEvaluatedJavascript;
    }

    public ValueCallback<String> getLastEvaluatedJavascriptCallback() {
        return this.lastEvaluatedJavascriptCallback;
    }

    @Deprecated
    public void setCanGoBack(boolean canGoBack) {
        this.canGoBackIsSet = true;
        this.canGoBack = canGoBack;
    }

    public int getGoBackInvocations() {
        return this.goBackInvocations;
    }

    public int getGoForwardInvocations() {
        return this.goForwardInvocations;
    }

    public LoadData getLastLoadData() {
        return this.lastLoadData;
    }

    public LoadDataWithBaseURL getLastLoadDataWithBaseURL() {
        return this.lastLoadDataWithBaseURL;
    }

    @Implementation
    protected WebBackForwardList saveState(Bundle outState) {
        if (!this.history.isEmpty()) {
            outState.putStringArrayList(HISTORY_KEY, this.history);
            outState.putInt(HISTORY_INDEX_KEY, this.historyIndex);
        }
        return new BackForwardList(this.history, this.historyIndex);
    }

    @Implementation
    protected WebBackForwardList restoreState(Bundle inState) {
        this.history = inState.getStringArrayList(HISTORY_KEY);
        if (this.history == null) {
            this.history = new ArrayList();
            this.historyIndex = -1;
        } else {
            this.historyIndex = inState.getInt(HISTORY_INDEX_KEY);
        }
        if (!this.history.isEmpty()) {
            this.originalUrl = this.history.get(this.historyIndex);
            this.lastUrl = this.history.get(this.historyIndex);
            return new BackForwardList(this.history, this.historyIndex);
        }
        return null;
    }

    @Implementation
    protected WebView.HitTestResult getHitTestResult() {
        return this.hitTestResult;
    }

    public static WebView.HitTestResult createHitTestResult(int type, String extra) {
        WebView.HitTestResult hitTestResult = new WebView.HitTestResult();
        hitTestResult.setType(type);
        hitTestResult.setExtra(extra);
        return hitTestResult;
    }

    public void setHitTestResult(WebView.HitTestResult hitTestResult) {
        this.hitTestResult = hitTestResult;
    }

    @Resetter
    public static void reset() {
        packageInfo = null;
    }

    @Implementation
    public static void setWebContentsDebuggingEnabled(boolean enabled) {
    }

    @Implementation
    protected void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Implementation
    protected void setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    public DownloadListener getDownloadListener() {
        return this.downloadListener;
    }

    private static enum PageLoadType {
        UNDEFINED,
        SUCCESS;

    }

    public static class LoadDataWithBaseURL {
        public final String baseUrl;
        public final String data;
        public final String mimeType;
        public final String encoding;
        public final String historyUrl;

        public LoadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
            this.baseUrl = baseUrl;
            this.data = data;
            this.mimeType = mimeType;
            this.encoding = encoding;
            this.historyUrl = historyUrl;
        }
    }

    public static class LoadData {
        public final String data;
        public final String mimeType;
        public final String encoding;

        public LoadData(String data, String mimeType, String encoding) {
            this.data = data;
            this.mimeType = mimeType;
            this.encoding = encoding;
        }
    }

    private static class BackForwardList
    extends WebBackForwardList {
        private final ArrayList<String> history;
        private final int index;

        public BackForwardList(ArrayList<String> history, int index) {
            this.history = (ArrayList)history.clone();
            this.index = index;
        }

        public int getCurrentIndex() {
            return this.index;
        }

        public int getSize() {
            return this.history.size();
        }

        public HistoryItem getCurrentItem() {
            if (this.history.isEmpty()) {
                return null;
            }
            return new HistoryItem(this.history.get(this.getCurrentIndex()));
        }

        public HistoryItem getItemAtIndex(int index) {
            return new HistoryItem(this.history.get(index));
        }

        protected WebBackForwardList clone() {
            return new BackForwardList(this.history, this.index);
        }
    }

    private static class HistoryItem
    extends WebHistoryItem {
        private final String url;

        public HistoryItem(String url) {
            this.url = url;
        }

        public int getId() {
            return this.url.hashCode();
        }

        public Bitmap getFavicon() {
            return null;
        }

        public String getOriginalUrl() {
            return this.url;
        }

        public String getTitle() {
            return this.url;
        }

        public String getUrl() {
            return this.url;
        }

        protected HistoryItem clone() {
            return new HistoryItem(this.url);
        }
    }
}

