/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Point;
import android.hardware.display.BrightnessChangeEvent;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.IDisplayManager;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.IMediaProjection;
import android.os.Handler;
import android.os.RemoteException;
import android.util.SparseArray;
import android.view.DisplayInfo;
import android.view.Surface;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.Bootstrap;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.SystemUi;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=DisplayManagerGlobal.class, isInAndroidSdk=false)
public class ShadowDisplayManagerGlobal {
    private static final String TOPOLOGY_LISTENERS_FIELD_NAME = "mTopologyListeners";
    private static DisplayManagerGlobal instance;
    private static final int EVENT_DISPLAY_BASIC_CHANGED = 2;
    private float saturationLevel = 1.0f;
    private final SparseArray<BrightnessConfiguration> brightnessConfiguration = new SparseArray();
    private final List<BrightnessChangeEvent> brightnessChangeEvents = new ArrayList<BrightnessChangeEvent>();
    private Object defaultBrightnessConfiguration;
    private DisplayManagerProxyDelegate mDm;

    @Resetter
    public static void reset() {
        instance = null;
    }

    @Implementation
    protected void __constructor__(IDisplayManager dm) {
    }

    @Implementation
    public static synchronized DisplayManagerGlobal getInstance() {
        if (instance == null) {
            DisplayManagerProxyDelegate displayManagerProxyDelegate = new DisplayManagerProxyDelegate();
            IDisplayManager proxy = (IDisplayManager)ReflectionHelpers.createDelegatingProxy(IDisplayManager.class, (Object)displayManagerProxyDelegate);
            instance = ShadowDisplayManagerGlobal.newDisplayManagerGlobal(proxy);
            ShadowDisplayManagerGlobal shadow = (ShadowDisplayManagerGlobal)Shadow.extract((Object)instance);
            shadow.mDm = displayManagerProxyDelegate;
            Bootstrap.setUpDisplay();
        }
        return instance;
    }

    private static DisplayManagerGlobal newDisplayManagerGlobal(IDisplayManager displayManager) {
        instance = (DisplayManagerGlobal)Shadow.newInstanceOf(DisplayManagerGlobal.class);
        DisplayManagerGlobalReflector displayManagerGlobal = (DisplayManagerGlobalReflector)Reflector.reflector(DisplayManagerGlobalReflector.class, (Object)instance);
        displayManagerGlobal.setDm(displayManager);
        displayManagerGlobal.setLock(new Object());
        List<Handler> displayListeners = ShadowDisplayManagerGlobal.createDisplayListeners();
        displayManagerGlobal.setDisplayListeners(displayListeners);
        displayManagerGlobal.setDisplayInfoCache((SparseArray<DisplayInfo>)new SparseArray());
        if (ReflectionHelpers.hasField(DisplayManagerGlobal.class, (String)TOPOLOGY_LISTENERS_FIELD_NAME)) {
            displayManagerGlobal.setTopologyListeners(new CopyOnWriteArrayList());
        }
        return instance;
    }

    private static List<Handler> createDisplayListeners() {
        try {
            Field f = DisplayManagerGlobal.class.getDeclaredField("mDisplayListeners");
            if (f.getType().isAssignableFrom(ArrayList.class)) {
                return new ArrayList<Handler>();
            }
            return new CopyOnWriteArrayList<Handler>();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static DisplayManagerGlobal getGlobalInstance() {
        return instance;
    }

    @Implementation
    protected WifiDisplayStatus getWifiDisplayStatus() {
        return new WifiDisplayStatus();
    }

    @Implementation(minSdk=27)
    public Point getStableDisplaySize() throws RemoteException {
        DisplayInfo defaultDisplayInfo = this.mDm.getDisplayInfo(0);
        return new Point(defaultDisplayInfo.getNaturalWidth(), defaultDisplayInfo.getNaturalHeight());
    }

    int addDisplay(DisplayInfo displayInfo) {
        this.fixNominalDimens(displayInfo);
        return this.mDm.addDisplay(displayInfo);
    }

    private void fixNominalDimens(DisplayInfo displayInfo) {
        int min = Math.min(displayInfo.appWidth, displayInfo.appHeight);
        int max = Math.max(displayInfo.appWidth, displayInfo.appHeight);
        displayInfo.smallestNominalAppHeight = displayInfo.smallestNominalAppWidth = min;
        displayInfo.largestNominalAppHeight = displayInfo.largestNominalAppWidth = max;
    }

    void changeDisplay(int displayId, DisplayInfo displayInfo) {
        this.mDm.changeDisplay(displayId, displayInfo);
    }

    void removeDisplay(int displayId) {
        this.mDm.removeDisplay(displayId);
    }

    SystemUi getSystemUi(int displayId) {
        return this.mDm.getSystemUi(displayId);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected void setSaturationLevel(float level) {
        if (level < 0.0f || level > 1.0f) {
            throw new IllegalArgumentException("Saturation level must be between 0 and 1");
        }
        this.saturationLevel = level;
    }

    float getSaturationLevel() {
        return this.saturationLevel;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected void setBrightnessConfigurationForUser(@ClassName(value="android.hardware.display.BrightnessConfiguration") @ClassName(value="android.hardware.display.BrightnessConfiguration") Object configObject, int userId, String packageName) {
        BrightnessConfiguration config = (BrightnessConfiguration)configObject;
        this.brightnessConfiguration.put(userId, (Object)config);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected @ClassName(value="android.hardware.display.BrightnessConfiguration") Object getBrightnessConfigurationForUser(int userId) {
        BrightnessConfiguration config = (BrightnessConfiguration)this.brightnessConfiguration.get(userId);
        if (config != null) {
            return config;
        }
        return this.getDefaultBrightnessConfiguration();
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected @ClassName(value="android.hardware.display.BrightnessConfiguration") Object getDefaultBrightnessConfiguration() {
        return this.defaultBrightnessConfiguration;
    }

    void setDefaultBrightnessConfiguration(@Nullable Object configObject) {
        BrightnessConfiguration config = (BrightnessConfiguration)configObject;
        this.defaultBrightnessConfiguration = config;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected List<BrightnessChangeEvent> getBrightnessEvents(String callingPackage) {
        return this.brightnessChangeEvents;
    }

    void setBrightnessEvents(List<BrightnessChangeEvent> events) {
        this.brightnessChangeEvents.clear();
        this.brightnessChangeEvents.addAll(events);
    }

    private static class DisplayManagerProxyDelegate {
        private final TreeMap<Integer, DisplayInfo> displayInfos = new TreeMap();
        private final Map<Integer, SystemUi> systemUis = new HashMap<Integer, SystemUi>();
        private int nextDisplayId = 0;
        private final List<IDisplayManagerCallback> callbacks = new CopyOnWriteArrayList<IDisplayManagerCallback>();
        private final Map<IVirtualDisplayCallback, Integer> virtualDisplayIds = new HashMap<IVirtualDisplayCallback, Integer>();

        private DisplayManagerProxyDelegate() {
        }

        public DisplayInfo getDisplayInfo(int i) throws RemoteException {
            DisplayInfo displayInfo = this.displayInfos.get(i);
            return displayInfo == null ? null : new DisplayInfo(displayInfo);
        }

        public int[] getDisplayIds() {
            int[] ids = new int[this.displayInfos.size()];
            int i = 0;
            for (Integer displayId : this.displayInfos.keySet()) {
                ids[i++] = displayId;
            }
            return ids;
        }

        public int[] getDisplayIds(boolean ignoredIncludeDisabled) {
            return this.getDisplayIds();
        }

        public SystemUi getSystemUi(int displayId) {
            return this.systemUis.get(displayId);
        }

        public void registerCallback(IDisplayManagerCallback iDisplayManagerCallback) throws RemoteException {
            this.callbacks.add(iDisplayManagerCallback);
        }

        public void registerCallbackWithEventMask(IDisplayManagerCallback iDisplayManagerCallback, long ignoredEventsMask) throws RemoteException {
            this.registerCallback(iDisplayManagerCallback);
        }

        public int createVirtualDisplay(@ClassName(value="android.hardware.display.VirtualDisplayConfig") @ClassName(value="android.hardware.display.VirtualDisplayConfig") Object virtualDisplayConfigObject, IVirtualDisplayCallback callbackWrapper, IMediaProjection projectionToken, String packageName) {
            VirtualDisplayConfig config = (VirtualDisplayConfig)virtualDisplayConfigObject;
            DisplayInfo displayInfo = new DisplayInfo();
            displayInfo.flags = config.getFlags();
            displayInfo.type = 5;
            displayInfo.name = config.getName();
            displayInfo.logicalDensityDpi = config.getDensityDpi();
            displayInfo.physicalXDpi = config.getDensityDpi();
            displayInfo.physicalYDpi = config.getDensityDpi();
            displayInfo.ownerPackageName = packageName;
            displayInfo.appWidth = config.getWidth();
            displayInfo.logicalWidth = config.getWidth();
            displayInfo.appHeight = config.getHeight();
            displayInfo.logicalHeight = config.getHeight();
            displayInfo.state = 2;
            int id2 = this.addDisplay(displayInfo);
            this.virtualDisplayIds.put(callbackWrapper, id2);
            return id2;
        }

        public int createVirtualDisplay(IVirtualDisplayCallback callbackWrapper, IMediaProjection projectionToken, String packageName, String name, int width, int height, int densityDpi, Surface surface, int flags, String uniqueId) {
            DisplayInfo displayInfo = new DisplayInfo();
            displayInfo.flags = flags;
            displayInfo.type = 5;
            displayInfo.name = name;
            displayInfo.logicalDensityDpi = densityDpi;
            displayInfo.physicalXDpi = densityDpi;
            displayInfo.physicalYDpi = densityDpi;
            displayInfo.ownerPackageName = packageName;
            displayInfo.appWidth = width;
            displayInfo.logicalWidth = width;
            displayInfo.appHeight = height;
            displayInfo.logicalHeight = height;
            displayInfo.state = 2;
            int id2 = this.addDisplay(displayInfo);
            this.virtualDisplayIds.put(callbackWrapper, id2);
            return id2;
        }

        public void resizeVirtualDisplay(IVirtualDisplayCallback token, int width, int height, int densityDpi) {
            Integer id2 = this.virtualDisplayIds.get(token);
            DisplayInfo displayInfo = this.displayInfos.get(id2);
            displayInfo.logicalDensityDpi = densityDpi;
            displayInfo.appWidth = width;
            displayInfo.logicalWidth = width;
            displayInfo.appHeight = height;
            displayInfo.logicalHeight = height;
            this.changeDisplay(id2, displayInfo);
        }

        public void releaseVirtualDisplay(IVirtualDisplayCallback token) {
            if (this.virtualDisplayIds.containsKey(token)) {
                this.removeDisplay(this.virtualDisplayIds.remove(token));
            }
        }

        public void setVirtualDisplayState(IVirtualDisplayCallback token, boolean isOn) {
            int newState;
            Integer id2 = this.virtualDisplayIds.get(token);
            DisplayInfo displayInfo = this.displayInfos.get(id2);
            int n = newState = isOn ? 2 : 1;
            if (displayInfo.state != newState) {
                displayInfo.state = newState;
                this.changeDisplay(id2, displayInfo);
            }
        }

        public void setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface) {
            this.setVirtualDisplayState(token, surface != null);
        }

        private synchronized int addDisplay(DisplayInfo displayInfo) {
            int nextId = this.nextDisplayId++;
            this.displayInfos.put(nextId, displayInfo);
            if (RuntimeEnvironment.getApiLevel() >= 29) {
                displayInfo.displayId = nextId;
            }
            this.systemUis.put(nextId, new SystemUi(nextId));
            this.notifyListeners(nextId, 1);
            return nextId;
        }

        private synchronized void changeDisplay(int displayId, DisplayInfo displayInfo) {
            if (!this.displayInfos.containsKey(displayId)) {
                throw new IllegalStateException("no display " + displayId);
            }
            this.displayInfos.put(displayId, displayInfo);
            this.notifyListeners(displayId, 2);
        }

        private synchronized void removeDisplay(int displayId) {
            if (!this.displayInfos.containsKey(displayId)) {
                throw new IllegalStateException("no display " + displayId);
            }
            this.displayInfos.remove(displayId);
            this.systemUis.remove(displayId);
            this.notifyListeners(displayId, 3);
        }

        private void notifyListeners(int nextId, int event) {
            for (IDisplayManagerCallback callback : this.callbacks) {
                try {
                    callback.onDisplayEvent(nextId, event);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @ForType(value=DisplayManagerGlobal.class)
    static interface DisplayManagerGlobalReflector {
        @Accessor(value="mDm")
        public void setDm(IDisplayManager var1);

        @Accessor(value="mLock")
        public void setLock(Object var1);

        @Accessor(value="mDisplayListeners")
        public void setDisplayListeners(List<Handler> var1);

        @Accessor(value="mDisplayInfoCache")
        public void setDisplayInfoCache(SparseArray<DisplayInfo> var1);

        @Accessor(value="mTopologyListeners")
        public void setTopologyListeners(CopyOnWriteArrayList<?> var1);
    }
}

