/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.os.Parcel;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthWcdma;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadows.CellIdentityWcdmaBuilder;
import org.robolectric.shadows.CellSignalStrengthWcdmaBuilder;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@RequiresApi(value=29)
public class CellInfoWcdmaBuilder {
    private boolean isRegistered = false;
    private long timeStamp = 0L;
    private int cellConnectionStatus = 0;
    private CellIdentityWcdma cellIdentity;
    private CellSignalStrengthWcdma cellSignalStrength;

    private CellInfoWcdmaBuilder() {
    }

    public static CellInfoWcdmaBuilder newBuilder() {
        return new CellInfoWcdmaBuilder();
    }

    public CellInfoWcdmaBuilder setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
        return this;
    }

    public CellInfoWcdmaBuilder setTimeStampNanos(long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public CellInfoWcdmaBuilder setCellConnectionStatus(int cellConnectionStatus) {
        this.cellConnectionStatus = cellConnectionStatus;
        return this;
    }

    public CellInfoWcdmaBuilder setCellIdentity(CellIdentityWcdma cellIdentity) {
        this.cellIdentity = cellIdentity;
        return this;
    }

    public CellInfoWcdmaBuilder setCellSignalStrength(CellSignalStrengthWcdma cellSignalStrength) {
        this.cellSignalStrength = cellSignalStrength;
        return this;
    }

    public CellInfoWcdma build() {
        if (this.cellIdentity == null) {
            this.cellIdentity = CellIdentityWcdmaBuilder.getDefaultInstance();
        }
        if (this.cellSignalStrength == null) {
            this.cellSignalStrength = CellSignalStrengthWcdmaBuilder.getDefaultInstance();
        }
        if (RuntimeEnvironment.getApiLevel() <= 33) {
            Parcel p = Parcel.obtain();
            p.writeInt(4);
            p.writeInt(this.isRegistered ? 1 : 0);
            p.writeLong(this.timeStamp);
            p.writeInt(this.cellConnectionStatus);
            this.cellIdentity.writeToParcel(p, 0);
            this.cellSignalStrength.writeToParcel(p, 0);
            p.setDataPosition(0);
            CellInfoWcdma cellInfoWcdma = (CellInfoWcdma)CellInfoWcdma.CREATOR.createFromParcel(p);
            p.recycle();
            return cellInfoWcdma;
        }
        return ((CellInfoWcdmaReflector)Reflector.reflector(CellInfoWcdmaReflector.class)).newCellInfoWcdma(this.cellConnectionStatus, this.isRegistered, this.timeStamp, this.cellIdentity, this.cellSignalStrength);
    }

    @ForType(value=CellInfoWcdma.class)
    private static interface CellInfoWcdmaReflector {
        @Constructor
        public CellInfoWcdma newCellInfoWcdma(int var1, boolean var2, long var3, CellIdentityWcdma var5, CellSignalStrengthWcdma var6);
    }
}

