/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.MessageQueue;
import android.view.DisplayEventReceiver;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.time.Duration;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowChoreographer;
import org.robolectric.shadows.ShadowPausedSystemClock;
import org.robolectric.shadows.ShadowSystem;
import org.robolectric.shadows.ShadowSystemClock;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

@Implements(className="android.view.DisplayEventReceiver", isInAndroidSdk=false)
public class ShadowDisplayEventReceiver {
    private static final NativeObjRegistry<NativeDisplayEventReceiver> nativeObjRegistry = new NativeObjRegistry(NativeDisplayEventReceiver.class);
    @RealObject
    protected DisplayEventReceiver realReceiver;
    @ReflectorObject
    private DisplayEventReceiverReflector displayEventReceiverReflector;

    @Implementation(minSdk=26, maxSdk=29)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue, int vsyncSource) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(receiver));
    }

    @Implementation(minSdk=23, maxSdk=25)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(receiver));
    }

    @Implementation(minSdk=30, maxSdk=33)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue, int vsyncSource, int configChanged) {
        return ShadowDisplayEventReceiver.nativeInit(receiver, msgQueue);
    }

    @Implementation(minSdk=34)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, WeakReference<Object> vsyncEventData, MessageQueue msgQueue, int vsyncSource, int eventRegistration, long layerHandle) {
        return ShadowDisplayEventReceiver.nativeInit(receiver, msgQueue);
    }

    @Implementation(maxSdk=33)
    protected static void nativeDispose(long receiverPtr) {
        NativeDisplayEventReceiver receiver = (NativeDisplayEventReceiver)nativeObjRegistry.unregister(receiverPtr);
        if (receiver != null) {
            receiver.dispose();
        }
    }

    @Implementation
    protected static void nativeScheduleVsync(long receiverPtr) {
        ((NativeDisplayEventReceiver)nativeObjRegistry.getNativeObject(receiverPtr)).scheduleVsync();
    }

    @Implementation(minSdk=33)
    protected static @ClassName(value="android.view.DisplayEventReceiver$VsyncEventData") Object nativeGetLatestVsyncEventData(long receiverPtr) {
        return ((NativeDisplayEventReceiver)nativeObjRegistry.getNativeObject(receiverPtr)).getLatestVsyncEventData();
    }

    @Implementation(maxSdk=30)
    protected void dispose(boolean finalized) {
        CloseGuard closeGuard = this.displayEventReceiverReflector.getCloseGuard();
        if (closeGuard != null) {
            closeGuard.close();
        }
        this.displayEventReceiverReflector.dispose(finalized);
    }

    protected void onVsync(long frameTimeNanos, int frame, Object vsyncEventData) {
        if (RuntimeEnvironment.getApiLevel() < 29) {
            this.displayEventReceiverReflector.onVsync(frameTimeNanos, 0, frame);
        } else if (RuntimeEnvironment.getApiLevel() < 31) {
            this.displayEventReceiverReflector.onVsync(ShadowSystem.nanoTime(), 0L, frame);
        } else {
            this.displayEventReceiverReflector.onVsync(ShadowSystem.nanoTime(), 0L, frame, vsyncEventData);
        }
    }

    void resetState() {
        if (this.realReceiver.getClass().getName().contains("FrameDisplayEventReceiver")) {
            FrameDisplayEventReceiverReflector frameReflector = (FrameDisplayEventReceiverReflector)Reflector.reflector(FrameDisplayEventReceiverReflector.class, (Object)this.realReceiver);
            frameReflector.setFrame(0);
            frameReflector.setHavePendingVsync(false);
            frameReflector.setTimestampNanos(0L);
        }
        long nativeReceiverPtr = ((DisplayEventReceiverReflector)Reflector.reflector(DisplayEventReceiverReflector.class, (Object)this.realReceiver)).getReceiverPtr();
        ((NativeDisplayEventReceiver)nativeObjRegistry.getNativeObject(nativeReceiverPtr)).resetState();
    }

    private static class NativeDisplayEventReceiver {
        private final WeakReference<DisplayEventReceiver> receiverRef;
        private final ShadowPausedSystemClock.Listener clockListener = this::onClockAdvanced;
        private int frame = 0;
        private Object latestVsyncEventData = null;

        public NativeDisplayEventReceiver(WeakReference<DisplayEventReceiver> receiverRef) {
            this.receiverRef = receiverRef;
            ShadowPausedSystemClock.addStaticListener(this.clockListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onClockAdvanced() {
            NativeDisplayEventReceiver nativeDisplayEventReceiver = this;
            synchronized (nativeDisplayEventReceiver) {
                long nextVsyncTime = ShadowChoreographer.getNextVsyncTimeNanos();
                if (nextVsyncTime == 0L || ShadowPausedSystemClock.uptimeNanos() < nextVsyncTime) {
                    return;
                }
                ShadowChoreographer.setNextVsyncTimeNanos(0L);
            }
            this.doVsync();
        }

        void dispose() {
            ShadowPausedSystemClock.removeListener(this.clockListener);
        }

        public void scheduleVsync() {
            Duration frameDelay = ShadowChoreographer.getFrameDelay();
            if (ShadowChoreographer.isPaused()) {
                if (ShadowChoreographer.getNextVsyncTimeNanos() < ShadowPausedSystemClock.uptimeNanos()) {
                    ShadowChoreographer.setNextVsyncTimeNanos(ShadowPausedSystemClock.uptimeNanos() + frameDelay.toNanos());
                }
            } else {
                ShadowSystemClock.advanceBy(frameDelay);
                this.doVsync();
            }
        }

        private void doVsync() {
            DisplayEventReceiver receiver = (DisplayEventReceiver)this.receiverRef.get();
            if (receiver != null) {
                ShadowDisplayEventReceiver shadowReceiver = (ShadowDisplayEventReceiver)Shadow.extract((Object)receiver);
                if (RuntimeEnvironment.getApiLevel() >= 31) {
                    this.latestVsyncEventData = NativeDisplayEventReceiver.newVsyncEventData(ShadowChoreographer.getFrameDelay().toNanos());
                }
                shadowReceiver.onVsync(ShadowSystem.nanoTime(), this.frame, this.latestVsyncEventData);
                ++this.frame;
            }
        }

        private static Object newVsyncEventData(long frameIntervalNanos) {
            VsyncEventDataReflector vsyncEventDataReflector = (VsyncEventDataReflector)Reflector.reflector(VsyncEventDataReflector.class);
            if (RuntimeEnvironment.getApiLevel() < 33) {
                return vsyncEventDataReflector.newVsyncEventData(1L, 10L, frameIntervalNanos);
            }
            try {
                Class<?> frameTimelineClass = Class.forName("android.view.DisplayEventReceiver$VsyncEventData$FrameTimeline");
                int timelineArrayLength = RuntimeEnvironment.getApiLevel() == 33 ? 1 : 7;
                FrameTimelineReflector frameTimelineReflector = (FrameTimelineReflector)Reflector.reflector(FrameTimelineReflector.class);
                Object timelineArray = Array.newInstance(frameTimelineClass, timelineArrayLength);
                for (int i = 0; i < timelineArrayLength; ++i) {
                    Array.set(timelineArray, i, frameTimelineReflector.newFrameTimeline(1L, 1L, 10L));
                }
                if (RuntimeEnvironment.getApiLevel() <= 33) {
                    return vsyncEventDataReflector.newVsyncEventData(timelineArray, 0, frameIntervalNanos);
                }
                boolean baklavaConstructor = ReflectionHelpers.hasConstructor(DisplayEventReceiver.VsyncEventData.class, (Class[])new Class[]{DisplayEventReceiver.VsyncEventData.FrameTimeline[].class, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE});
                if (RuntimeEnvironment.getApiLevel() < 36 || !baklavaConstructor) {
                    return vsyncEventDataReflector.newVsyncEventData(timelineArray, 0, timelineArrayLength, frameIntervalNanos);
                }
                return vsyncEventDataReflector.newVsyncEventData(timelineArray, 0, timelineArrayLength, frameIntervalNanos, 0);
            }
            catch (ClassNotFoundException e) {
                throw new LinkageError("Unable to construct VsyncEventData", e);
            }
        }

        public @ClassName(value="android.view.DisplayEventReceiver$VsyncEventData") Object getLatestVsyncEventData() {
            return this.latestVsyncEventData;
        }

        public void resetState() {
            this.frame = 0;
            this.latestVsyncEventData = null;
        }
    }

    @ForType(value=DisplayEventReceiver.class)
    protected static interface DisplayEventReceiverReflector {
        @Direct
        public void dispose(boolean var1);

        public void onVsync(long var1, int var3);

        public void onVsync(long var1, int var3, int var4);

        public void onVsync(long var1, long var3, int var5);

        public void onVsync(long var1, long var3, int var5, @WithType(value="android.view.DisplayEventReceiver$VsyncEventData") Object var6);

        @Accessor(value="mCloseGuard")
        public CloseGuard getCloseGuard();

        @Accessor(value="mReceiverPtr")
        public long getReceiverPtr();
    }

    @ForType(className="android.view.Choreographer$FrameDisplayEventReceiver")
    static interface FrameDisplayEventReceiverReflector {
        @Accessor(value="mHavePendingVsync")
        public void setHavePendingVsync(boolean var1);

        @Accessor(value="mTimestampNanos")
        public void setTimestampNanos(long var1);

        @Accessor(value="mFrame")
        public void setFrame(int var1);
    }

    @ForType(className="android.view.DisplayEventReceiver$VsyncEventData$FrameTimeline")
    static interface FrameTimelineReflector {
        @Constructor
        public Object newFrameTimeline(long var1, long var3, long var5);
    }

    @ForType(className="android.view.DisplayEventReceiver$VsyncEventData")
    static interface VsyncEventDataReflector {
        @Constructor
        public Object newVsyncEventData(long var1, long var3, long var5);

        @Constructor
        public Object newVsyncEventData(@WithType(value="[Landroid.view.DisplayEventReceiver$VsyncEventData$FrameTimeline;") Object var1, int var2, long var3);

        @Constructor
        public Object newVsyncEventData(@WithType(value="[Landroid.view.DisplayEventReceiver$VsyncEventData$FrameTimeline;") Object var1, int var2, int var3, long var4);

        @Constructor
        public Object newVsyncEventData(@WithType(value="[Landroid.view.DisplayEventReceiver$VsyncEventData$FrameTimeline;") Object var1, int var2, int var3, long var4, int var6);
    }
}

