/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.time.Duration;
import java.util.ArrayList;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowMessage;
import org.robolectric.shadows.ShadowMessageQueue;
import org.robolectric.shadows.ShadowPausedMessage;
import org.robolectric.shadows.ShadowPausedSystemClock;
import org.robolectric.util.Scheduler;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=MessageQueue.class, isInAndroidSdk=false)
public class ShadowPausedMessageQueue
extends ShadowMessageQueue {
    @RealObject
    private MessageQueue realQueue;
    private static final NativeObjRegistry<ShadowPausedMessageQueue> nativeQueueRegistry = new NativeObjRegistry(ShadowPausedMessageQueue.class);
    private boolean isPolling = false;
    private ShadowPausedSystemClock.Listener clockListener;
    private Exception uncaughtException = null;
    @GuardedBy(value="realQueue")
    private boolean pendingWake;

    @Implementation
    protected void __constructor__(boolean quitAllowed) {
        ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).__constructor__(quitAllowed);
        long ptr = nativeQueueRegistry.register((Object)this);
        ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).setPtr(ptr);
        this.clockListener = () -> {
            MessageQueue messageQueue = this.realQueue;
            synchronized (messageQueue) {
                if (!this.realQueue.isIdle()) {
                    ShadowPausedMessageQueue.nativeWake(ptr);
                }
            }
        };
        ShadowPausedSystemClock.addStaticListener(this.clockListener);
    }

    @Implementation
    protected static void nativeDestroy(long ptr) {
        ShadowPausedMessageQueue q = (ShadowPausedMessageQueue)nativeQueueRegistry.unregister(ptr);
        ShadowPausedSystemClock.removeListener(q.clockListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=23)
    protected void nativePollOnce(long ptr, int timeoutMillis) {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            this.isPolling = true;
            try {
                if (!this.pendingWake && timeoutMillis != 0) {
                    this.realQueue.wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.isPolling = false;
            this.pendingWake = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void poll(long timeout) {
        Preconditions.checkState((Looper.myLooper() == Looper.getMainLooper() && Looper.myQueue() == this.realQueue ? 1 : 0) != 0);
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            if (this.realQueue.isIdle()) {
                ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).setBlocked(true);
                try {
                    this.pendingWake = false;
                    this.realQueue.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).setBlocked(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static void nativeWake(long ptr) {
        MessageQueue realQueue = ((ShadowPausedMessageQueue)ShadowPausedMessageQueue.nativeQueueRegistry.getNativeObject((long)ptr)).realQueue;
        ShadowPausedMessageQueue shadowPausedMessageQueue = (ShadowPausedMessageQueue)Shadow.extract((Object)realQueue);
        MessageQueue messageQueue = shadowPausedMessageQueue.realQueue;
        synchronized (messageQueue) {
            shadowPausedMessageQueue.pendingWake = true;
            realQueue.notifyAll();
        }
    }

    @Implementation(minSdk=23)
    protected static boolean nativeIsPolling(long ptr) {
        return ((ShadowPausedMessageQueue)ShadowPausedMessageQueue.nativeQueueRegistry.getNativeObject((long)ptr)).isPolling;
    }

    @Implementation(minSdk=23)
    public boolean isIdle() {
        return ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).isIdle();
    }

    Message peekNextExecutableMessage() {
        MessageQueueReflector internalQueue = (MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue);
        Message msg = internalQueue.getMessages();
        if (msg != null && ShadowPausedMessageQueue.shadowOfMsg(msg).getTarget() == null) {
            while ((msg = ShadowPausedMessageQueue.shadowOfMsg(msg).internalGetNext()) != null && !msg.isAsynchronous()) {
            }
        }
        return msg;
    }

    Message getNext() {
        return ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).next();
    }

    boolean isQuitAllowed() {
        return ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).getQuitAllowed();
    }

    @VisibleForTesting
    void doEnqueueMessage(Message msg, long when) {
        this.enqueueMessage(msg, when);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean enqueueMessage(Message msg, long when) {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            if (this.uncaughtException != null) {
                IllegalStateException e = new IllegalStateException(msg.getTarget() + " sending message to a Looper thread that has died due to an uncaught exception", this.uncaughtException);
                Log.w((String)"ShadowPausedMessageQueue", (Throwable)e);
                msg.recycle();
                throw e;
            }
            return ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).enqueueMessage(msg, when);
        }
    }

    Message getMessages() {
        return ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).getMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=23)
    protected boolean isPolling() {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            return this.isPolling;
        }
    }

    void quit() {
        this.quit(true);
    }

    @Implementation
    protected void quit(boolean allowed) {
        ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).quit(allowed);
        ShadowPausedSystemClock.removeListener(this.clockListener);
    }

    boolean isQuitting() {
        return ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).getQuitting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Duration getLastScheduledTaskTime() {
        long when = 0L;
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            Message next = this.getMessages();
            if (next == null) {
                return Duration.ZERO;
            }
            while (next != null) {
                if (next.getTarget() != null) {
                    when = ShadowPausedMessageQueue.shadowOfMsg(next).getWhen();
                }
                next = ShadowPausedMessageQueue.shadowOfMsg(next).internalGetNext();
            }
        }
        return Duration.ofMillis(ShadowPausedMessageQueue.convertWhenToScheduledTime(when));
    }

    static long convertWhenToScheduledTime(long when) {
        if (when < SystemClock.uptimeMillis()) {
            when = SystemClock.uptimeMillis();
        }
        return when;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internalGetSize() {
        int count = 0;
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            Message next = this.getMessages();
            while (next != null) {
                if (next.getTarget() != null) {
                    ++count;
                }
                next = ShadowPausedMessageQueue.shadowOfMsg(next).internalGetNext();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message getNextIgnoringWhen() {
        MessageQueueReflector queueReflector = (MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue);
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            Message prevMsg = null;
            Message msg = this.getMessages();
            if (msg != null && msg.getTarget() == null) {
                do {
                    prevMsg = msg;
                } while ((msg = ShadowPausedMessageQueue.shadowOfMsg(msg).internalGetNext()) != null && !msg.isAsynchronous());
            }
            if (msg != null) {
                Message nextMsg = ((ShadowMessage.MessageReflector)Reflector.reflector(ShadowMessage.MessageReflector.class, (Object)msg)).getNext();
                if (prevMsg != null) {
                    ((ShadowMessage.MessageReflector)Reflector.reflector(ShadowMessage.MessageReflector.class, (Object)prevMsg)).setNext(nextMsg);
                    if (((ShadowMessage.MessageReflector)Reflector.reflector(ShadowMessage.MessageReflector.class, (Object)prevMsg)).getNext() == null && RuntimeEnvironment.getApiLevel() >= 35) {
                        queueReflector.setLast(prevMsg);
                    }
                } else {
                    queueReflector.setMessages(nextMsg);
                    if (nextMsg == null && RuntimeEnvironment.getApiLevel() >= 35) {
                        queueReflector.setLast(null);
                    }
                }
                if (msg.isAsynchronous() && RuntimeEnvironment.getApiLevel() >= 35) {
                    queueReflector.setAsyncMessageCount(queueReflector.getAsyncMessageCount() - 1);
                }
            }
            return msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        MessageQueueReflector msgQueue = (MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue);
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            msgQueue.setMessages(null);
            msgQueue.setIdleHandlers(new ArrayList<MessageQueue.IdleHandler>());
            msgQueue.setNextBarrierToken(0);
            if (RuntimeEnvironment.getApiLevel() >= 35) {
                msgQueue.setLast(null);
                msgQueue.setAsyncMessageCount(0);
            }
            this.pendingWake = false;
        }
        this.setUncaughtException(null);
    }

    private static ShadowPausedMessage shadowOfMsg(Message head) {
        return (ShadowPausedMessage)Shadow.extract((Object)head);
    }

    @Override
    public Scheduler getScheduler() {
        throw new UnsupportedOperationException("Not supported in PAUSED LooperMode.");
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        throw new UnsupportedOperationException("Not supported in PAUSED LooperMode.");
    }

    @Override
    public Message getHead() {
        throw new UnsupportedOperationException("Not supported in PAUSED LooperMode.");
    }

    @Override
    public void setHead(Message msg) {
        throw new UnsupportedOperationException("Not supported in PAUSED LooperMode.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<MessageQueue.IdleHandler> getIdleHandlersCopy() {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            return new ArrayList<MessageQueue.IdleHandler>(((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).getIdleHandlers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUncaughtException(Exception e) {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            this.uncaughtException = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasUncaughtException() {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            return this.uncaughtException != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkQueueState() {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            if (this.uncaughtException != null) {
                throw new IllegalStateException("Looper thread that has died due to an uncaught exception", this.uncaughtException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drainQueue(Predicate<Runnable> msgProcessor) {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            Message msg = this.getMessages();
            while (msg != null) {
                boolean unused = msgProcessor.apply((Object)msg.getCallback());
                Message next = ShadowPausedMessageQueue.shadowOfMsg(msg).internalGetNext();
                ShadowPausedMessageQueue.shadowOfMsg(msg).recycleUnchecked();
                msg = next;
            }
            ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).setMessages(null);
            if (RuntimeEnvironment.getApiLevel() >= 35) {
                ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).setLast(null);
                ((MessageQueueReflector)Reflector.reflector(MessageQueueReflector.class, (Object)this.realQueue)).setAsyncMessageCount(0);
            }
        }
    }

    @ForType(value=MessageQueue.class)
    private static interface MessageQueueReflector {
        @Direct
        public void __constructor__(boolean var1);

        @Direct
        public boolean enqueueMessage(Message var1, long var2);

        public Message next();

        @Accessor(value="mMessages")
        public void setMessages(Message var1);

        @Accessor(value="mMessages")
        public Message getMessages();

        @Accessor(value="mIdleHandlers")
        public void setIdleHandlers(ArrayList<MessageQueue.IdleHandler> var1);

        @Accessor(value="mIdleHandlers")
        public ArrayList<MessageQueue.IdleHandler> getIdleHandlers();

        @Accessor(value="mNextBarrierToken")
        public void setNextBarrierToken(int var1);

        @Accessor(value="mQuitAllowed")
        public boolean getQuitAllowed();

        @Accessor(value="mPtr")
        public void setPtr(long var1);

        @Direct
        public void quit(boolean var1);

        @Accessor(value="mQuitting")
        public boolean getQuitting();

        @Accessor(value="mLast")
        public void setLast(Message var1);

        @Accessor(value="mAsyncMessageCount")
        public int getAsyncMessageCount();

        @Accessor(value="mAsyncMessageCount")
        public void setAsyncMessageCount(int var1);

        @Accessor(value="mBlocked")
        public void setBlocked(boolean var1);

        @Direct
        public boolean isIdle();
    }
}

