/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.text.format.Time;
import android.util.TimeFormatException;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Time.class)
public class ShadowTime {
    @RealObject
    private Time time;
    private static final long SECOND_IN_MILLIS = 1000L;
    private static final long MINUTE_IN_MILLIS = 60000L;
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long DAY_IN_MILLIS = 86400000L;

    @Implementation
    protected static int getChar(String s, int spos, int mul) {
        char c = s.charAt(spos);
        if (Character.isDigit(c)) {
            return Character.getNumericValue(c) * mul;
        }
        ShadowTime.throwTimeFormatException("Parse error at pos=" + spos);
        return -1;
    }

    @Implementation
    @SuppressLint(value={"DefaultLocale"})
    protected void checkChar(String s, int spos, char expected) {
        char c = s.charAt(spos);
        if (c != expected) {
            ShadowTime.throwTimeFormatException(String.format("Unexpected character 0x%02d at pos=%d.  Expected 0x%02d ('%c').", c, spos, (int)expected, Character.valueOf(expected)));
        }
    }

    private static void throwTimeFormatException(String optionalMessage) {
        throw (TimeFormatException)ReflectionHelpers.callConstructor(TimeFormatException.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)(optionalMessage == null ? "fail" : optionalMessage))});
    }
}

