/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.graphics.Insets;
import android.graphics.Rect;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.InsetsState;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowViewRootImpl;
import org.robolectric.shadows.ShadowWindowManager;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=WindowManagerImpl.class, isInAndroidSdk=false)
public class ShadowWindowManagerImpl
extends ShadowWindowManager {
    @RealObject
    WindowManagerImpl realObject;
    private static final Multimap<Integer, View> views = ArrayListMultimap.create();
    public static final int NEW_INSETS_MODE_FULL = 2;

    @Implementation
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        views.put((Object)this.realObject.getDefaultDisplay().getDisplayId(), (Object)view);
        ((ReflectorWindowManagerImpl)Reflector.reflector(ReflectorWindowManagerImpl.class, (Object)this.realObject)).addView(view, layoutParams);
    }

    @Implementation
    public void removeView(View view) {
        views.remove((Object)this.realObject.getDefaultDisplay().getDisplayId(), (Object)view);
        ((ReflectorWindowManagerImpl)Reflector.reflector(ReflectorWindowManagerImpl.class, (Object)this.realObject)).removeView(view);
    }

    @Implementation
    protected void removeViewImmediate(View view) {
        views.remove((Object)this.realObject.getDefaultDisplay().getDisplayId(), (Object)view);
        ((ReflectorWindowManagerImpl)Reflector.reflector(ReflectorWindowManagerImpl.class, (Object)this.realObject)).removeViewImmediate(view);
    }

    public List<View> getViews() {
        return ImmutableList.copyOf((Collection)views.get((Object)this.realObject.getDefaultDisplay().getDisplayId()));
    }

    @Implementation(minSdk=30, maxSdk=32)
    protected WindowInsets getWindowInsetsFromServer(WindowManager.LayoutParams attrs, Rect bounds) {
        Context context = ((ReflectorWindowManagerImpl)Reflector.reflector(ReflectorWindowManagerImpl.class, (Object)this.realObject)).getContext();
        Rect systemWindowInsets = new Rect();
        Rect stableInsets = new Rect();
        DisplayCutout.ParcelableWrapper displayCutout = new DisplayCutout.ParcelableWrapper();
        InsetsState insetsState = new InsetsState();
        boolean alwaysConsumeSystemBars = true;
        boolean isScreenRound = context.getResources().getConfiguration().isScreenRound();
        if (RuntimeEnvironment.getApiLevel() <= 30 && ((ShadowViewRootImpl.ViewRootImplReflector)Reflector.reflector(ShadowViewRootImpl.ViewRootImplReflector.class)).getNewInsetsMode() == 2) {
            return (WindowInsets)ReflectionHelpers.callInstanceMethod((Object)insetsState, (String)"calculateInsets", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Rect.class, (Object)bounds), ReflectionHelpers.ClassParameter.from(InsetsState.class, null), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)isScreenRound), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true), ReflectionHelpers.ClassParameter.from(DisplayCutout.class, (Object)displayCutout.get()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)48), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(SparseIntArray.class, null)});
        }
        return new WindowInsets.Builder().setRound(isScreenRound).setSystemWindowInsets(Insets.of((Rect)systemWindowInsets)).setStableInsets(Insets.of((Rect)stableInsets)).setDisplayCutout(displayCutout.get()).build();
    }

    @Resetter
    public static void reset() {
        views.clear();
    }

    @ForType(value=WindowManagerImpl.class)
    static interface ReflectorWindowManagerImpl {
        @Direct
        public void addView(View var1, ViewGroup.LayoutParams var2);

        @Direct
        public void removeView(View var1);

        @Direct
        public void removeViewImmediate(View var1);

        @Direct
        public Display getDefaultDisplay();

        @Accessor(value="mContext")
        public Context getContext();
    }
}

