package org.robolectric.shadows;

import android.content.Context;
import android.provider.Telephony;
import android.provider.Telephony.Sms;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(Telephony.class)
public class ShadowTelephony {
  @Implements(Sms.class)
  public static class ShadowSms {
    @Nullable private static String defaultSmsPackage;

    @Implementation
    protected static String getDefaultSmsPackage(Context context) {
      return defaultSmsPackage;
    }

    /**
     * Override the package name returned from calling {@link Sms#getDefaultSmsPackage(Context)}.
     *
     * <p>This will be reset for the next test.
     */
    public static void setDefaultSmsPackage(@Nullable String defaultSmsPackage) {
      ShadowSms.defaultSmsPackage = defaultSmsPackage;
    }

    @Resetter
    public static synchronized void reset() {
      defaultSmsPackage = null;
    }
  }
}
