/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.RecordingCanvas;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.RecordingCanvasNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowNativeBaseRecordingCanvas;
import org.robolectric.shadows.ShadowRecordingCanvas;

@Implements(value=RecordingCanvas.class, minSdk=29, shadowPicker=Picker.class, callNativeMethodsByDefault=true)
public class ShadowNativeRecordingCanvas
extends ShadowNativeBaseRecordingCanvas {
    private static final Map<Long, Long> recordingCanvasToRenderNode = Collections.synchronizedMap(new HashMap());

    @Implementation(maxSdk=34)
    protected static long nCreateDisplayListCanvas(long node, int width, int height) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        long result = RecordingCanvasNatives.nCreateDisplayListCanvas((long)node, (int)width, (int)height);
        recordingCanvasToRenderNode.put(result, node);
        return result;
    }

    @Implementation(maxSdk=34)
    protected static void nResetDisplayListCanvas(long canvas, long node, int width, int height) {
        RecordingCanvasNatives.nResetDisplayListCanvas((long)canvas, (long)node, (int)width, (int)height);
        recordingCanvasToRenderNode.put(canvas, node);
    }

    @Implementation(maxSdk=34)
    protected static int nGetMaximumTextureWidth() {
        return RecordingCanvasNatives.nGetMaximumTextureWidth();
    }

    @Implementation(maxSdk=34)
    protected static int nGetMaximumTextureHeight() {
        return RecordingCanvasNatives.nGetMaximumTextureHeight();
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nEnableZ(long renderer, boolean enableZ) {
        RecordingCanvasNatives.nEnableZ((long)renderer, (boolean)enableZ);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nFinishRecording(long renderer, long renderNode) {
        RecordingCanvasNatives.nFinishRecording((long)renderer, (long)renderNode);
    }

    @Implementation(minSdk=29, maxSdk=30)
    protected static long nFinishRecording(long renderer) {
        Long renderNode = recordingCanvasToRenderNode.get(renderer);
        if (renderNode != null && renderNode != 0L) {
            RecordingCanvasNatives.nFinishRecording((long)renderer, (long)renderNode);
        }
        return 0L;
    }

    @Implementation(maxSdk=34)
    protected static void nDrawRenderNode(long renderer, long renderNode) {
        RecordingCanvasNatives.nDrawRenderNode((long)renderer, (long)renderNode);
    }

    @Implementation(maxSdk=34)
    protected static void nDrawTextureLayer(long renderer, long layer) {
        RecordingCanvasNatives.nDrawTextureLayer((long)renderer, (long)layer);
    }

    @Implementation(maxSdk=34)
    protected static void nDrawCircle(long renderer, long propCx, long propCy, long propRadius, long propPaint) {
        RecordingCanvasNatives.nDrawCircle((long)renderer, (long)propCx, (long)propCy, (long)propRadius, (long)propPaint);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nDrawRipple(long renderer, long propCx, long propCy, long propRadius, long propPaint, long propProgress, long turbulencePhase, int color, long runtimeEffect) {
        RecordingCanvasNatives.nDrawRipple((long)renderer, (long)propCx, (long)propCy, (long)propRadius, (long)propPaint, (long)propProgress, (long)turbulencePhase, (int)color, (long)runtimeEffect);
    }

    @Implementation(maxSdk=34)
    protected static void nDrawRoundRect(long renderer, long propLeft, long propTop, long propRight, long propBottom, long propRx, long propRy, long propPaint) {
        RecordingCanvasNatives.nDrawRoundRect((long)renderer, (long)propLeft, (long)propTop, (long)propRight, (long)propBottom, (long)propRx, (long)propRy, (long)propPaint);
    }

    @Implementation(maxSdk=34)
    protected static void nDrawWebViewFunctor(long canvas, int functor) {
        RecordingCanvasNatives.nDrawWebViewFunctor((long)canvas, (int)functor);
    }

    @Implementation(maxSdk=30)
    protected static void nInsertReorderBarrier(long renderer, boolean enableReorder) {
        ShadowNativeRecordingCanvas.nEnableZ(renderer, enableReorder);
    }

    @Resetter
    public static void reset() {
        recordingCanvasToRenderNode.clear();
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowRecordingCanvas.class, ShadowNativeRecordingCanvas.class);
        }
    }
}

