/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.system.ErrnoException;
import android.system.StructStat;
import java.io.File;
import java.io.FileDescriptor;
import java.time.Duration;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowOsConstants;

@Implements(className="libcore.io.Posix", maxSdk=25, isInAndroidSdk=false)
public class ShadowPosix {
    @Implementation
    public void mkdir(String path, int mode) throws ErrnoException {
        new File(path).mkdirs();
    }

    @Implementation
    public static @ClassName(value="android.system.StructStat") Object stat(String path) throws ErrnoException {
        int mode = ShadowOsConstants.getMode(path);
        long size = 0L;
        long modifiedTime = 0L;
        if (path != null) {
            File file = new File(path);
            size = file.length();
            modifiedTime = Duration.ofMillis(file.lastModified()).getSeconds();
        }
        return new StructStat(1L, 0L, mode, 0L, 0, 0, 0L, size, 0L, modifiedTime, 0L, 0L, 0L);
    }

    @Implementation
    protected static @ClassName(value="android.system.StructStat") Object lstat(String path) throws ErrnoException {
        return ShadowPosix.stat(path);
    }

    @Implementation
    protected static @ClassName(value="android.system.StructStat") Object fstat(FileDescriptor fd) throws ErrnoException {
        return ShadowPosix.stat(null);
    }
}

