/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Rect;
import android.view.Display;
import android.view.HandlerActionQueue;
import android.view.IWindow;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import android.view.WindowManager;
import java.util.ArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowView;
import org.robolectric.shadows.ShadowWindowManagerGlobal;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=ViewRootImpl.class, isInAndroidSdk=false)
public class ShadowViewRootImpl {
    @RealObject
    protected ViewRootImpl realObject;

    @Implementation
    public void playSoundEffect(int effectId) {
    }

    public void callDispatchResized() {
        ShadowWindowManagerGlobal.notifyResize(((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).getWindow());
    }

    protected Display getDisplay() {
        return ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).getDisplay();
    }

    @Implementation(minSdk=33)
    protected void updateBlastSurfaceIfNeeded() {
    }

    @Resetter
    public static void reset() {
        ViewRootImplReflector viewRootImplStatic = (ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class);
        viewRootImplStatic.setRunQueues(new ThreadLocal<HandlerActionQueue>());
        viewRootImplStatic.setFirstDrawHandlers(new ArrayList<Runnable>());
        viewRootImplStatic.setFirstDrawComplete(false);
        viewRootImplStatic.setConfigCallbacks(new ArrayList<ViewRootImpl.ConfigChangedCallback>());
    }

    public void callWindowFocusChanged(boolean hasFocus) {
        if (RuntimeEnvironment.getApiLevel() <= 32) {
            ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).windowFocusChanged(hasFocus, ShadowWindowManagerGlobal.getInTouchMode());
        } else {
            ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).windowFocusChanged(hasFocus);
        }
    }

    Surface getSurface() {
        return ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).getSurface();
    }

    ThreadedRenderer getThreadedRenderer() {
        Object attachInfo = ((ViewRootImplReflector)Reflector.reflector(ViewRootImplReflector.class, (Object)this.realObject)).getAttachInfo();
        return ((ShadowView.AttachInfoReflector)Reflector.reflector(ShadowView.AttachInfoReflector.class, (Object)attachInfo)).getThreadedRenderer();
    }

    static {
        if (RuntimeEnvironment.getApiLevel() == 30) {
            ReflectionHelpers.setStaticField(ViewRootImpl.class, (String)"sNewInsetsMode", (Object)2);
        }
    }

    @ForType(value=ViewRootImpl.class)
    protected static interface ViewRootImplReflector {
        @Accessor(value="mWindow")
        public IWindow getWindow();

        @Direct
        public void setView(View var1, WindowManager.LayoutParams var2, View var3);

        @Direct
        public void setView(View var1, WindowManager.LayoutParams var2, View var3, int var4);

        @Static
        @Accessor(value="sRunQueues")
        public void setRunQueues(ThreadLocal<HandlerActionQueue> var1);

        @Static
        @Accessor(value="sFirstDrawHandlers")
        public void setFirstDrawHandlers(ArrayList<Runnable> var1);

        @Static
        @Accessor(value="sFirstDrawComplete")
        public void setFirstDrawComplete(boolean var1);

        @Static
        @Accessor(value="sConfigCallbacks")
        public void setConfigCallbacks(ArrayList<ViewRootImpl.ConfigChangedCallback> var1);

        @Accessor(value="sNewInsetsMode")
        @Static
        public int getNewInsetsMode();

        @Accessor(value="mWinFrame")
        public void setWinFrame(Rect var1);

        @Accessor(value="mDisplay")
        public Display getDisplay();

        @Accessor(value="mSurfaceControl")
        public SurfaceControl getSurfaceControl();

        @Accessor(value="mSurface")
        public Surface getSurface();

        @Accessor(value="mWindowAttributes")
        public WindowManager.LayoutParams getWindowAttributes();

        @Accessor(value="mAttachInfo")
        public Object getAttachInfo();

        public void windowFocusChanged(boolean var1, boolean var2);

        public void windowFocusChanged(boolean var1);

        @Direct
        public WindowInsets getWindowInsets(boolean var1);
    }
}

