/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.telephony.CellSignalStrength;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthNr;
import android.telephony.CellSignalStrengthTdscdma;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.SignalStrength;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public class SignalStrengthBuilder {
    private ImmutableList<CellSignalStrength> cellSignalStrengths = ImmutableList.of();

    private SignalStrengthBuilder() {
    }

    public static SignalStrengthBuilder newBuilder() {
        return new SignalStrengthBuilder();
    }

    @RequiresApi(value=29)
    public SignalStrengthBuilder setCellSignalStrengths(List<CellSignalStrength> cellSignalStrengths) {
        this.cellSignalStrengths = ImmutableList.copyOf(cellSignalStrengths);
        return this;
    }

    public SignalStrength build() {
        int apiLevel = RuntimeEnvironment.getApiLevel();
        SignalStrength signalStrength = ((SignalStrengthReflector)Reflector.reflector(SignalStrengthReflector.class)).newSignalStrength();
        SignalStrengthReflector signalStrengthReflector = (SignalStrengthReflector)Reflector.reflector(SignalStrengthReflector.class, (Object)signalStrength);
        if (apiLevel > 28) {
            for (CellSignalStrength cellSignalStrength : this.cellSignalStrengths) {
                if (cellSignalStrength instanceof CellSignalStrengthCdma) {
                    signalStrengthReflector.setCellSignalStrengthCdma((CellSignalStrengthCdma)cellSignalStrength);
                    continue;
                }
                if (cellSignalStrength instanceof CellSignalStrengthGsm) {
                    signalStrengthReflector.setCellSignalStrengthGsm((CellSignalStrengthGsm)cellSignalStrength);
                    continue;
                }
                if (cellSignalStrength instanceof CellSignalStrengthWcdma) {
                    signalStrengthReflector.setCellSignalStrengthWcdma((CellSignalStrengthWcdma)cellSignalStrength);
                    continue;
                }
                if (cellSignalStrength instanceof CellSignalStrengthTdscdma) {
                    signalStrengthReflector.setCellSignalStrengthTdscdma((CellSignalStrengthTdscdma)cellSignalStrength);
                    continue;
                }
                if (cellSignalStrength instanceof CellSignalStrengthLte) {
                    signalStrengthReflector.setCellSignalStrengthLte((CellSignalStrengthLte)cellSignalStrength);
                    continue;
                }
                if (cellSignalStrength instanceof CellSignalStrengthNr) {
                    signalStrengthReflector.setCellSignalStrengthNr((CellSignalStrengthNr)cellSignalStrength);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported CellSignalStrength type: " + cellSignalStrength.getClass().getName());
            }
        }
        return signalStrength;
    }

    @ForType(value=SignalStrength.class)
    private static interface SignalStrengthReflector {
        @Constructor
        public SignalStrength newSignalStrength();

        @Accessor(value="mCdma")
        public void setCellSignalStrengthCdma(CellSignalStrengthCdma var1);

        @Accessor(value="mGsm")
        public void setCellSignalStrengthGsm(CellSignalStrengthGsm var1);

        @Accessor(value="mWcdma")
        public void setCellSignalStrengthWcdma(CellSignalStrengthWcdma var1);

        @Accessor(value="mTdscdma")
        public void setCellSignalStrengthTdscdma(CellSignalStrengthTdscdma var1);

        @Accessor(value="mLte")
        public void setCellSignalStrengthLte(CellSignalStrengthLte var1);

        @Accessor(value="mNr")
        public void setCellSignalStrengthNr(CellSignalStrengthNr var1);
    }
}

