/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.FingerprintManager;
import android.os.CancellationSignal;
import android.os.Handler;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=FingerprintManager.class)
public class ShadowFingerprintManager {
    private static final String TAG = "ShadowFingerprintManager";
    private boolean isHardwareDetected;
    private FingerprintManager.CryptoObject pendingCryptoObject;
    private FingerprintManager.AuthenticationCallback pendingCallback;
    private List<Fingerprint> fingerprints = Collections.emptyList();

    public void authenticationSucceeds() {
        if (this.pendingCallback == null) {
            throw new IllegalStateException("No active fingerprint authentication request.");
        }
        FingerprintManager.AuthenticationResult result = RuntimeEnvironment.getApiLevel() >= 25 ? new FingerprintManager.AuthenticationResult(this.pendingCryptoObject, null, 0) : (FingerprintManager.AuthenticationResult)ReflectionHelpers.callConstructor(FingerprintManager.AuthenticationResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(FingerprintManager.CryptoObject.class, (Object)this.pendingCryptoObject), ReflectionHelpers.ClassParameter.from(Fingerprint.class, null)});
        this.pendingCallback.onAuthenticationSucceeded(result);
    }

    public void authenticationFails() {
        if (this.pendingCallback == null) {
            throw new IllegalStateException("No active fingerprint authentication request.");
        }
        this.pendingCallback.onAuthenticationFailed();
    }

    @Implementation(minSdk=23)
    protected void authenticate(FingerprintManager.CryptoObject crypto, CancellationSignal cancel, int flags, FingerprintManager.AuthenticationCallback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an authentication callback");
        }
        if (cancel != null) {
            if (cancel.isCanceled()) {
                Log.w((String)TAG, (String)"authentication already canceled");
                return;
            }
            cancel.setOnCancelListener(() -> {
                this.pendingCallback = null;
                this.pendingCryptoObject = null;
            });
        }
        this.pendingCryptoObject = crypto;
        this.pendingCallback = callback;
    }

    @Deprecated
    public void setHasEnrolledFingerprints(boolean hasEnrolledFingerprints) {
        this.setDefaultFingerprints(hasEnrolledFingerprints ? 1 : 0);
    }

    @Implementation(minSdk=23)
    protected boolean hasEnrolledFingerprints() {
        return !this.fingerprints.isEmpty();
    }

    @HiddenApi
    @Implementation(minSdk=23)
    protected List<Fingerprint> getEnrolledFingerprints() {
        return new ArrayList<Fingerprint>(this.fingerprints);
    }

    public int getFingerprintId(int index) {
        return (Integer)ReflectionHelpers.callInstanceMethod((Object)this.getEnrolledFingerprints().get(index), (String)(RuntimeEnvironment.getApiLevel() > 28 ? "getBiometricId" : "getFingerId"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public void setDefaultFingerprints(int num) {
        this.setEnrolledFingerprints((Fingerprint[])IntStream.range(0, num).mapToObj(i -> new Fingerprint((CharSequence)("Fingerprint " + i), 0, i, 0L)).toArray(Fingerprint[]::new));
    }

    private void setEnrolledFingerprints(Fingerprint ... fingerprints) {
        this.fingerprints = Arrays.asList(fingerprints);
    }

    public void setIsHardwareDetected(boolean isHardwareDetected) {
        this.isHardwareDetected = isHardwareDetected;
    }

    @Implementation(minSdk=23)
    protected boolean isHardwareDetected() {
        return this.isHardwareDetected;
    }
}

