/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Settings.class)
public class ShadowSettings {
    private static boolean canDrawOverlays = false;

    public static void setAirplaneMode(boolean isAirplaneMode) {
        Settings.Global.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"airplane_mode_on", (int)(isAirplaneMode ? 1 : 0));
        Settings.System.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"airplane_mode_on", (int)(isAirplaneMode ? 1 : 0));
    }

    public static void setWifiOn(boolean isOn) {
        Settings.Global.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"wifi_on", (int)(isOn ? 1 : 0));
        Settings.System.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"wifi_on", (int)(isOn ? 1 : 0));
    }

    public static void set24HourTimeFormat(boolean use24HourTimeFormat) {
        Settings.System.putString((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"time_12_24", (String)(use24HourTimeFormat ? "24" : "12"));
    }

    @Implementation(minSdk=23)
    protected static boolean canDrawOverlays(Context context) {
        return canDrawOverlays;
    }

    public static void setCanDrawOverlays(boolean canDrawOverlays) {
        ShadowSettings.canDrawOverlays = canDrawOverlays;
    }

    public static void setAdbEnabled(boolean adbEnabled) {
        if (Build.VERSION.SDK_INT >= 17) {
            Settings.Global.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"adb_enabled", (int)(adbEnabled ? 1 : 0));
        }
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"adb_enabled", (int)(adbEnabled ? 1 : 0));
    }

    public static void setInstallNonMarketApps(boolean installNonMarketApps) {
        if (Build.VERSION.SDK_INT >= 17) {
            Settings.Global.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"install_non_market_apps", (int)(installNonMarketApps ? 1 : 0));
        }
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"install_non_market_apps", (int)(installNonMarketApps ? 1 : 0));
    }

    @Resetter
    public static void reset() {
        canDrawOverlays = false;
    }

    @Implements(value=Settings.Global.class, minSdk=17)
    public static class ShadowGlobal {
        private static final WeakHashMap<ContentResolver, Map<String, Object>> dataMap = new WeakHashMap();

        @Implementation
        protected static boolean putInt(ContentResolver cr, String name, int value) {
            ShadowGlobal.get(cr).put(name, value);
            return true;
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name, int def) {
            if (ShadowGlobal.get(cr).get(name) instanceof Integer) {
                return (Integer)ShadowGlobal.get(cr).get(name);
            }
            return def;
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowGlobal.get(cr).get(name) instanceof Integer) {
                return (Integer)ShadowGlobal.get(cr).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        protected static boolean putString(ContentResolver cr, String name, String value) {
            ShadowGlobal.get(cr).put(name, value);
            return true;
        }

        @Implementation
        protected static String getString(ContentResolver cr, String name) {
            if (ShadowGlobal.get(cr).get(name) instanceof String) {
                return (String)ShadowGlobal.get(cr).get(name);
            }
            return null;
        }

        @Implementation(minSdk=17)
        protected static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowGlobal.getString(cr, name);
        }

        @Implementation
        protected static boolean putLong(ContentResolver cr, String name, long value) {
            ShadowGlobal.get(cr).put(name, value);
            return true;
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name, long def) {
            if (ShadowGlobal.get(cr).get(name) instanceof Long) {
                return (Long)ShadowGlobal.get(cr).get(name);
            }
            return def;
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowGlobal.get(cr).get(name) instanceof Long) {
                return (Long)ShadowGlobal.get(cr).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        protected static boolean putFloat(ContentResolver cr, String name, float value) {
            ShadowGlobal.get(cr).put(name, Float.valueOf(value));
            return true;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name, float def) {
            if (ShadowGlobal.get(cr).get(name) instanceof Float) {
                return ((Float)ShadowGlobal.get(cr).get(name)).floatValue();
            }
            return def;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowGlobal.get(cr).get(name) instanceof Float) {
                return ((Float)ShadowGlobal.get(cr).get(name)).floatValue();
            }
            throw new Settings.SettingNotFoundException(name);
        }

        private static Map<String, Object> get(ContentResolver cr) {
            Map<String, Object> map = dataMap.get(cr);
            if (map == null) {
                map = new HashMap<String, Object>();
                dataMap.put(cr, map);
            }
            return map;
        }
    }

    @Implements(value=Settings.Secure.class)
    public static class ShadowSecure {
        private static final WeakHashMap<ContentResolver, Map<String, Object>> dataMap = new WeakHashMap();

        @Implementation(minSdk=17, maxSdk=28)
        protected static boolean setLocationProviderEnabledForUser(ContentResolver cr, String provider, boolean enabled, int uid) {
            return ShadowSecure.updateEnabledProviders(cr, provider, enabled);
        }

        @Implementation(maxSdk=16)
        protected static void setLocationProviderEnabled(ContentResolver cr, String provider, boolean enabled) {
            ShadowSecure.updateEnabledProviders(cr, provider, enabled);
        }

        private static boolean updateEnabledProviders(ContentResolver cr, String provider, boolean enabled) {
            HashSet<String> providers = new HashSet<String>();
            String oldProviders = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (!TextUtils.isEmpty((CharSequence)oldProviders)) {
                providers.addAll(Arrays.asList(oldProviders.split(",")));
            }
            if (enabled) {
                providers.add(provider);
            } else {
                providers.remove(provider);
            }
            String newProviders = TextUtils.join((CharSequence)",", (Object[])providers.toArray());
            return Settings.Secure.putString((ContentResolver)cr, (String)"location_providers_allowed", (String)newProviders);
        }

        @Implementation
        protected static boolean putInt(ContentResolver resolver, String name, int value) {
            if ("location_mode".equals(name) && RuntimeEnvironment.getApiLevel() <= 28) {
                boolean gps = value == 1 || value == 3;
                boolean network = value == 2 || value == 3;
                Settings.Secure.setLocationProviderEnabled((ContentResolver)resolver, (String)"gps", (boolean)gps);
                Settings.Secure.setLocationProviderEnabled((ContentResolver)resolver, (String)"network", (boolean)network);
            }
            ShadowSecure.get(resolver).put(name, value);
            return true;
        }

        @Implementation(minSdk=21)
        protected static boolean putIntForUser(ContentResolver cr, String name, int value, int userHandle) {
            ShadowSecure.putInt(cr, name, value);
            return true;
        }

        @Implementation
        protected static int getInt(ContentResolver resolver, String name) throws Settings.SettingNotFoundException {
            if ("location_mode".equals(name) && RuntimeEnvironment.getApiLevel() >= 21 && RuntimeEnvironment.getApiLevel() < 28) {
                return (Integer)Shadow.directlyOn(Settings.Secure.class, (String)"getLocationModeForUser", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ContentResolver.class, (Object)resolver), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
            }
            if (ShadowSecure.get(resolver).get(name) instanceof Integer) {
                return (Integer)ShadowSecure.get(resolver).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        protected static int getInt(ContentResolver resolver, String name, int def) {
            if ("location_mode".equals(name) && RuntimeEnvironment.getApiLevel() >= 21 && RuntimeEnvironment.getApiLevel() < 28) {
                return (Integer)Shadow.directlyOn(Settings.Secure.class, (String)"getLocationModeForUser", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ContentResolver.class, (Object)resolver), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
            }
            Integer v = (Integer)ShadowSecure.get(resolver).get(name);
            try {
                return v != null ? v : def;
            }
            catch (NumberFormatException e) {
                return def;
            }
        }

        @Implementation
        protected static boolean putString(ContentResolver cr, String name, String value) {
            ShadowSecure.get(cr).put(name, value);
            return true;
        }

        @Implementation
        protected static String getString(ContentResolver cr, String name) {
            if (ShadowSecure.get(cr).get(name) instanceof String) {
                return (String)ShadowSecure.get(cr).get(name);
            }
            return null;
        }

        @Implementation(minSdk=17)
        protected static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowSecure.getString(cr, name);
        }

        @Implementation
        protected static boolean putLong(ContentResolver cr, String name, long value) {
            ShadowSecure.get(cr).put(name, value);
            return true;
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name, long def) {
            if (ShadowSecure.get(cr).get(name) instanceof Long) {
                return (Long)ShadowSecure.get(cr).get(name);
            }
            return def;
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowSecure.get(cr).get(name) instanceof Long) {
                return (Long)ShadowSecure.get(cr).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        protected static boolean putFloat(ContentResolver cr, String name, float value) {
            ShadowSecure.get(cr).put(name, Float.valueOf(value));
            return true;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name, float def) {
            if (ShadowSecure.get(cr).get(name) instanceof Float) {
                return ((Float)ShadowSecure.get(cr).get(name)).floatValue();
            }
            return def;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowSecure.get(cr).get(name) instanceof Float) {
                return ((Float)ShadowSecure.get(cr).get(name)).floatValue();
            }
            throw new Settings.SettingNotFoundException(name);
        }

        private static Map<String, Object> get(ContentResolver cr) {
            Map<String, Object> map = dataMap.get(cr);
            if (map == null) {
                map = new HashMap<String, Object>();
                dataMap.put(cr, map);
            }
            return map;
        }
    }

    @Implements(value=Settings.System.class)
    public static class ShadowSystem {
        private static final WeakHashMap<ContentResolver, Map<String, Object>> dataMap = new WeakHashMap();

        @Implementation
        protected static boolean putInt(ContentResolver cr, String name, int value) {
            ShadowSystem.get(cr).put(name, value);
            return true;
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name, int def) {
            if (ShadowSystem.get(cr).get(name) instanceof Integer) {
                return (Integer)ShadowSystem.get(cr).get(name);
            }
            return def;
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowSystem.get(cr).get(name) instanceof Integer) {
                return (Integer)ShadowSystem.get(cr).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        protected static boolean putString(ContentResolver cr, String name, String value) {
            ShadowSystem.get(cr).put(name, value);
            return true;
        }

        @Implementation
        protected static String getString(ContentResolver cr, String name) {
            if (ShadowSystem.get(cr).get(name) instanceof String) {
                return (String)ShadowSystem.get(cr).get(name);
            }
            return null;
        }

        @Implementation(minSdk=17)
        protected static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowSystem.getString(cr, name);
        }

        @Implementation
        protected static boolean putLong(ContentResolver cr, String name, long value) {
            ShadowSystem.get(cr).put(name, value);
            return true;
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name, long def) {
            if (ShadowSystem.get(cr).get(name) instanceof Long) {
                return (Long)ShadowSystem.get(cr).get(name);
            }
            return def;
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowSystem.get(cr).get(name) instanceof Long) {
                return (Long)ShadowSystem.get(cr).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        protected static boolean putFloat(ContentResolver cr, String name, float value) {
            ShadowSystem.get(cr).put(name, Float.valueOf(value));
            return true;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name, float def) {
            if (ShadowSystem.get(cr).get(name) instanceof Float) {
                return ((Float)ShadowSystem.get(cr).get(name)).floatValue();
            }
            return def;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowSystem.get(cr).get(name) instanceof Float) {
                return ((Float)ShadowSystem.get(cr).get(name)).floatValue();
            }
            throw new Settings.SettingNotFoundException(name);
        }

        private static Map<String, Object> get(ContentResolver cr) {
            Map<String, Object> map = dataMap.get(cr);
            if (map == null) {
                map = new HashMap<String, Object>();
                dataMap.put(cr, map);
            }
            return map;
        }
    }
}

