/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Trace;
import android.util.Log;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Trace.class)
public class ShadowTrace {
    private static final String TAG = "ShadowTrace";
    @GuardedBy(value="lock")
    private static final Deque<String> currentSections = new ArrayDeque<String>();
    @GuardedBy(value="lock")
    private static final Queue<String> previousSections = new ArrayDeque<String>();
    private static final boolean CRASH_ON_INCORRECT_USAGE_DEFAULT = true;
    private static boolean crashOnIncorrectUsage = true;
    private static boolean appTracingAllowed = true;
    private static final Object lock = new Object();
    private static final long TRACE_TAG_APP = 4096L;
    private static final int MAX_SECTION_NAME_LEN = 127;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=18)
    protected static void beginSection(String sectionName) {
        if (Trace.isTagEnabled((long)4096L)) {
            if (crashOnIncorrectUsage) {
                if (sectionName.length() > 127) {
                    throw new IllegalArgumentException("sectionName is too long");
                }
            } else {
                if (sectionName == null) {
                    Log.w((String)TAG, (String)"Section name cannot be null");
                    return;
                }
                if (sectionName.length() > 127) {
                    Log.w((String)TAG, (String)"Section name is too long");
                    return;
                }
            }
            Object object = lock;
            synchronized (object) {
                currentSections.addFirst(sectionName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=18)
    protected static void endSection() {
        if (Trace.isTagEnabled((long)4096L)) {
            Object object = lock;
            synchronized (object) {
                if (currentSections.isEmpty()) {
                    Log.e((String)TAG, (String)"Trying to end a trace section that was never started");
                    return;
                }
                previousSections.offer(currentSections.removeFirst());
            }
        }
    }

    @Implementation(minSdk=18)
    protected static boolean isTagEnabled(long traceTag) {
        if (traceTag == 4096L) {
            return appTracingAllowed;
        }
        return (Boolean)Shadow.directlyOn(Trace.class, (String)"isTagEnabled", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)traceTag)});
    }

    @Implementation(minSdk=18)
    protected static void setAppTracingAllowed(boolean appTracingAllowed) {
        ShadowTrace.appTracingAllowed = appTracingAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deque<String> getCurrentSections() {
        Object object = lock;
        synchronized (object) {
            return new ArrayDeque<String>(currentSections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue<String> getPreviousSections() {
        Object object = lock;
        synchronized (object) {
            return new ArrayDeque<String>(previousSections);
        }
    }

    public static void doNotUseSetCrashOnIncorrectUsage(boolean crashOnIncorrectUsage) {
        ShadowTrace.crashOnIncorrectUsage = crashOnIncorrectUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            currentSections.clear();
            previousSections.clear();
        }
        crashOnIncorrectUsage = true;
    }
}

