/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import java.util.List;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=CameraDeviceImpl.class, minSdk=21, isInAndroidSdk=false)
public class ShadowCameraDeviceImpl {
    @RealObject
    private CameraDeviceImpl realObject;
    private boolean closed = false;

    @Implementation
    protected CaptureRequest.Builder createCaptureRequest(int templateType) {
        this.checkIfCameraClosedOrInError();
        CameraMetadataNative templatedRequest = new CameraMetadataNative();
        String cameraId = (String)ReflectionHelpers.getField((Object)this.realObject, (String)"mCameraId");
        CaptureRequest.Builder builder = new CaptureRequest.Builder(templatedRequest, false, -1, cameraId, null);
        return builder;
    }

    @Implementation(minSdk=28)
    protected void createCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        this.checkIfCameraClosedOrInError();
        CameraCaptureSession sess = (CameraCaptureSession)Shadow.newInstanceOf(CameraCaptureSessionImpl.class);
        ReflectionHelpers.setField(CameraCaptureSessionImpl.class, (Object)sess, (String)"mStateCallback", (Object)callback);
        ReflectionHelpers.setField(CameraCaptureSessionImpl.class, (Object)sess, (String)"mDeviceImpl", (Object)this.realObject);
        handler.post(() -> callback.onConfigured(sess));
    }

    @Implementation
    protected void close() {
        if (!this.closed) {
            Runnable callOnClosed = (Runnable)ReflectionHelpers.getField((Object)this.realObject, (String)"mCallOnClosed");
            if (Build.VERSION.SDK_INT >= 28) {
                Executor deviceExecutor = (Executor)ReflectionHelpers.getField((Object)this.realObject, (String)"mDeviceExecutor");
                deviceExecutor.execute(callOnClosed);
            } else {
                Handler deviceHandler = (Handler)ReflectionHelpers.getField((Object)this.realObject, (String)"mDeviceHandler");
                deviceHandler.post(callOnClosed);
            }
        }
        this.closed = true;
    }

    @Implementation
    protected void checkIfCameraClosedOrInError() {
        if (this.closed) {
            throw new IllegalStateException("CameraDevice was already closed");
        }
    }
}

