/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Intent;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;

@Implements(value=KeyguardManager.class)
public class ShadowKeyguardManager {
    private static KeyguardManager.KeyguardLock keyguardLock = (KeyguardManager.KeyguardLock)Shadow.newInstanceOf(KeyguardManager.KeyguardLock.class);
    private static final Set<Integer> deviceLockedForUsers = new HashSet<Integer>();
    private static final Set<Integer> deviceSecureForUsers = new HashSet<Integer>();
    private static boolean inRestrictedInputMode;
    private static boolean isKeyguardLocked;
    private static boolean isDeviceLocked;
    private static boolean isKeyguardSecure;
    private static boolean isDeviceSecure;
    private static Intent confirmFactoryResetCredentialIntent;
    private static KeyguardManager.KeyguardDismissCallback callback;

    @Implementation
    protected boolean inKeyguardRestrictedInputMode() {
        return inRestrictedInputMode;
    }

    @Implementation(minSdk=26)
    protected void requestDismissKeyguard(Activity activity, KeyguardManager.KeyguardDismissCallback callback) {
        if (isKeyguardLocked) {
            if (ShadowKeyguardManager.callback != null) {
                callback.onDismissError();
            }
            ShadowKeyguardManager.callback = callback;
        } else {
            callback.onDismissError();
        }
    }

    @Implementation
    protected boolean isKeyguardLocked() {
        return isKeyguardLocked;
    }

    public void setKeyguardLocked(boolean isKeyguardLocked) {
        ShadowKeyguardManager.isKeyguardLocked = isKeyguardLocked;
        if (callback != null) {
            if (isKeyguardLocked) {
                callback.onDismissCancelled();
            } else {
                callback.onDismissSucceeded();
            }
            callback = null;
        }
    }

    @Implementation
    protected KeyguardManager.KeyguardLock newKeyguardLock(String tag) {
        return keyguardLock;
    }

    @Deprecated
    public void setinRestrictedInputMode(boolean restricted) {
        inRestrictedInputMode = restricted;
    }

    public void setInRestrictedInputMode(boolean restricted) {
        inRestrictedInputMode = restricted;
    }

    @Implementation
    protected boolean isKeyguardSecure() {
        return isKeyguardSecure;
    }

    public void setIsKeyguardSecure(boolean secure) {
        isKeyguardSecure = secure;
    }

    @Implementation(minSdk=23)
    protected boolean isDeviceSecure() {
        return isDeviceSecure;
    }

    public void setIsDeviceSecure(boolean isDeviceSecure) {
        ShadowKeyguardManager.isDeviceSecure = isDeviceSecure;
    }

    @Implementation(minSdk=23)
    protected boolean isDeviceSecure(int userId) {
        return deviceSecureForUsers.contains(userId);
    }

    public void setIsDeviceSecure(int userId, boolean isDeviceSecure) {
        if (isDeviceSecure) {
            deviceSecureForUsers.add(userId);
        } else {
            deviceSecureForUsers.remove(userId);
        }
    }

    public void setIsDeviceLocked(boolean isDeviceLocked) {
        ShadowKeyguardManager.isDeviceLocked = isDeviceLocked;
    }

    @Implementation(minSdk=22)
    protected boolean isDeviceLocked() {
        return isDeviceLocked;
    }

    public void setIsDeviceLocked(int userId, boolean isLocked) {
        if (isLocked) {
            deviceLockedForUsers.add(userId);
        } else {
            deviceLockedForUsers.remove(userId);
        }
    }

    @Implementation(minSdk=22)
    protected boolean isDeviceLocked(int userId) {
        return deviceLockedForUsers.contains(userId);
    }

    public void setConfirmFactoryResetCredentialIntent(Intent intent) {
        confirmFactoryResetCredentialIntent = intent;
    }

    @Implementation(minSdk=27)
    protected Intent createConfirmFactoryResetCredentialIntent(CharSequence title, CharSequence description, CharSequence alternateButtonLabel) {
        return confirmFactoryResetCredentialIntent;
    }

    @Resetter
    public static void reset() {
        keyguardLock = (KeyguardManager.KeyguardLock)Shadow.newInstanceOf(KeyguardManager.KeyguardLock.class);
        deviceLockedForUsers.clear();
        deviceSecureForUsers.clear();
        inRestrictedInputMode = false;
        isKeyguardLocked = false;
        isDeviceLocked = false;
        isKeyguardSecure = false;
        isDeviceSecure = false;
        callback = null;
    }

    @Implements(value=KeyguardManager.KeyguardLock.class)
    public static class ShadowKeyguardLock {
        private boolean keyguardEnabled = true;

        @Implementation
        protected void disableKeyguard() {
            this.keyguardEnabled = false;
        }

        @Implementation
        protected void reenableKeyguard() {
            this.keyguardEnabled = true;
        }

        public boolean isEnabled() {
            return this.keyguardEnabled;
        }
    }
}

