/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.LooperShadowPicker;
import org.robolectric.shadows.ShadowLegacyLooper;
import org.robolectric.shadows.ShadowPausedLooper;
import org.robolectric.util.Scheduler;

@Implements(value=Looper.class, shadowPicker=Picker.class)
public abstract class ShadowLooper {
    public static void assertLooperMode(LooperMode.Mode expectedMode) {
        LooperMode.Mode looperMode = (LooperMode.Mode)ConfigurationRegistry.get(LooperMode.Mode.class);
        if (looperMode != expectedMode) {
            String string = String.valueOf(looperMode);
            throw new IllegalStateException(new StringBuilder(38 + String.valueOf(string).length()).append("this action is not supported in ").append(string).append(" mode.").toString());
        }
    }

    private static ShadowLooper shadowLooper(Looper looper) {
        return (ShadowLooper)Shadow.extract((Object)looper);
    }

    @Deprecated
    public static ShadowLooper getShadowMainLooper() {
        return ShadowLooper.shadowLooper(Looper.getMainLooper());
    }

    public static ShadowLooper shadowMainLooper() {
        return ShadowLooper.shadowLooper(Looper.getMainLooper());
    }

    public static Looper getLooperForThread(Thread thread) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.LEGACY) {
            return ShadowLegacyLooper.getLooperForThread(thread);
        }
        String string = String.valueOf(ShadowLooper.looperMode());
        throw new UnsupportedOperationException(new StringBuilder(38 + String.valueOf(string).length()).append("this action is not supported in ").append(string).append(" mode.").toString());
    }

    public static Collection<Looper> getAllLoopers() {
        if (ShadowLooper.looperMode() == LooperMode.Mode.LEGACY) {
            return ShadowLegacyLooper.getLoopers();
        }
        return ShadowPausedLooper.getLoopers();
    }

    public static void resetThreadLoopers() {
        if (ShadowLooper.looperMode() == LooperMode.Mode.LEGACY) {
            ShadowLegacyLooper.resetThreadLoopers();
            return;
        }
        String string = String.valueOf(ShadowLooper.looperMode());
        throw new UnsupportedOperationException(new StringBuilder(38 + String.valueOf(string).length()).append("this action is not supported in ").append(string).append(" mode.").toString());
    }

    public static LooperMode.Mode looperMode() {
        return (LooperMode.Mode)ConfigurationRegistry.get(LooperMode.Mode.class);
    }

    public static void pauseLooper(Looper looper) {
        ShadowLooper.shadowLooper(looper).pause();
    }

    public static void unPauseLooper(Looper looper) {
        ShadowLooper.shadowLooper(looper).unPause();
    }

    public static void pauseMainLooper() {
        ShadowLooper.getShadowMainLooper().pause();
    }

    public static void unPauseMainLooper() {
        ShadowLooper.getShadowMainLooper().unPause();
    }

    public static void idleMainLooper() {
        ShadowLooper.getShadowMainLooper().idle();
    }

    @Deprecated
    public static void idleMainLooper(long interval) {
        ShadowLooper.idleMainLooper(interval, TimeUnit.MILLISECONDS);
    }

    public static void idleMainLooper(long amount, TimeUnit unit) {
        ShadowLooper.getShadowMainLooper().idle(amount, unit);
    }

    public static void idleMainLooperConstantly(boolean shouldIdleConstantly) {
        ShadowLooper.getShadowMainLooper().idleConstantly(shouldIdleConstantly);
    }

    public static void runMainLooperOneTask() {
        ShadowLooper.getShadowMainLooper().runOneTask();
    }

    public static void runMainLooperToNextTask() {
        ShadowLooper.getShadowMainLooper().runToNextTask();
    }

    public static void runUiThreadTasks() {
        ShadowLooper.getShadowMainLooper().idle();
    }

    public static void runUiThreadTasksIncludingDelayedTasks() {
        ShadowLooper.getShadowMainLooper().runToEndOfTasks();
    }

    public abstract void quitUnchecked();

    public abstract boolean hasQuit();

    public abstract void idle();

    public abstract void idleFor(long var1, TimeUnit var3);

    public void idleFor(Duration duration) {
        this.idleFor(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public abstract boolean isIdle();

    public abstract void unPause();

    public abstract boolean isPaused();

    public abstract boolean setPaused(boolean var1);

    public abstract void resetScheduler();

    public abstract void reset();

    public abstract Scheduler getScheduler();

    public abstract void runPaused(Runnable var1);

    public abstract void idleIfPaused();

    @Deprecated
    public void idle(long intervalMillis) {
        this.idleFor(Duration.ofMillis(intervalMillis));
    }

    @Deprecated
    public void idle(long amount, TimeUnit unit) {
        this.idleFor(amount, unit);
    }

    public abstract void idleConstantly(boolean var1);

    public abstract void runToEndOfTasks();

    public abstract void runToNextTask();

    public abstract void runOneTask();

    @Deprecated
    public abstract boolean post(Runnable var1, long var2);

    @Deprecated
    public abstract boolean postAtFrontOfQueue(Runnable var1);

    public abstract void pause();

    public abstract Duration getNextScheduledTaskTime();

    public abstract Duration getLastScheduledTaskTime();

    public static class Picker
    extends LooperShadowPicker<ShadowLooper> {
        public Picker() {
            super(ShadowLegacyLooper.class, ShadowPausedLooper.class);
        }
    }
}

