/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.Choreographer;
import android.view.RenderNodeAnimator;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=RenderNodeAnimator.class, isInAndroidSdk=false, minSdk=21, maxSdk=29)
public class ShadowRenderNodeAnimator {
    private static final int STATE_FINISHED = 3;
    @RealObject
    RenderNodeAnimator realObject;
    private Choreographer choreographer = Choreographer.getInstance();
    private boolean scheduled = false;
    private long startTime = -1L;
    private boolean isEnding = false;
    private Choreographer.FrameCallback frameCallback = new Choreographer.FrameCallback(){

        public void doFrame(long frameTimeNanos) {
            ShadowRenderNodeAnimator.this.scheduled = false;
            if (ShadowRenderNodeAnimator.this.startTime == -1L) {
                ShadowRenderNodeAnimator.this.startTime = frameTimeNanos;
            }
            long duration = ShadowRenderNodeAnimator.this.realObject.getDuration();
            long curTime = frameTimeNanos - ShadowRenderNodeAnimator.this.startTime;
            if (curTime >= duration) {
                Shadow.directlyOn((Object)ShadowRenderNodeAnimator.this.realObject, RenderNodeAnimator.class, (String)"onFinished", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            } else {
                ShadowRenderNodeAnimator.this.schedule();
            }
        }
    };

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.getApiLevel() <= 29) {
            ReflectionHelpers.setStaticField(RenderNodeAnimator.class, (String)"sAnimationHelper", new ThreadLocal());
        }
    }

    @Implementation(minSdk=22)
    public void moveToRunningState() {
        Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class, (String)"moveToRunningState", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        if (!this.isEnding) {
            this.schedule();
        }
    }

    @Implementation
    public void doStart() {
        Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class, (String)"doStart", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        if (RuntimeEnvironment.getApiLevel() <= 21) {
            this.schedule();
        }
    }

    @Implementation
    public void cancel() {
        int state;
        ((RenderNodeAnimator)Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class)).cancel();
        if (RuntimeEnvironment.getApiLevel() <= 21 && (state = ((Integer)ReflectionHelpers.getField((Object)this.realObject, (String)"mState")).intValue()) != 3) {
            Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class, (String)"onFinished", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
    }

    @Implementation
    public void end() {
        this.isEnding = true;
        ((RenderNodeAnimator)Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class)).end();
        this.isEnding = false;
        this.unschedule();
        int state = (Integer)ReflectionHelpers.getField((Object)this.realObject, (String)"mState");
        if (state != 3) {
            Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class, (String)"onFinished", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
    }

    private void schedule() {
        if (!this.scheduled) {
            this.scheduled = true;
            this.choreographer.postFrameCallback(this.frameCallback);
        }
    }

    private void unschedule() {
        if (this.scheduled) {
            this.choreographer.removeFrameCallback(this.frameCallback);
            this.scheduled = false;
        }
    }
}

