/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.audiofx.Visualizer;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=Visualizer.class, minSdk=9)
public class ShadowVisualizer {
    @RealObject
    private Visualizer realObject;
    private final AtomicReference<VisualizerSource> source = new AtomicReference<1>(new VisualizerSource(this){});
    private boolean enabled = false;
    private Visualizer.OnDataCaptureListener captureListener = null;
    private boolean captureWaveform;
    private boolean captureFft;
    private int captureSize;

    public void setSource(VisualizerSource source) {
        this.source.set(source);
    }

    @Implementation(minSdk=9)
    protected int setDataCaptureListener(Visualizer.OnDataCaptureListener listener, int rate, boolean waveform, boolean fft) {
        this.captureListener = listener;
        this.captureWaveform = waveform;
        this.captureFft = fft;
        return 0;
    }

    @Implementation(minSdk=9)
    protected int native_getSamplingRate() {
        return this.source.get().getSamplingRate();
    }

    @Implementation(minSdk=9)
    protected int native_getWaveForm(byte[] waveform) {
        return this.source.get().getWaveForm(waveform);
    }

    @Implementation(minSdk=9)
    protected int native_getFft(byte[] fft) {
        return this.source.get().getFft(fft);
    }

    @Implementation(minSdk=9)
    protected boolean native_getEnabled() {
        return this.enabled;
    }

    @Implementation(minSdk=9)
    protected int native_setCaptureSize(int size) {
        this.captureSize = size;
        return 0;
    }

    @Implementation(minSdk=9)
    protected int native_getCaptureSize() {
        return this.captureSize;
    }

    @Implementation(minSdk=9)
    protected int native_setEnabled(boolean enabled) {
        this.enabled = enabled;
        return 0;
    }

    public void triggerDataCapture() {
        if (this.captureListener == null) {
            return;
        }
        if (this.captureWaveform) {
            byte[] waveform = new byte[this.captureSize];
            this.realObject.getWaveForm(waveform);
            this.captureListener.onWaveFormDataCapture(this.realObject, waveform, this.realObject.getSamplingRate());
        }
        if (this.captureFft) {
            byte[] fft = new byte[this.captureSize];
            this.realObject.getFft(fft);
            this.captureListener.onFftDataCapture(this.realObject, fft, this.realObject.getSamplingRate());
        }
    }

    public static interface VisualizerSource {
        default public int getSamplingRate() {
            return 0;
        }

        default public int getWaveForm(byte[] waveform) {
            return 0;
        }

        default public int getFft(byte[] fft) {
            return 0;
        }
    }
}

