/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

public class ClassNameResolver<T> {
    public static <T> Class<T> resolve(String packageName, String className) throws ClassNotFoundException {
        Class<T> aClass;
        if (ClassNameResolver.looksFullyQualified(className)) {
            aClass = ClassNameResolver.safeClassForName(className);
        } else if (className.startsWith(".")) {
            String string2 = String.valueOf(packageName);
            String string3 = String.valueOf(className);
            aClass = ClassNameResolver.safeClassForName(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        } else {
            aClass = ClassNameResolver.safeClassForName(new StringBuilder(1 + String.valueOf(packageName).length() + String.valueOf(className).length()).append(packageName).append(".").append(className).toString());
        }
        if (aClass == null) {
            throw new ClassNotFoundException(new StringBuilder(53 + String.valueOf(packageName).length() + String.valueOf(className).length()).append("Could not find a class for package: ").append(packageName).append(" and class name: ").append(className).toString());
        }
        return aClass;
    }

    private static boolean looksFullyQualified(String className) {
        return className.contains(".") && !className.startsWith(".");
    }

    private static <T> Class<T> safeClassForName(String classNamePath) {
        try {
            return Class.forName(classNamePath);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

