/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.hardware.biometrics.BiometricManager;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(className="android.hardware.biometrics.BiometricManager", minSdk=29, isInAndroidSdk=false)
public class ShadowBiometricManager {
    protected boolean biometricServiceConnected = true;
    @RealObject
    private BiometricManager realBiometricManager;

    @Implementation(maxSdk=29)
    protected int canAuthenticate() {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            return (Integer)Shadow.directlyOn((Object)this.realBiometricManager, BiometricManager.class, (String)"canAuthenticate", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        if (this.biometricServiceConnected) {
            return 0;
        }
        boolean hasBiomatrics = (Boolean)ReflectionHelpers.callStaticMethod(BiometricManager.class, (String)"hasBiometrics", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application.getApplicationContext())});
        if (!hasBiomatrics) {
            return 12;
        }
        return 1;
    }

    public void setCanAuthenticate(boolean flag) {
        this.biometricServiceConnected = flag;
    }

    @Implementation(minSdk=30)
    protected int canAuthenticate(int userId, int authenticators) {
        return this.biometricServiceConnected ? 0 : 12;
    }
}

