/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.os.Build;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;

@Implements(value=BluetoothLeScanner.class, minSdk=21)
public class ShadowBluetoothLeScanner {
    private static BluetoothLeScanner bluetoothLeScanner;
    private final Set<ScanCallback> scanCallbacks = new HashSet<ScanCallback>();

    static BluetoothLeScanner getInstance() {
        if (bluetoothLeScanner == null) {
            bluetoothLeScanner = ShadowBluetoothLeScanner.newInstance();
        }
        return bluetoothLeScanner;
    }

    @SuppressLint(value={"PrivateApi"})
    private static BluetoothLeScanner newInstance() {
        try {
            Class<?> iBluetoothManagerClass = Shadow.class.getClassLoader().loadClass("android.bluetooth.IBluetoothManager");
            if (Build.VERSION.SDK_INT > 29) {
                return (BluetoothLeScanner)Shadow.newInstance(BluetoothLeScanner.class, (Class[])new Class[]{iBluetoothManagerClass, String.class, String.class}, (Object[])new Object[]{null, "packageName", null});
            }
            return (BluetoothLeScanner)Shadow.newInstance(BluetoothLeScanner.class, (Class[])new Class[]{iBluetoothManagerClass}, (Object[])new Object[]{null});
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Implementation
    protected void startScan(List<ScanFilter> filters, ScanSettings settings, ScanCallback callback) {
        this.scanCallbacks.add(callback);
    }

    @Implementation
    protected void stopScan(ScanCallback callback) {
        this.scanCallbacks.remove(callback);
    }

    public Set<ScanCallback> getScanCallbacks() {
        return Collections.unmodifiableSet(this.scanCallbacks);
    }
}

