/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telecom.Call;
import android.telecom.InCallAdapter;
import android.util.Log;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Call.class)
public class ShadowCall {

    @Implements(value=Call.RttCall.class, minSdk=27)
    public static class ShadowRttCall {
        private static final String TAG = "ShadowRttCall";
        @RealObject
        Call.RttCall realRttCallObject;
        PipedOutputStream pipedOutputStream = new PipedOutputStream();

        @Implementation
        protected void __constructor__(String telecomCallId, InputStreamReader receiveStream, OutputStreamWriter transmitStream, int mode, InCallAdapter inCallAdapter) {
            PipedInputStream pipedInputStream = new PipedInputStream();
            try {
                pipedInputStream.connect(this.pipedOutputStream);
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Could not connect streams.");
            }
            Shadow.invokeConstructor(Call.RttCall.class, (Object)this.realRttCallObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)telecomCallId), ReflectionHelpers.ClassParameter.from(InputStreamReader.class, (Object)new InputStreamReader(pipedInputStream)), ReflectionHelpers.ClassParameter.from(OutputStreamWriter.class, (Object)transmitStream), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mode), ReflectionHelpers.ClassParameter.from(InCallAdapter.class, (Object)inCallAdapter)});
        }

        public void writeRemoteMessage(String message) throws IOException {
            byte[] messageBytes = message.getBytes();
            this.pipedOutputStream.write(messageBytes, 0, messageBytes.length);
        }
    }
}

