/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Size;
import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public final class StreamConfigurationMapBuilder {
    private static final int HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED = 34;
    private final Collection<Size> outputSizes = new ArrayList<Size>();

    public static StreamConfigurationMapBuilder newBuilder() {
        return new StreamConfigurationMapBuilder();
    }

    public StreamConfigurationMapBuilder addOutputSize(Size outputSize) {
        this.outputSizes.add(outputSize);
        return this;
    }

    public StreamConfigurationMap build() {
        SparseIntArray outputFormats;
        StreamConfiguration[] configs = new StreamConfiguration[this.outputSizes.size()];
        int i = 0;
        for (Size size : this.outputSizes) {
            configs[i] = new StreamConfiguration(34, size.getWidth(), size.getHeight(), false);
            ++i;
        }
        StreamConfigurationMap map = (StreamConfigurationMap)ReflectionHelpers.callConstructor(StreamConfigurationMap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ReflectionHelpers.setField(StreamConfigurationMap.class, (Object)map, (String)"mConfigurations", (Object)configs);
        if (RuntimeEnvironment.getApiLevel() < 23) {
            outputFormats = new HashMap();
            outputFormats.put(34, this.outputSizes.size());
            ReflectionHelpers.setField(StreamConfigurationMap.class, (Object)map, (String)"mOutputFormats", (Object)outputFormats);
        } else {
            outputFormats = new SparseIntArray();
            outputFormats.put(34, this.outputSizes.size());
            ReflectionHelpers.setField(StreamConfigurationMap.class, (Object)map, (String)"mOutputFormats", (Object)outputFormats);
            ReflectionHelpers.setField(StreamConfigurationMap.class, (Object)map, (String)"mAllOutputFormats", (Object)outputFormats);
        }
        return map;
    }

    private StreamConfigurationMapBuilder() {
    }
}

