/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.Application;
import android.app.Dialog;
import android.app.DirectAction;
import android.app.Instrumentation;
import android.app.LoadedApk;
import android.app.PictureInPictureParams;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Build;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.Parcel;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.android.internal.app.IVoiceInteractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.controller.ActivityController;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.fakes.RoboMenuItem;
import org.robolectric.fakes.RoboSplashScreen;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowActivityManager;
import org.robolectric.shadows.ShadowActivityThread;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowContextImpl;
import org.robolectric.shadows.ShadowContextThemeWrapper;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.shadows.ShadowLoadedApk;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPackageManager;
import org.robolectric.shadows.ShadowWindow;
import org.robolectric.shadows._Activity_;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

@Implements(value=Activity.class, looseSignatures=true)
public class ShadowActivity
extends ShadowContextThemeWrapper {
    @RealObject
    protected Activity realActivity;
    private int resultCode;
    private Intent resultIntent;
    private Activity parent;
    private int requestedOrientation = -1;
    private View currentFocus;
    private Integer lastShownDialogId = null;
    private int pendingTransitionEnterAnimResId = -1;
    private int pendingTransitionExitAnimResId = -1;
    private Object lastNonConfigurationInstance;
    private Map<Integer, Dialog> dialogForId = new HashMap<Integer, Dialog>();
    private ArrayList<Cursor> managedCursors = new ArrayList();
    private int mDefaultKeyMode = 0;
    private SpannableStringBuilder mDefaultKeySsb = null;
    private int streamType = -1;
    private boolean mIsTaskRoot = true;
    private Menu optionsMenu;
    private ComponentName callingActivity;
    private PermissionsRequest lastRequestedPermission;
    private ActivityController controller;
    private boolean inMultiWindowMode = false;
    private IntentSenderRequest lastIntentSenderRequest;
    private boolean throwIntentSenderException;
    private boolean hasReportedFullyDrawn = false;
    private boolean isInPictureInPictureMode = false;
    private Object splashScreen = null;

    public void setApplication(Application application) {
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).setApplication(application);
    }

    public void callAttach(Intent intent) {
        this.callAttach(intent, null, null);
    }

    public void callAttach(Intent intent, @Nullable Bundle activityOptions) {
        this.callAttach(intent, activityOptions, null);
    }

    public void callAttach(Intent intent, @Nullable Bundle activityOptions, @Nullable @WithType(value="android.app.Activity$NonConfigurationInstances") Object lastNonConfigurationInstances) {
        int displayId;
        ActivityInfo activityInfo;
        Application application = RuntimeEnvironment.getApplication();
        Context baseContext = application.getBaseContext();
        ComponentName componentName = new ComponentName(application.getPackageName(), this.realActivity.getClass().getName());
        PackageManager packageManager = application.getPackageManager();
        this.shadowOf(packageManager).addActivityIfNotPresent(componentName);
        try {
            activityInfo = packageManager.getActivityInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Activity is not resolved even if we made sure it exists", e);
        }
        CharSequence activityTitle = activityInfo.loadLabel(baseContext.getPackageManager());
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        Instrumentation instrumentation = activityThread.getInstrumentation();
        if (activityOptions != null && Build.VERSION.SDK_INT >= 26 && (displayId = ActivityOptions.fromBundle((Bundle)activityOptions).getLaunchDisplayId()) != 0 && displayId != -1) {
            LoadedApk loadedApk = activityThread.getPackageInfo(ShadowActivityThread.getApplicationInfo(), null, 1);
            ShadowLoadedApk._LoadedApk_ loadedApkReflector = (ShadowLoadedApk._LoadedApk_)Reflector.reflector(ShadowLoadedApk._LoadedApk_.class, (Object)loadedApk);
            loadedApkReflector.setResources(application.getResources());
            loadedApkReflector.setApplication(application);
            baseContext = ((ShadowContextImpl._ContextImpl_)Reflector.reflector(ShadowContextImpl._ContextImpl_.class)).createActivityContext(activityThread, loadedApk, activityInfo, ((ShadowContextImpl._ContextImpl_)Reflector.reflector(ShadowContextImpl._ContextImpl_.class, (Object)baseContext)).getActivityToken(), displayId, application.getResources().getConfiguration());
            ((ShadowContextImpl._ContextImpl_)Reflector.reflector(ShadowContextImpl._ContextImpl_.class, (Object)baseContext)).setOuterContext((Context)this.realActivity);
        }
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).callAttach(this.realActivity, baseContext, activityThread, instrumentation, application, intent, activityInfo, activityTitle, lastNonConfigurationInstances);
        int theme = activityInfo.getThemeResource();
        if (theme != 0) {
            this.realActivity.setTheme(theme);
        }
    }

    public void setCallingActivity(@Nullable ComponentName activityName) {
        this.callingActivity = activityName;
    }

    @Implementation
    protected ComponentName getCallingActivity() {
        return this.callingActivity;
    }

    public void setCallingPackage(@Nullable String packageName) {
        if (this.callingActivity != null && this.callingActivity.getPackageName().equals(packageName)) {
            return;
        }
        this.callingActivity = packageName != null ? new ComponentName(packageName, "unknown.Activity") : null;
    }

    @Implementation
    protected String getCallingPackage() {
        return this.callingActivity != null ? this.callingActivity.getPackageName() : null;
    }

    @Implementation
    protected void setDefaultKeyMode(int keyMode) {
        this.mDefaultKeyMode = keyMode;
        switch (this.mDefaultKeyMode) {
            case 0: 
            case 2: {
                this.mDefaultKeySsb = null;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.mDefaultKeySsb = new SpannableStringBuilder();
                Selection.setSelection((Spannable)this.mDefaultKeySsb, (int)0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getDefaultKeymode() {
        return this.mDefaultKeyMode;
    }

    @Implementation
    protected final void setResult(int resultCode) {
        this.resultCode = resultCode;
    }

    @Implementation
    protected final void setResult(int resultCode, Intent data) {
        this.resultCode = resultCode;
        this.resultIntent = data;
    }

    @Implementation
    protected LayoutInflater getLayoutInflater() {
        return LayoutInflater.from((Context)this.realActivity);
    }

    @Implementation
    protected MenuInflater getMenuInflater() {
        return new MenuInflater((Context)this.realActivity);
    }

    @Implementation
    protected View findViewById(int id2) {
        return this.getWindow().findViewById(id2);
    }

    @Implementation
    protected final Activity getParent() {
        return this.parent;
    }

    @HiddenApi
    @Implementation
    public void setParent(Activity parent) {
        this.parent = parent;
    }

    @Implementation
    protected void onBackPressed() {
        this.finish();
    }

    @Implementation
    protected void finish() {
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).setFinished(true);
    }

    @Implementation(minSdk=21)
    protected void finishAndRemoveTask() {
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).setFinished(true);
    }

    @Implementation
    protected void finishAffinity() {
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).setFinished(true);
    }

    public void resetIsFinishing() {
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).setFinished(false);
    }

    @Implementation(minSdk=16)
    protected boolean isFinishing() {
        return ((DirectActivityReflector)Reflector.reflector(DirectActivityReflector.class, (Object)this.realActivity)).isFinishing();
    }

    @Implementation
    protected Window getWindow() {
        Window window = ((DirectActivityReflector)Reflector.reflector(DirectActivityReflector.class, (Object)this.realActivity)).getWindow();
        if (window == null) {
            try {
                window = ShadowWindow.create((Context)this.realActivity);
                this.setWindow(window);
            }
            catch (Exception e) {
                throw new RuntimeException("Window creation failed!", e);
            }
        }
        return window;
    }

    @Implementation(minSdk=31)
    protected synchronized Object getSplashScreen() {
        if (this.splashScreen == null) {
            this.splashScreen = new RoboSplashScreen();
        }
        return this.splashScreen;
    }

    public void setWindow(Window window) {
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).setWindow(window);
    }

    @Implementation
    protected void runOnUiThread(Runnable action) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            ((DirectActivityReflector)Reflector.reflector(DirectActivityReflector.class, (Object)this.realActivity)).runOnUiThread(action);
        } else {
            ShadowApplication.getInstance().getForegroundThreadScheduler().post(action);
        }
    }

    @Implementation
    protected void setRequestedOrientation(int requestedOrientation) {
        if (this.getParent() != null) {
            this.getParent().setRequestedOrientation(requestedOrientation);
        } else {
            this.requestedOrientation = requestedOrientation;
        }
    }

    @Implementation
    protected int getRequestedOrientation() {
        if (this.getParent() != null) {
            return this.getParent().getRequestedOrientation();
        }
        return this.requestedOrientation;
    }

    @Implementation
    protected int getTaskId() {
        return 0;
    }

    @Implementation
    public void startIntentSenderForResult(IntentSender intentSender, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        if (this.throwIntentSenderException) {
            throw new IntentSender.SendIntentException("PendingIntent was canceled");
        }
        this.lastIntentSenderRequest = new IntentSenderRequest(intentSender, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
    }

    @Implementation(minSdk=19)
    protected void reportFullyDrawn() {
        this.hasReportedFullyDrawn = true;
    }

    public boolean getReportFullyDrawn() {
        return this.hasReportedFullyDrawn;
    }

    public View getContentView() {
        return ((ViewGroup)this.getWindow().findViewById(0x1020002)).getChildAt(0);
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public Intent getResultIntent() {
        return this.resultIntent;
    }

    @Override
    public IntentForResult getNextStartedActivityForResult() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        return shadowInstrumentation.getNextStartedActivityForResult();
    }

    @Override
    public IntentForResult peekNextStartedActivityForResult() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        return shadowInstrumentation.peekNextStartedActivityForResult();
    }

    @Implementation
    protected Object getLastNonConfigurationInstance() {
        if (this.lastNonConfigurationInstance != null) {
            return this.lastNonConfigurationInstance;
        }
        return ((DirectActivityReflector)Reflector.reflector(DirectActivityReflector.class, (Object)this.realActivity)).getLastNonConfigurationInstance();
    }

    @Deprecated
    public void setLastNonConfigurationInstance(Object lastNonConfigurationInstance) {
        this.lastNonConfigurationInstance = lastNonConfigurationInstance;
    }

    public void setCurrentFocus(View view) {
        this.currentFocus = view;
    }

    @Implementation
    protected View getCurrentFocus() {
        return this.currentFocus;
    }

    public int getPendingTransitionEnterAnimationResourceId() {
        return this.pendingTransitionEnterAnimResId;
    }

    public int getPendingTransitionExitAnimationResourceId() {
        return this.pendingTransitionExitAnimResId;
    }

    @Implementation
    protected boolean onCreateOptionsMenu(Menu menu) {
        this.optionsMenu = menu;
        return ((DirectActivityReflector)Reflector.reflector(DirectActivityReflector.class, (Object)this.realActivity)).onCreateOptionsMenu(menu);
    }

    public Menu getOptionsMenu() {
        return this.optionsMenu;
    }

    public boolean clickMenuItem(int menuItemResId) {
        RoboMenuItem item = new RoboMenuItem(menuItemResId);
        return this.realActivity.onMenuItemSelected(0, (MenuItem)item);
    }

    @Deprecated
    public void callOnActivityResult(int requestCode, int resultCode, Intent resultData) {
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).onActivityResult(requestCode, resultCode, resultData);
    }

    public void internalCallDispatchActivityResult(String who, int requestCode, int resultCode, Intent data) {
        if (Build.VERSION.SDK_INT >= 28) {
            ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).dispatchActivityResult(who, requestCode, resultCode, data, "ACTIVITY_RESULT");
        } else {
            ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).dispatchActivityResult(who, requestCode, resultCode, data);
        }
    }

    public <T extends Activity> void attachController(ActivityController controller) {
        this.controller = controller;
    }

    public void setThrowIntentSenderException(boolean throwIntentSenderException) {
        this.throwIntentSenderException = throwIntentSenderException;
    }

    public void receiveResult(Intent requestIntent, int resultCode, Intent resultIntent) {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        ShadowInstrumentation.TargetAndRequestCode targetAndRequestCode = shadowInstrumentation.getTargetAndRequestCodeForIntent(requestIntent);
        this.internalCallDispatchActivityResult(targetAndRequestCode.target, targetAndRequestCode.requestCode, resultCode, resultIntent);
    }

    @Implementation
    protected final void showDialog(int id2) {
        this.showDialog(id2, null);
    }

    @Implementation
    protected final void dismissDialog(int id2) {
        Dialog dialog = this.dialogForId.get(id2);
        if (dialog == null) {
            throw new IllegalArgumentException();
        }
        dialog.dismiss();
    }

    @Implementation
    protected final void removeDialog(int id2) {
        this.dialogForId.remove(id2);
    }

    @Implementation
    protected final boolean showDialog(int id2, Bundle bundle) {
        this.lastShownDialogId = id2;
        Dialog dialog = this.dialogForId.get(id2);
        if (dialog == null) {
            dialog = ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).onCreateDialog(id2);
            if (dialog == null) {
                return false;
            }
            if (bundle == null) {
                ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).onPrepareDialog(id2, dialog);
            } else {
                ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).onPrepareDialog(id2, dialog, bundle);
            }
            this.dialogForId.put(id2, dialog);
        }
        dialog.show();
        return true;
    }

    public void setIsTaskRoot(boolean isRoot) {
        this.mIsTaskRoot = isRoot;
    }

    @Implementation
    protected final boolean isTaskRoot() {
        return this.mIsTaskRoot;
    }

    public Integer getLastShownDialogId() {
        return this.lastShownDialogId;
    }

    public boolean hasCancelledPendingTransitions() {
        return this.pendingTransitionEnterAnimResId == 0 && this.pendingTransitionExitAnimResId == 0;
    }

    @Implementation
    protected void overridePendingTransition(int enterAnim, int exitAnim) {
        this.pendingTransitionEnterAnimResId = enterAnim;
        this.pendingTransitionExitAnimResId = exitAnim;
    }

    public Dialog getDialogById(int dialogId) {
        return this.dialogForId.get(dialogId);
    }

    @Implementation
    protected void onDestroy() {
        ((DirectActivityReflector)Reflector.reflector(DirectActivityReflector.class, (Object)this.realActivity)).onDestroy();
        ShadowActivityThread activityThread = (ShadowActivityThread)Shadow.extract((Object)RuntimeEnvironment.getActivityThread());
        IBinder token = ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).getToken();
        activityThread.removeActivity(token);
    }

    @Implementation
    protected void recreate() {
        if (this.controller == null) {
            throw new IllegalStateException("Cannot use an Activity that is not managed by an ActivityController");
        }
        this.controller.recreate();
    }

    @Implementation
    protected void startManagingCursor(Cursor c) {
        this.managedCursors.add(c);
    }

    @Implementation
    protected void stopManagingCursor(Cursor c) {
        this.managedCursors.remove(c);
    }

    public List<Cursor> getManagedCursors() {
        return this.managedCursors;
    }

    @Implementation
    protected final void setVolumeControlStream(int streamType) {
        this.streamType = streamType;
    }

    @Implementation
    protected final int getVolumeControlStream() {
        return this.streamType;
    }

    @Implementation(minSdk=23)
    protected final void requestPermissions(String[] permissions, int requestCode) {
        this.lastRequestedPermission = new PermissionsRequest(permissions, requestCode);
        ((DirectActivityReflector)Reflector.reflector(DirectActivityReflector.class, (Object)this.realActivity)).requestPermissions(permissions, requestCode);
    }

    @Implementation(minSdk=21)
    protected void startLockTask() {
        ((ShadowActivityManager)Shadow.extract((Object)this.getActivityManager())).setLockTaskModeState(1);
    }

    @Implementation(minSdk=21)
    protected void stopLockTask() {
        ((ShadowActivityManager)Shadow.extract((Object)this.getActivityManager())).setLockTaskModeState(0);
    }

    @Deprecated
    public boolean isLockTask() {
        return this.getActivityManager().isInLockTaskMode();
    }

    private ActivityManager getActivityManager() {
        return (ActivityManager)this.realActivity.getSystemService("activity");
    }

    public void setInMultiWindowMode(boolean value) {
        this.inMultiWindowMode = value;
    }

    @Implementation(minSdk=24)
    protected boolean isInMultiWindowMode() {
        return this.inMultiWindowMode;
    }

    @Implementation(minSdk=24)
    protected boolean isInPictureInPictureMode() {
        return this.isInPictureInPictureMode;
    }

    @Implementation(minSdk=24)
    protected void enterPictureInPictureMode() {
        this.isInPictureInPictureMode = true;
    }

    @Implementation(minSdk=26)
    protected boolean enterPictureInPictureMode(PictureInPictureParams params) {
        this.isInPictureInPictureMode = true;
        return true;
    }

    @Implementation
    protected boolean moveTaskToBack(boolean nonRoot) {
        this.isInPictureInPictureMode = false;
        return true;
    }

    public IntentSenderRequest getLastIntentSenderRequest() {
        return this.lastIntentSenderRequest;
    }

    public PermissionsRequest getLastRequestedPermission() {
        return this.lastRequestedPermission;
    }

    public void initializeVoiceInteractor() {
        if (RuntimeEnvironment.getApiLevel() < 24) {
            throw new IllegalStateException("initializeVoiceInteractor requires API 24");
        }
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).setVoiceInteractor(ReflectionHelpers.createDeepProxy(IVoiceInteractor.class));
    }

    public void callOnGetDirectActions(CancellationSignal cancellationSignal, Consumer<List<DirectAction>> callback) {
        if (RuntimeEnvironment.getApiLevel() < 29) {
            throw new IllegalStateException("callOnGetDirectActions requires API 29");
        }
        this.realActivity.onGetDirectActions(cancellationSignal, directActions -> {
            Parcel parcel = Parcel.obtain();
            parcel.writeParcelableList(directActions, 0);
            parcel.setDataPosition(0);
            ArrayList output = new ArrayList();
            parcel.readParcelableList(output, DirectAction.class.getClassLoader());
            callback.accept(output);
        });
    }

    private ShadowPackageManager shadowOf(PackageManager packageManager) {
        return (ShadowPackageManager)Shadow.extract((Object)packageManager);
    }

    @ForType(value=Activity.class, direct=true)
    static interface DirectActivityReflector {
        public void runOnUiThread(Runnable var1);

        public void onDestroy();

        public boolean isFinishing();

        public Window getWindow();

        public Object getLastNonConfigurationInstance();

        public boolean onCreateOptionsMenu(Menu var1);

        public void requestPermissions(String[] var1, int var2);
    }

    public static class IntentSenderRequest {
        public final IntentSender intentSender;
        public final int requestCode;
        @Nullable
        public final Intent fillInIntent;
        public final int flagsMask;
        public final int flagsValues;
        public final int extraFlags;
        public final Bundle options;

        public IntentSenderRequest(IntentSender intentSender, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) {
            this.intentSender = intentSender;
            this.requestCode = requestCode;
            this.fillInIntent = fillInIntent;
            this.flagsMask = flagsMask;
            this.flagsValues = flagsValues;
            this.extraFlags = extraFlags;
            this.options = options;
        }
    }

    public static class PermissionsRequest {
        public final int requestCode;
        public final String[] requestedPermissions;

        public PermissionsRequest(String[] requestedPermissions, int requestCode) {
            this.requestedPermissions = requestedPermissions;
            this.requestCode = requestCode;
        }
    }

    public static class IntentForResult {
        public Intent intent;
        public int requestCode;
        public Bundle options;

        public IntentForResult(Intent intent, int requestCode) {
            this.intent = intent;
            this.requestCode = requestCode;
            this.options = null;
        }

        public IntentForResult(Intent intent, int requestCode, Bundle options) {
            this.intent = intent;
            this.requestCode = requestCode;
            this.options = options;
        }

        public String toString() {
            return super.toString() + "{intent=" + this.intent + ", requestCode=" + this.requestCode + ", options=" + this.options + '}';
        }
    }
}

