/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowColorMatrixColorFilter;
import org.robolectric.shadows.ShadowMatrix;
import org.robolectric.shadows.ShadowPath;
import org.robolectric.util.Join;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;

@Implements(value=Canvas.class)
public class ShadowCanvas {
    private static final NativeObjRegistry<NativeCanvas> nativeObjectRegistry = new NativeObjRegistry(NativeCanvas.class);
    @RealObject
    protected Canvas realCanvas;
    @ReflectorObject
    protected CanvasReflector canvasReflector;
    private final List<RoundRectPaintHistoryEvent> roundRectPaintEvents = new ArrayList<RoundRectPaintHistoryEvent>();
    private List<PathPaintHistoryEvent> pathPaintEvents = new ArrayList<PathPaintHistoryEvent>();
    private List<CirclePaintHistoryEvent> circlePaintEvents = new ArrayList<CirclePaintHistoryEvent>();
    private List<ArcPaintHistoryEvent> arcPaintEvents = new ArrayList<ArcPaintHistoryEvent>();
    private List<RectPaintHistoryEvent> rectPaintEvents = new ArrayList<RectPaintHistoryEvent>();
    private List<LinePaintHistoryEvent> linePaintEvents = new ArrayList<LinePaintHistoryEvent>();
    private List<OvalPaintHistoryEvent> ovalPaintEvents = new ArrayList<OvalPaintHistoryEvent>();
    private List<TextHistoryEvent> drawnTextEventHistory = new ArrayList<TextHistoryEvent>();
    private Paint drawnPaint;
    private Bitmap targetBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    private float translateX;
    private float translateY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int height;
    private int width;

    public static String visualize(Canvas canvas) {
        ShadowCanvas shadowCanvas = (ShadowCanvas)Shadow.extract((Object)canvas);
        return shadowCanvas.getDescription();
    }

    @Implementation
    protected void __constructor__(Bitmap bitmap) {
        this.canvasReflector.__constructor__(bitmap);
        this.targetBitmap = bitmap;
    }

    private long getNativeId() {
        return RuntimeEnvironment.getApiLevel() <= 20 ? (long)((Integer)ReflectionHelpers.getField((Object)this.realCanvas, (String)"mNativeCanvas")).intValue() : this.canvasReflector.getNativeCanvasWrapper();
    }

    private NativeCanvas getNativeCanvas() {
        return (NativeCanvas)nativeObjectRegistry.getNativeObject(this.getNativeId());
    }

    public void appendDescription(String s) {
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)this.targetBitmap);
        shadowBitmap.appendDescription(s);
    }

    public String getDescription() {
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)this.targetBitmap);
        return shadowBitmap.getDescription();
    }

    @Implementation
    protected void setBitmap(Bitmap bitmap) {
        this.targetBitmap = bitmap;
    }

    @Implementation
    protected void drawText(String text, float x, float y, Paint paint) {
        this.drawnTextEventHistory.add(new TextHistoryEvent(x, y, paint, text));
    }

    @Implementation
    protected void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        this.drawnTextEventHistory.add(new TextHistoryEvent(x, y, paint, text.subSequence(start, end).toString()));
    }

    @Implementation
    protected void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        this.drawnTextEventHistory.add(new TextHistoryEvent(x, y, paint, new String(text, index, count)));
    }

    @Implementation
    protected void drawText(String text, int start, int end, float x, float y, Paint paint) {
        this.drawnTextEventHistory.add(new TextHistoryEvent(x, y, paint, text.substring(start, end)));
    }

    @Implementation
    protected void translate(float x, float y) {
        this.translateX = x;
        this.translateY = y;
    }

    @Implementation
    protected void scale(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Implementation
    protected void scale(float sx, float sy, float px, float py) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Implementation
    protected void drawPaint(Paint paint) {
        this.drawnPaint = paint;
    }

    @Implementation
    protected void drawColor(int color) {
        this.appendDescription("draw color " + color);
    }

    @Implementation
    protected void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        this.describeBitmap(bitmap, paint);
        int x = (int)(left + this.translateX);
        int y = (int)(top + this.translateY);
        if (x != 0 || y != 0) {
            this.appendDescription(" at (" + x + "," + y + ")");
        }
        if (this.scaleX != 1.0f && this.scaleY != 1.0f) {
            this.appendDescription(" scaled by (" + this.scaleX + "," + this.scaleY + ")");
        }
        if (bitmap != null && this.targetBitmap != null) {
            ShadowBitmap shadowTargetBitmap = Shadows.shadowOf(this.targetBitmap);
            shadowTargetBitmap.drawBitmap(bitmap, (int)left, (int)top);
        }
    }

    @Implementation
    protected void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        this.describeBitmap(bitmap, paint);
        StringBuilder descriptionBuilder = new StringBuilder();
        if (dst != null) {
            descriptionBuilder.append(" at (").append(dst.left).append(",").append(dst.top).append(") with height=").append(dst.height()).append(" and width=").append(dst.width());
        }
        if (src != null) {
            descriptionBuilder.append(" taken from ").append(src.toString());
        }
        this.appendDescription(descriptionBuilder.toString());
    }

    @Implementation
    protected void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        this.describeBitmap(bitmap, paint);
        StringBuilder descriptionBuilder = new StringBuilder();
        if (dst != null) {
            descriptionBuilder.append(" at (").append(dst.left).append(",").append(dst.top).append(") with height=").append(dst.height()).append(" and width=").append(dst.width());
        }
        if (src != null) {
            descriptionBuilder.append(" taken from ").append(src.toString());
        }
        this.appendDescription(descriptionBuilder.toString());
    }

    @Implementation
    protected void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        this.describeBitmap(bitmap, paint);
        ShadowMatrix shadowMatrix = (ShadowMatrix)Shadow.extract((Object)matrix);
        this.appendDescription(" transformed by " + shadowMatrix.getDescription());
    }

    @Implementation
    protected void drawPath(Path path, Paint paint) {
        this.pathPaintEvents.add(new PathPaintHistoryEvent(new Path(path), new Paint(paint)));
        this.separateLines();
        ShadowPath shadowPath = (ShadowPath)Shadow.extract((Object)path);
        this.appendDescription("Path " + shadowPath.getPoints().toString());
    }

    @Implementation
    protected void drawCircle(float cx, float cy, float radius, Paint paint) {
        this.circlePaintEvents.add(new CirclePaintHistoryEvent(cx, cy, radius, paint));
    }

    @Implementation
    protected void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.arcPaintEvents.add(new ArcPaintHistoryEvent(oval, startAngle, sweepAngle, useCenter, paint));
    }

    @Implementation
    protected void drawRect(float left, float top, float right, float bottom, Paint paint) {
        this.rectPaintEvents.add(new RectPaintHistoryEvent(left, top, right, bottom, paint));
        if (this.targetBitmap != null) {
            ShadowBitmap shadowTargetBitmap = Shadows.shadowOf(this.targetBitmap);
            shadowTargetBitmap.drawRect(new RectF(left, top, right, bottom), paint);
        }
    }

    @Implementation
    protected void drawRect(Rect r, Paint paint) {
        this.rectPaintEvents.add(new RectPaintHistoryEvent(r.left, r.top, r.right, r.bottom, paint));
        if (this.targetBitmap != null) {
            ShadowBitmap shadowTargetBitmap = Shadows.shadowOf(this.targetBitmap);
            shadowTargetBitmap.drawRect(r, paint);
        }
    }

    @Implementation
    protected void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        this.roundRectPaintEvents.add(new RoundRectPaintHistoryEvent(rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint));
    }

    @Implementation
    protected void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        this.linePaintEvents.add(new LinePaintHistoryEvent(startX, startY, stopX, stopY, paint));
    }

    @Implementation
    protected void drawOval(RectF oval, Paint paint) {
        this.ovalPaintEvents.add(new OvalPaintHistoryEvent(oval, paint));
    }

    private void describeBitmap(Bitmap bitmap, Paint paint) {
        ColorFilter colorFilter;
        this.separateLines();
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        this.appendDescription(shadowBitmap.getDescription());
        if (paint != null && (colorFilter = paint.getColorFilter()) != null) {
            if (colorFilter instanceof ColorMatrixColorFilter) {
                ColorMatrixColorFilter colorMatrixColorFilter = (ColorMatrixColorFilter)colorFilter;
                ShadowColorMatrixColorFilter shadowColorMatrixColorFilter = (ShadowColorMatrixColorFilter)Shadow.extract((Object)colorMatrixColorFilter);
                ColorMatrix colorMatrix = shadowColorMatrixColorFilter.getMatrix();
                this.appendDescription(" with ColorMatrixColorFilter<" + this.formatColorMatric(colorMatrix) + ">");
            } else {
                this.appendDescription(" with " + colorFilter);
            }
        }
    }

    private String formatColorMatric(ColorMatrix colorMatrix) {
        ArrayList<String> floats = new ArrayList<String>();
        for (float f : colorMatrix.getArray()) {
            String format = String.format("%.2f", Float.valueOf(f));
            format = format.replace(".00", "");
            floats.add(format);
        }
        return Join.join((String)",", floats);
    }

    private void separateLines() {
        if (this.getDescription().length() != 0) {
            this.appendDescription("\n");
        }
    }

    public int getPathPaintHistoryCount() {
        return this.pathPaintEvents.size();
    }

    public int getCirclePaintHistoryCount() {
        return this.circlePaintEvents.size();
    }

    public int getArcPaintHistoryCount() {
        return this.arcPaintEvents.size();
    }

    public boolean hasDrawnPath() {
        return this.getPathPaintHistoryCount() > 0;
    }

    public boolean hasDrawnCircle() {
        return this.circlePaintEvents.size() > 0;
    }

    public Paint getDrawnPathPaint(int i) {
        return this.pathPaintEvents.get(i).pathPaint;
    }

    public Path getDrawnPath(int i) {
        return this.pathPaintEvents.get(i).drawnPath;
    }

    public CirclePaintHistoryEvent getDrawnCircle(int i) {
        return this.circlePaintEvents.get(i);
    }

    public ArcPaintHistoryEvent getDrawnArc(int i) {
        return this.arcPaintEvents.get(i);
    }

    public void resetCanvasHistory() {
        this.drawnTextEventHistory.clear();
        this.pathPaintEvents.clear();
        this.circlePaintEvents.clear();
        this.rectPaintEvents.clear();
        this.roundRectPaintEvents.clear();
        this.linePaintEvents.clear();
        this.ovalPaintEvents.clear();
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)this.targetBitmap);
        shadowBitmap.setDescription("");
    }

    public Paint getDrawnPaint() {
        return this.drawnPaint;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Implementation
    protected int getWidth() {
        if (this.width == 0) {
            return this.targetBitmap.getWidth();
        }
        return this.width;
    }

    @Implementation
    protected int getHeight() {
        if (this.height == 0) {
            return this.targetBitmap.getHeight();
        }
        return this.height;
    }

    public TextHistoryEvent getDrawnTextEvent(int i) {
        return this.drawnTextEventHistory.get(i);
    }

    public int getTextHistoryCount() {
        return this.drawnTextEventHistory.size();
    }

    public RectPaintHistoryEvent getDrawnRect(int i) {
        return this.rectPaintEvents.get(i);
    }

    public RectPaintHistoryEvent getLastDrawnRect() {
        return this.rectPaintEvents.get(this.rectPaintEvents.size() - 1);
    }

    public int getRectPaintHistoryCount() {
        return this.rectPaintEvents.size();
    }

    public RoundRectPaintHistoryEvent getDrawnRoundRect(int i) {
        return this.roundRectPaintEvents.get(i);
    }

    public RoundRectPaintHistoryEvent getLastDrawnRoundRect() {
        return this.roundRectPaintEvents.get(this.roundRectPaintEvents.size() - 1);
    }

    public int getRoundRectPaintHistoryCount() {
        return this.roundRectPaintEvents.size();
    }

    public LinePaintHistoryEvent getDrawnLine(int i) {
        return this.linePaintEvents.get(i);
    }

    public int getLinePaintHistoryCount() {
        return this.linePaintEvents.size();
    }

    public int getOvalPaintHistoryCount() {
        return this.ovalPaintEvents.size();
    }

    public OvalPaintHistoryEvent getDrawnOval(int i) {
        return this.ovalPaintEvents.get(i);
    }

    @Implementation(maxSdk=25)
    protected int save() {
        return this.getNativeCanvas().save();
    }

    @Implementation(maxSdk=25)
    protected void restore() {
        this.getNativeCanvas().restore();
    }

    @Implementation(maxSdk=25)
    protected int getSaveCount() {
        return this.getNativeCanvas().getSaveCount();
    }

    @Implementation(maxSdk=25)
    protected void restoreToCount(int saveCount) {
        this.getNativeCanvas().restoreToCount(saveCount);
    }

    @Implementation(minSdk=19)
    protected void release() {
        nativeObjectRegistry.unregister(this.getNativeId());
        this.canvasReflector.release();
    }

    @Implementation(maxSdk=20)
    protected static int initRaster(int bitmapHandle) {
        return (int)nativeObjectRegistry.register((Object)new NativeCanvas());
    }

    @Implementation(minSdk=21, maxSdk=22)
    protected static long initRaster(long bitmapHandle) {
        return nativeObjectRegistry.register((Object)new NativeCanvas());
    }

    @Implementation(minSdk=23, maxSdk=25)
    protected static long initRaster(Bitmap bitmap) {
        return nativeObjectRegistry.register((Object)new NativeCanvas());
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static long nInitRaster(Bitmap bitmap) {
        return nativeObjectRegistry.register((Object)new NativeCanvas());
    }

    @Implementation(minSdk=29)
    protected static long nInitRaster(long bitmapHandle) {
        return nativeObjectRegistry.register((Object)new NativeCanvas());
    }

    @Implementation(minSdk=26)
    protected static int nGetSaveCount(long canvasHandle) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject(canvasHandle)).getSaveCount();
    }

    @Implementation(minSdk=26)
    protected static int nSave(long canvasHandle, int saveFlags) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject(canvasHandle)).save();
    }

    @Implementation(maxSdk=20)
    protected static int native_saveLayer(int nativeCanvas, RectF bounds, int paint, int layerFlags) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject((long)nativeCanvas)).save();
    }

    @Implementation(maxSdk=20)
    protected static int native_saveLayer(int nativeCanvas, float l, float t, float r, float b, int paint, int layerFlags) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject((long)nativeCanvas)).save();
    }

    @Implementation(minSdk=21, maxSdk=25)
    protected static int native_saveLayer(long nativeCanvas, float l, float t, float r, float b, long nativePaint, int layerFlags) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject(nativeCanvas)).save();
    }

    @Implementation(minSdk=26, maxSdk=30)
    protected static int nSaveLayer(long nativeCanvas, float l, float t, float r, float b, long nativePaint, int layerFlags) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject(nativeCanvas)).save();
    }

    @Implementation(minSdk=31)
    protected static int nSaveLayer(long nativeCanvas, float l, float t, float r, float b, long nativePaint) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject(nativeCanvas)).save();
    }

    @Implementation(maxSdk=20)
    protected static int native_saveLayerAlpha(int nativeCanvas, RectF bounds, int alpha, int layerFlags) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject((long)nativeCanvas)).save();
    }

    @Implementation(maxSdk=20)
    protected static int native_saveLayerAlpha(int nativeCanvas, float l, float t, float r, float b, int alpha, int layerFlags) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject((long)nativeCanvas)).save();
    }

    @Implementation(minSdk=21, maxSdk=25)
    protected static int native_saveLayerAlpha(long nativeCanvas, float l, float t, float r, float b, int alpha, int layerFlags) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject(nativeCanvas)).save();
    }

    @Implementation(minSdk=26, maxSdk=30)
    protected static int nSaveLayerAlpha(long nativeCanvas, float l, float t, float r, float b, int alpha, int layerFlags) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject(nativeCanvas)).save();
    }

    @Implementation(minSdk=31)
    protected static int nSaveLayerAlpha(long nativeCanvas, float l, float t, float r, float b, int alpha) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject(nativeCanvas)).save();
    }

    @Implementation(minSdk=26)
    protected static boolean nRestore(long canvasHandle) {
        return ((NativeCanvas)nativeObjectRegistry.getNativeObject(canvasHandle)).restore();
    }

    @Implementation(minSdk=26)
    protected static void nRestoreToCount(long canvasHandle, int saveCount) {
        ((NativeCanvas)nativeObjectRegistry.getNativeObject(canvasHandle)).restoreToCount(saveCount);
    }

    @Resetter
    public static void reset() {
        nativeObjectRegistry.clear();
    }

    private static class NativeCanvas {
        private int saveCount = 1;

        private NativeCanvas() {
        }

        int save() {
            return this.saveCount++;
        }

        boolean restore() {
            if (this.saveCount > 1) {
                --this.saveCount;
                return true;
            }
            return false;
        }

        int getSaveCount() {
            return this.saveCount;
        }

        void restoreToCount(int saveCount) {
            if (saveCount > 0) {
                this.saveCount = saveCount;
            }
        }
    }

    @ForType(value=Canvas.class)
    private static interface CanvasReflector {
        @Direct
        public void __constructor__(Bitmap var1);

        @Direct
        public long getNativeCanvasWrapper();

        @Direct
        public void release();
    }

    public static class TextHistoryEvent {
        public final float x;
        public final float y;
        public final Paint paint;
        public final String text;

        private TextHistoryEvent(float x, float y, Paint paint, String text) {
            this.x = x;
            this.y = y;
            this.paint = paint;
            this.text = text;
        }
    }

    public static class ArcPaintHistoryEvent {
        public final RectF oval;
        public final float startAngle;
        public final float sweepAngle;
        public final boolean useCenter;
        public final Paint paint;

        public ArcPaintHistoryEvent(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
            this.oval = oval;
            this.startAngle = startAngle;
            this.sweepAngle = sweepAngle;
            this.useCenter = useCenter;
            this.paint = paint;
        }
    }

    public static class CirclePaintHistoryEvent {
        public final float centerX;
        public final float centerY;
        public final float radius;
        public final Paint paint;

        private CirclePaintHistoryEvent(float centerX, float centerY, float radius, Paint paint) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
            this.paint = paint;
        }
    }

    private static class PathPaintHistoryEvent {
        private final Path drawnPath;
        private final Paint pathPaint;

        PathPaintHistoryEvent(Path drawnPath, Paint pathPaint) {
            this.drawnPath = drawnPath;
            this.pathPaint = pathPaint;
        }
    }

    public static class RoundRectPaintHistoryEvent {
        public final Paint paint;
        public final RectF rect;
        public final float left;
        public final float top;
        public final float right;
        public final float bottom;
        public final float rx;
        public final float ry;

        private RoundRectPaintHistoryEvent(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
            this.rect = new RectF(left, top, right, bottom);
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
            this.paint.setTextSize(paint.getTextSize());
            this.paint.setStyle(paint.getStyle());
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.rx = rx;
            this.ry = ry;
        }
    }

    public static class RectPaintHistoryEvent {
        public final Paint paint;
        public final RectF rect;
        public final float left;
        public final float top;
        public final float right;
        public final float bottom;

        private RectPaintHistoryEvent(float left, float top, float right, float bottom, Paint paint) {
            this.rect = new RectF(left, top, right, bottom);
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
            this.paint.setTextSize(paint.getTextSize());
            this.paint.setStyle(paint.getStyle());
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }

    public static class OvalPaintHistoryEvent {
        public final RectF oval;
        public final Paint paint;

        private OvalPaintHistoryEvent(RectF oval, Paint paint) {
            this.oval = new RectF(oval);
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
        }
    }

    public static class LinePaintHistoryEvent {
        public Paint paint;
        public float startX;
        public float startY;
        public float stopX;
        public float stopY;

        private LinePaintHistoryEvent(float startX, float startY, float stopX, float stopY, Paint paint) {
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
            this.startX = startX;
            this.startY = startY;
            this.stopX = stopX;
            this.stopY = stopY;
        }
    }
}

