/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.wifi.aware.AttachCallback;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.PublishDiscoverySession;
import android.net.wifi.aware.SubscribeConfig;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.aware.WifiAwareSession;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=WifiAwareManager.class, minSdk=26)
public class ShadowWifiAwareManager {
    private boolean available = true;
    private WifiAwareSession session;
    private boolean sessionDetached = true;
    private PublishDiscoverySession discoverySessionToPublish;
    private SubscribeDiscoverySession discoverySessionToSubscribe;

    @Implementation
    protected boolean isAvailable() {
        return this.available;
    }

    @Implementation
    protected void attach(AttachCallback callback, Handler handler) {
        if (this.available && this.sessionDetached) {
            this.sessionDetached = false;
            handler.post(() -> callback.onAttached(this.session));
        } else {
            if (this.available && !this.sessionDetached) {
                return;
            }
            handler.post(() -> ((AttachCallback)callback).onAttachFailed());
        }
    }

    @Implementation
    protected void publish(int clientId, Looper looper, PublishConfig publishConfig, DiscoverySessionCallback callback) {
        if (this.available) {
            Handler handler = new Handler(looper);
            handler.post(() -> callback.onPublishStarted(this.discoverySessionToPublish));
        }
    }

    @Implementation
    protected void subscribe(int clientId, Looper looper, SubscribeConfig subscribeConfig, DiscoverySessionCallback callback) {
        if (this.available) {
            Handler handler = new Handler(looper);
            handler.post(() -> callback.onSubscribeStarted(this.discoverySessionToSubscribe));
        }
    }

    public static PublishDiscoverySession newPublishDiscoverySession(WifiAwareManager manager, int clientId, int sessionId) {
        return new PublishDiscoverySession(manager, clientId, sessionId);
    }

    public static SubscribeDiscoverySession newSubscribeDiscoverySession(WifiAwareManager manager, int clientId, int sessionId) {
        return new SubscribeDiscoverySession(manager, clientId, sessionId);
    }

    public static WifiAwareSession newWifiAwareSession(WifiAwareManager manager, Binder binder, int clientId) {
        return new WifiAwareSession(manager, binder, clientId);
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setWifiAwareSession(WifiAwareSession session) {
        this.session = session;
    }

    public void setSessionDetached(boolean sessionDetached) {
        this.sessionDetached = sessionDetached;
    }

    public void setDiscoverySessionToPublish(PublishDiscoverySession publishDiscoverySession) {
        this.discoverySessionToPublish = publishDiscoverySession;
    }

    public void setDiscoverySessionToSubscribe(SubscribeDiscoverySession subscribeDiscoverySession) {
        this.discoverySessionToSubscribe = subscribeDiscoverySession;
    }
}

