/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Rect;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AccessibilityWindowInfo.class, minSdk=21)
public class ShadowAccessibilityWindowInfo {
    private static final Map<StrictEqualityWindowWrapper, StackTraceElement[]> obtainedInstances = new HashMap<StrictEqualityWindowWrapper, StackTraceElement[]>();
    private List<AccessibilityWindowInfo> children = null;
    private AccessibilityWindowInfo parent = null;
    private AccessibilityNodeInfo rootNode = null;
    private AccessibilityNodeInfo anchorNode = null;
    private Rect boundsInScreen = new Rect();
    private int type = 1;
    private int layer = 0;
    private CharSequence title = null;
    private boolean isAccessibilityFocused = false;
    private boolean isActive = false;
    private boolean isFocused = false;
    @RealObject
    private AccessibilityWindowInfo mRealAccessibilityWindowInfo;

    @Implementation
    protected void __constructor__() {
    }

    @Implementation
    protected static AccessibilityWindowInfo obtain() {
        AccessibilityWindowInfo obtainedInstance = (AccessibilityWindowInfo)ReflectionHelpers.callConstructor(AccessibilityWindowInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        StrictEqualityWindowWrapper wrapper = new StrictEqualityWindowWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        return obtainedInstance;
    }

    @Implementation
    protected static AccessibilityWindowInfo obtain(AccessibilityWindowInfo window) {
        ShadowAccessibilityWindowInfo shadowInfo = (ShadowAccessibilityWindowInfo)Shadow.extract((Object)window);
        AccessibilityWindowInfo obtainedInstance = shadowInfo.getClone();
        StrictEqualityWindowWrapper wrapper = new StrictEqualityWindowWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        return obtainedInstance;
    }

    private AccessibilityWindowInfo getClone() {
        AccessibilityWindowInfo newInfo = (AccessibilityWindowInfo)ReflectionHelpers.callConstructor(AccessibilityWindowInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowAccessibilityWindowInfo newShadow = (ShadowAccessibilityWindowInfo)Shadow.extract((Object)newInfo);
        newShadow.boundsInScreen = new Rect(this.boundsInScreen);
        newShadow.parent = this.parent;
        newShadow.rootNode = this.rootNode;
        newShadow.anchorNode = this.anchorNode;
        newShadow.type = this.type;
        newShadow.layer = this.layer;
        newShadow.setId(this.getId());
        newShadow.title = this.title;
        newShadow.isAccessibilityFocused = this.isAccessibilityFocused;
        newShadow.isActive = this.isActive;
        newShadow.isFocused = this.isFocused;
        newShadow.children = this.children != null ? new ArrayList<AccessibilityWindowInfo>(this.children) : null;
        return newInfo;
    }

    public static void resetObtainedInstances() {
        obtainedInstances.clear();
    }

    public static boolean areThereUnrecycledWindows(boolean printUnrecycledWindowsToSystemErr) {
        if (printUnrecycledWindowsToSystemErr) {
            for (StrictEqualityWindowWrapper wrapper : obtainedInstances.keySet()) {
                ShadowAccessibilityWindowInfo shadow = (ShadowAccessibilityWindowInfo)Shadow.extract((Object)wrapper.mInfo);
                System.err.println(String.format("Leaked type = %d, id = %d. Stack trace:", shadow.getType(), wrapper.mInfo.getId()));
                for (StackTraceElement stackTraceElement : obtainedInstances.get(wrapper)) {
                    System.err.println(stackTraceElement.toString());
                }
            }
        }
        return obtainedInstances.size() != 0;
    }

    public boolean deepEquals(Object object) {
        boolean areEqual;
        if (!(object instanceof AccessibilityWindowInfo)) {
            return false;
        }
        AccessibilityWindowInfo window = (AccessibilityWindowInfo)object;
        ShadowAccessibilityWindowInfo otherShadow = (ShadowAccessibilityWindowInfo)Shadow.extract((Object)window);
        boolean bl = areEqual = this.type == otherShadow.getType();
        areEqual &= this.parent == null ? otherShadow.getParent() == null : this.parent.equals((Object)otherShadow.getParent());
        areEqual &= this.rootNode == null ? otherShadow.getRoot() == null : this.rootNode.equals((Object)otherShadow.getRoot());
        areEqual &= this.anchorNode == null ? otherShadow.getAnchor() == null : this.anchorNode.equals((Object)otherShadow.getAnchor());
        areEqual &= this.layer == otherShadow.getLayer();
        areEqual &= this.getId() == otherShadow.getId();
        areEqual &= this.title == otherShadow.getTitle();
        areEqual &= this.isAccessibilityFocused == otherShadow.isAccessibilityFocused();
        areEqual &= this.isActive == otherShadow.isActive();
        areEqual &= this.isFocused == otherShadow.isFocused();
        Rect anotherBounds = new Rect();
        otherShadow.getBoundsInScreen(anotherBounds);
        return areEqual &= this.boundsInScreen.equals((Object)anotherBounds);
    }

    @Implementation
    public int hashCode() {
        return 0;
    }

    @Implementation
    protected int getType() {
        return this.type;
    }

    @Implementation
    protected int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Implementation
    protected AccessibilityWindowInfo getChild(int index) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(index);
    }

    @Implementation
    protected AccessibilityWindowInfo getParent() {
        return this.parent;
    }

    @Implementation
    protected AccessibilityNodeInfo getRoot() {
        return this.rootNode == null ? null : AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)this.rootNode);
    }

    @Implementation(minSdk=24)
    protected AccessibilityNodeInfo getAnchor() {
        return this.anchorNode == null ? null : AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)this.anchorNode);
    }

    @Implementation
    protected boolean isActive() {
        return this.isActive;
    }

    @Implementation
    protected int getId() {
        return ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.mRealAccessibilityWindowInfo)).getId();
    }

    @Implementation
    protected void getBoundsInScreen(Rect outBounds) {
        if (this.boundsInScreen == null) {
            outBounds.setEmpty();
        } else {
            outBounds.set(this.boundsInScreen);
        }
    }

    @Implementation
    protected int getLayer() {
        return this.layer;
    }

    @Implementation(minSdk=24)
    protected CharSequence getTitle() {
        return this.title;
    }

    @Implementation
    protected boolean isFocused() {
        return this.isFocused;
    }

    @Implementation
    protected boolean isAccessibilityFocused() {
        return this.isAccessibilityFocused;
    }

    @Implementation
    protected void recycle() {
    }

    public void setRoot(AccessibilityNodeInfo root) {
        this.rootNode = root;
    }

    public void setAnchor(AccessibilityNodeInfo anchor) {
        this.anchorNode = anchor;
    }

    @Implementation
    public void setType(int value) {
        this.type = value;
    }

    @Implementation(maxSdk=29)
    public void setBoundsInScreen(Rect bounds) {
        this.boundsInScreen.set(bounds);
    }

    @Implementation
    public void setAccessibilityFocused(boolean value) {
        this.isAccessibilityFocused = value;
    }

    @Implementation
    public void setActive(boolean value) {
        this.isActive = value;
    }

    @Implementation
    public void setId(int value) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.mRealAccessibilityWindowInfo)).setId(value);
    }

    @Implementation
    public void setLayer(int value) {
        this.layer = value;
    }

    @Implementation(minSdk=24)
    public void setTitle(CharSequence value) {
        this.title = value;
    }

    @Implementation
    public void setFocused(boolean focused) {
        this.isFocused = focused;
    }

    public void addChild(AccessibilityWindowInfo child) {
        if (this.children == null) {
            this.children = new ArrayList<AccessibilityWindowInfo>();
        }
        this.children.add(child);
        ((ShadowAccessibilityWindowInfo)Shadow.extract((Object)child)).parent = this.mRealAccessibilityWindowInfo;
    }

    @Implementation
    public String toString() {
        return "ShadowAccessibilityWindowInfo@" + System.identityHashCode(this) + ":{id:" + this.getId() + ", title:" + this.title + "}";
    }

    @ForType(value=AccessibilityWindowInfo.class)
    static interface AccessibilityWindowInfoReflector {
        @Direct
        public int getId();

        @Direct
        public void setId(int var1);
    }

    private static class StrictEqualityWindowWrapper {
        public final AccessibilityWindowInfo mInfo;

        public StrictEqualityWindowWrapper(AccessibilityWindowInfo info) {
            this.mInfo = info;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof StrictEqualityWindowWrapper)) {
                return false;
            }
            StrictEqualityWindowWrapper wrapper = (StrictEqualityWindowWrapper)object;
            return this.mInfo == wrapper.mInfo;
        }

        public int hashCode() {
            return this.mInfo.hashCode();
        }
    }
}

