/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.input.InputManager;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VerifiedKeyEvent;
import android.view.VerifiedMotionEvent;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=InputManager.class, looseSignatures=true)
public class ShadowInputManager {
    @Implementation
    protected boolean injectInputEvent(InputEvent event, int mode) {
        return true;
    }

    @Implementation(minSdk=19)
    protected boolean[] deviceHasKeys(int id2, int[] keyCodes) {
        return new boolean[keyCodes.length];
    }

    @Implementation
    protected int[] getInputDeviceIds() {
        return new int[0];
    }

    @Implementation(minSdk=30)
    protected Object verifyInputEvent(Object inputEvent) {
        if (inputEvent instanceof MotionEvent) {
            MotionEvent motionEvent = (MotionEvent)inputEvent;
            return new VerifiedMotionEvent(motionEvent.getDeviceId(), TimeUnit.MILLISECONDS.toNanos(motionEvent.getEventTime()), motionEvent.getSource(), motionEvent.getDisplayId(), motionEvent.getRawX(), motionEvent.getRawY(), motionEvent.getActionMasked(), TimeUnit.MILLISECONDS.toNanos(motionEvent.getDownTime()), motionEvent.getFlags(), motionEvent.getMetaState(), motionEvent.getButtonState());
        }
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            return new VerifiedKeyEvent(keyEvent.getDeviceId(), TimeUnit.MILLISECONDS.toNanos(keyEvent.getEventTime()), keyEvent.getSource(), keyEvent.getDisplayId(), keyEvent.getAction(), TimeUnit.MILLISECONDS.toNanos(keyEvent.getDownTime()), keyEvent.getFlags(), keyEvent.getKeyCode(), keyEvent.getScanCode(), keyEvent.getMetaState(), keyEvent.getRepeatCount());
        }
        throw new IllegalArgumentException("unknown input event: " + inputEvent.getClass().getName());
    }

    @Resetter
    public static void reset() {
        ReflectionHelpers.setStaticField(InputManager.class, (String)"sInstance", null);
    }
}

