/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.system.OsConstants;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.OsConstantsValues;

@Implements(value=OsConstants.class, minSdk=21)
public final class ShadowOsConstants {
    private static final Pattern ERRNO_PATTERN = Pattern.compile("E[A-Z0-9]+");

    @Implementation
    protected static void initConstants() {
        int errnos = 1;
        try {
            for (Field field : OsConstants.class.getDeclaredFields()) {
                String fieldName = field.getName();
                if (ERRNO_PATTERN.matcher(fieldName).matches() && field.getType() == Integer.TYPE) {
                    field.setInt(null, errnos++);
                }
                if (fieldName.equals("S_IFMT")) {
                    field.setInt(null, 0x170000);
                    continue;
                }
                if (fieldName.equals("S_IFDIR")) {
                    field.setInt(null, 262144);
                    continue;
                }
                if (fieldName.equals("S_IFREG")) {
                    field.setInt(null, 0x100000);
                    continue;
                }
                if (fieldName.equals("S_IFLNK")) {
                    field.setInt(null, 0x120000);
                }
                if (!OsConstantsValues.OPEN_MODE_VALUES.containsKey((Object)fieldName)) continue;
                field.setInt(null, (Integer)OsConstantsValues.OPEN_MODE_VALUES.get((Object)fieldName));
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

