/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.telecom.CallAudioState;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionService;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import androidx.annotation.Nullable;
import com.android.internal.R;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.android.controller.ServiceController;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=TelecomManager.class, minSdk=21)
public class ShadowTelecomManager {
    @RealObject
    private TelecomManager realObject;
    private final LinkedHashMap<PhoneAccountHandle, PhoneAccount> accounts = new LinkedHashMap();
    private final List<IncomingCallRecord> incomingCalls = new ArrayList<IncomingCallRecord>();
    private final List<OutgoingCallRecord> outgoingCalls = new ArrayList<OutgoingCallRecord>();
    private final List<UnknownCallRecord> unknownCalls = new ArrayList<UnknownCallRecord>();
    private final Map<String, PhoneAccountHandle> defaultOutgoingPhoneAccounts = new ArrayMap();
    private Intent manageBlockNumbersIntent;
    private CallRequestMode callRequestMode = CallRequestMode.MANUAL;
    private PhoneAccountHandle simCallManager;
    private String defaultDialerPackageName;
    private String systemDefaultDialerPackageName;
    private boolean isInCall;
    private boolean ttySupported;
    private PhoneAccountHandle userSelectedOutgoingPhoneAccount;

    public CallRequestMode getCallRequestMode() {
        return this.callRequestMode;
    }

    public void setCallRequestMode(CallRequestMode callRequestMode) {
        this.callRequestMode = callRequestMode;
    }

    public void setDefaultOutgoingPhoneAccount(String uriScheme, PhoneAccountHandle handle) {
        this.defaultOutgoingPhoneAccounts.put(uriScheme, handle);
    }

    public void removeDefaultOutgoingPhoneAccount(String uriScheme) {
        this.defaultOutgoingPhoneAccounts.remove(uriScheme);
    }

    @Implementation
    protected PhoneAccountHandle getDefaultOutgoingPhoneAccount(String uriScheme) {
        return this.defaultOutgoingPhoneAccounts.get(uriScheme);
    }

    @Implementation
    @HiddenApi
    public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount() {
        return this.userSelectedOutgoingPhoneAccount;
    }

    @Implementation
    @HiddenApi
    public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle accountHandle) {
        this.userSelectedOutgoingPhoneAccount = accountHandle;
    }

    @Implementation
    protected PhoneAccountHandle getSimCallManager() {
        return this.simCallManager;
    }

    @Implementation(minSdk=23)
    @HiddenApi
    public PhoneAccountHandle getSimCallManager(int userId) {
        return null;
    }

    @Implementation
    @HiddenApi
    public PhoneAccountHandle getConnectionManager() {
        return this.getSimCallManager();
    }

    @Implementation
    @HiddenApi
    public List<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String uriScheme) {
        ArrayList<PhoneAccountHandle> result = new ArrayList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            PhoneAccount phoneAccount = this.accounts.get(handle);
            if (!phoneAccount.getSupportedUriSchemes().contains(uriScheme)) continue;
            result.add(handle);
        }
        return result;
    }

    @Implementation(minSdk=23)
    protected List<PhoneAccountHandle> getCallCapablePhoneAccounts() {
        return this.getCallCapablePhoneAccounts(false);
    }

    @Implementation(minSdk=23)
    @HiddenApi
    public List<PhoneAccountHandle> getCallCapablePhoneAccounts(boolean includeDisabledAccounts) {
        ArrayList<PhoneAccountHandle> result = new ArrayList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            PhoneAccount phoneAccount = this.accounts.get(handle);
            if (!phoneAccount.isEnabled() && !includeDisabledAccounts) continue;
            result.add(handle);
        }
        return result;
    }

    @Implementation(minSdk=26)
    public List<PhoneAccountHandle> getSelfManagedPhoneAccounts() {
        ArrayList<PhoneAccountHandle> result = new ArrayList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            PhoneAccount phoneAccount = this.accounts.get(handle);
            if ((phoneAccount.getCapabilities() & 0x800) != 2048) continue;
            result.add(handle);
        }
        return result;
    }

    @Implementation
    @HiddenApi
    public List<PhoneAccountHandle> getPhoneAccountsForPackage() {
        Context context = (Context)ReflectionHelpers.getField((Object)this.realObject, (String)"mContext");
        ArrayList<PhoneAccountHandle> results = new ArrayList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            if (!handle.getComponentName().getPackageName().equals(context.getPackageName())) continue;
            results.add(handle);
        }
        return results;
    }

    @Implementation
    protected PhoneAccount getPhoneAccount(PhoneAccountHandle account) {
        return this.accounts.get(account);
    }

    @Implementation
    @HiddenApi
    public int getAllPhoneAccountsCount() {
        return this.accounts.size();
    }

    @Implementation
    @HiddenApi
    public List<PhoneAccount> getAllPhoneAccounts() {
        return ImmutableList.copyOf(this.accounts.values());
    }

    @Implementation
    @HiddenApi
    public List<PhoneAccountHandle> getAllPhoneAccountHandles() {
        return ImmutableList.copyOf(this.accounts.keySet());
    }

    @Implementation
    protected void registerPhoneAccount(PhoneAccount account) {
        this.accounts.put(account.getAccountHandle(), account);
    }

    @Implementation
    protected void unregisterPhoneAccount(PhoneAccountHandle accountHandle) {
        this.accounts.remove(accountHandle);
    }

    @Deprecated
    @Implementation
    @HiddenApi
    public void clearAccounts() {
        this.accounts.clear();
    }

    @Implementation(minSdk=22)
    @HiddenApi
    public void clearAccountsForPackage(String packageName) {
        HashSet<PhoneAccountHandle> phoneAccountHandlesInPackage = new HashSet<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            if (!handle.getComponentName().getPackageName().equals(packageName)) continue;
            phoneAccountHandlesInPackage.add(handle);
        }
        for (PhoneAccountHandle handle : phoneAccountHandlesInPackage) {
            this.accounts.remove(handle);
        }
    }

    @Deprecated
    @Implementation
    @HiddenApi
    public ComponentName getDefaultPhoneApp() {
        return null;
    }

    @Implementation(minSdk=23)
    protected String getDefaultDialerPackage() {
        return this.defaultDialerPackageName;
    }

    @Deprecated
    @Implementation(minSdk=23)
    @HiddenApi
    public boolean setDefaultDialer(String packageName) {
        this.defaultDialerPackageName = packageName;
        return true;
    }

    public void setDefaultDialerPackage(String packageName) {
        this.defaultDialerPackageName = packageName;
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected String getSystemDialerPackage() {
        return this.systemDefaultDialerPackageName;
    }

    public void setSystemDialerPackage(String packageName) {
        this.systemDefaultDialerPackageName = packageName;
    }

    @Implementation(minSdk=22)
    protected boolean isVoiceMailNumber(PhoneAccountHandle accountHandle, String number) {
        return false;
    }

    @Implementation(minSdk=23)
    protected String getVoiceMailNumber(PhoneAccountHandle accountHandle) {
        return null;
    }

    @Implementation(minSdk=22)
    protected String getLine1Number(PhoneAccountHandle accountHandle) {
        return null;
    }

    public void setIsInCall(boolean isInCall) {
        this.isInCall = isInCall;
    }

    @Implementation
    protected boolean isInCall() {
        return this.isInCall;
    }

    @Implementation
    @HiddenApi
    public int getCallState() {
        return 0;
    }

    @Implementation
    @HiddenApi
    public boolean isRinging() {
        for (IncomingCallRecord incomingCallRecord : this.incomingCalls) {
            if (!incomingCallRecord.isRinging) continue;
            return true;
        }
        for (UnknownCallRecord unknownCallRecord : this.unknownCalls) {
            if (!unknownCallRecord.isRinging) continue;
            return true;
        }
        return false;
    }

    @Implementation
    @HiddenApi
    public boolean endCall() {
        return false;
    }

    @Implementation
    protected void acceptRingingCall() {
    }

    @Implementation
    protected void silenceRinger() {
        for (IncomingCallRecord incomingCallRecord : this.incomingCalls) {
            incomingCallRecord.isRinging = false;
        }
        for (UnknownCallRecord unknownCallRecord : this.unknownCalls) {
            unknownCallRecord.isRinging = false;
        }
    }

    @Implementation
    protected boolean isTtySupported() {
        return this.ttySupported;
    }

    public void setTtySupported(boolean isSupported) {
        this.ttySupported = isSupported;
    }

    @Implementation
    @HiddenApi
    public int getCurrentTtyMode() {
        return 0;
    }

    @Implementation
    protected void addNewIncomingCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        IncomingCallRecord call = new IncomingCallRecord(phoneAccount, extras);
        this.incomingCalls.add(call);
        switch (this.callRequestMode) {
            case ALLOW_ALL: {
                this.allowIncomingCall(call);
                break;
            }
            case DENY_ALL: {
                this.denyIncomingCall(call);
                break;
            }
        }
    }

    public List<IncomingCallRecord> getAllIncomingCalls() {
        return ImmutableList.copyOf(this.incomingCalls);
    }

    public IncomingCallRecord getLastIncomingCall() {
        return (IncomingCallRecord)Iterables.getLast(this.incomingCalls);
    }

    public IncomingCallRecord getOnlyIncomingCall() {
        return (IncomingCallRecord)Iterables.getOnlyElement(this.incomingCalls);
    }

    @TargetApi(value=23)
    @Nullable
    public Connection allowIncomingCall(IncomingCallRecord call) {
        if (call.isHandled) {
            throw new IllegalStateException("Call has already been allowed or denied.");
        }
        call.isHandled = true;
        PhoneAccountHandle phoneAccount = (PhoneAccountHandle)Verify.verifyNotNull((Object)call.phoneAccount);
        ConnectionRequest request = ShadowTelecomManager.buildConnectionRequestForIncomingCall(call);
        ConnectionService service = ShadowTelecomManager.setupConnectionService(phoneAccount);
        return service.onCreateIncomingConnection(phoneAccount, request);
    }

    @TargetApi(value=26)
    public void denyIncomingCall(IncomingCallRecord call) {
        if (call.isHandled) {
            throw new IllegalStateException("Call has already been allowed or denied.");
        }
        call.isHandled = true;
        PhoneAccountHandle phoneAccount = (PhoneAccountHandle)Verify.verifyNotNull((Object)call.phoneAccount);
        ConnectionRequest request = ShadowTelecomManager.buildConnectionRequestForIncomingCall(call);
        ConnectionService service = ShadowTelecomManager.setupConnectionService(phoneAccount);
        service.onCreateIncomingConnectionFailed(phoneAccount, request);
    }

    private static ConnectionRequest buildConnectionRequestForIncomingCall(IncomingCallRecord call) {
        PhoneAccountHandle phoneAccount = (PhoneAccountHandle)Verify.verifyNotNull((Object)call.phoneAccount);
        Bundle extras = (Bundle)Verify.verifyNotNull((Object)call.extras);
        Uri address = (Uri)extras.getParcelable("android.telecom.extra.INCOMING_CALL_ADDRESS");
        int videoState = extras.getInt("android.telecom.extra.START_CALL_WITH_VIDEO_STATE", 0);
        return new ConnectionRequest(phoneAccount, address, new Bundle(extras), videoState);
    }

    @Implementation(minSdk=23)
    protected void placeCall(Uri address, Bundle extras) {
        OutgoingCallRecord call = new OutgoingCallRecord(address, extras);
        this.outgoingCalls.add(call);
        switch (this.callRequestMode) {
            case ALLOW_ALL: {
                this.allowOutgoingCall(call);
                break;
            }
            case DENY_ALL: {
                this.denyOutgoingCall(call);
                break;
            }
        }
    }

    public List<OutgoingCallRecord> getAllOutgoingCalls() {
        return ImmutableList.copyOf(this.outgoingCalls);
    }

    public OutgoingCallRecord getLastOutgoingCall() {
        return (OutgoingCallRecord)Iterables.getLast(this.outgoingCalls);
    }

    public OutgoingCallRecord getOnlyOutgoingCall() {
        return (OutgoingCallRecord)Iterables.getOnlyElement(this.outgoingCalls);
    }

    @TargetApi(value=23)
    @Nullable
    public Connection allowOutgoingCall(OutgoingCallRecord call) {
        if (call.isHandled) {
            throw new IllegalStateException("Call has already been allowed or denied.");
        }
        call.isHandled = true;
        PhoneAccountHandle phoneAccount = (PhoneAccountHandle)Verify.verifyNotNull((Object)call.phoneAccount);
        ConnectionRequest request = ShadowTelecomManager.buildConnectionRequestForOutgoingCall(call);
        ConnectionService service = ShadowTelecomManager.setupConnectionService(phoneAccount);
        return service.onCreateOutgoingConnection(phoneAccount, request);
    }

    @TargetApi(value=26)
    public void denyOutgoingCall(OutgoingCallRecord call) {
        if (call.isHandled) {
            throw new IllegalStateException("Call has already been allowed or denied.");
        }
        call.isHandled = true;
        PhoneAccountHandle phoneAccount = (PhoneAccountHandle)Verify.verifyNotNull((Object)call.phoneAccount);
        ConnectionRequest request = ShadowTelecomManager.buildConnectionRequestForOutgoingCall(call);
        ConnectionService service = ShadowTelecomManager.setupConnectionService(phoneAccount);
        service.onCreateOutgoingConnectionFailed(phoneAccount, request);
    }

    private static ConnectionRequest buildConnectionRequestForOutgoingCall(OutgoingCallRecord call) {
        PhoneAccountHandle phoneAccount = (PhoneAccountHandle)Verify.verifyNotNull((Object)call.phoneAccount);
        Uri address = (Uri)Verify.verifyNotNull((Object)call.address);
        Bundle extras = (Bundle)Verify.verifyNotNull((Object)call.extras);
        Bundle outgoingCallExtras = extras.getBundle("android.telecom.extra.OUTGOING_CALL_EXTRAS");
        int videoState = extras.getInt("android.telecom.extra.START_CALL_WITH_VIDEO_STATE", 0);
        return new ConnectionRequest(phoneAccount, address, outgoingCallExtras == null ? null : new Bundle(outgoingCallExtras), videoState);
    }

    @Implementation
    @HiddenApi
    public void addNewUnknownCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        this.unknownCalls.add(new UnknownCallRecord(phoneAccount, extras));
    }

    public List<UnknownCallRecord> getAllUnknownCalls() {
        return ImmutableList.copyOf(this.unknownCalls);
    }

    public UnknownCallRecord getLastUnknownCall() {
        return (UnknownCallRecord)Iterables.getLast(this.unknownCalls);
    }

    public UnknownCallRecord getOnlyUnknownCall() {
        return (UnknownCallRecord)Iterables.getOnlyElement(this.unknownCalls);
    }

    private static ConnectionService setupConnectionService(PhoneAccountHandle phoneAccount) {
        Class<ConnectionService> clazz;
        ComponentName service = phoneAccount.getComponentName();
        try {
            clazz = Class.forName(service.getClassName()).asSubclass(ConnectionService.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return (ConnectionService)Verify.verifyNotNull((Object)((ConnectionService)ServiceController.of((ConnectionService)ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]), null).create().get()));
    }

    @Implementation
    protected boolean handleMmi(String dialString) {
        return false;
    }

    @Implementation(minSdk=23)
    protected boolean handleMmi(String dialString, PhoneAccountHandle accountHandle) {
        return false;
    }

    @Implementation(minSdk=22)
    protected Uri getAdnUriForPhoneAccount(PhoneAccountHandle accountHandle) {
        return Uri.parse((String)"content://icc/adn");
    }

    @Implementation
    protected void cancelMissedCallsNotification() {
    }

    @Implementation
    protected void showInCallScreen(boolean showDialpad) {
    }

    @Implementation(minSdk=23)
    @HiddenApi
    public void enablePhoneAccount(PhoneAccountHandle handle, boolean isEnabled) {
    }

    @Implementation(minSdk=24)
    protected Intent createManageBlockedNumbersIntent() {
        return this.manageBlockNumbersIntent;
    }

    public void setManageBlockNumbersIntent(Intent intent) {
        this.manageBlockNumbersIntent = intent;
    }

    @Implementation(maxSdk=22)
    public void setSimCallManager(PhoneAccountHandle simCallManager) {
        this.simCallManager = simCallManager;
    }

    public CallAudioState newCallAudioState(boolean muted, int route, int supportedRouteMask, BluetoothDevice activeBluetoothDevice, Collection<BluetoothDevice> supportedBluetoothDevices) {
        return new CallAudioState(muted, route, supportedRouteMask, activeBluetoothDevice, supportedBluetoothDevices);
    }

    @Implementation(minSdk=30)
    @SystemApi
    protected Intent createLaunchEmergencyDialerIntent(String number) {
        Context context = (Context)ReflectionHelpers.getField((Object)this.realObject, (String)"mContext");
        int configEmergencyDialerPackageId = (Integer)ReflectionHelpers.getStaticField(R.string.class, (String)"config_emergency_dialer_package");
        String packageName = context.getString(configEmergencyDialerPackageId);
        Intent intent = new Intent("android.intent.action.DIAL_EMERGENCY").setPackage(packageName);
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 0);
        if (resolveInfo == null) {
            intent.setPackage(null);
        }
        if (!TextUtils.isEmpty((CharSequence)number) && TextUtils.isDigitsOnly((CharSequence)number)) {
            intent.setData(Uri.parse((String)("tel:" + number)));
        }
        return intent;
    }

    public static class UnknownCallRecord
    extends CallRecord {
        public UnknownCallRecord(PhoneAccountHandle phoneAccount, Bundle extras) {
            super(phoneAccount, extras);
        }
    }

    public static class OutgoingCallRecord {
        public final PhoneAccountHandle phoneAccount;
        public final Uri address;
        public final Bundle extras;
        private boolean isHandled = false;

        public OutgoingCallRecord(Uri address, Bundle extras) {
            this.address = address;
            if (extras != null) {
                this.extras = new Bundle(extras);
                this.phoneAccount = (PhoneAccountHandle)extras.getParcelable("android.telecom.extra.PHONE_ACCOUNT_HANDLE");
            } else {
                this.extras = null;
                this.phoneAccount = null;
            }
        }
    }

    public static class IncomingCallRecord
    extends CallRecord {
        private boolean isHandled = false;

        public IncomingCallRecord(PhoneAccountHandle phoneAccount, Bundle extras) {
            super(phoneAccount, extras);
        }
    }

    @Deprecated
    public static class CallRecord {
        public final PhoneAccountHandle phoneAccount;
        public final Bundle extras;
        protected boolean isRinging = true;
        @Deprecated
        public final Bundle bundle;

        public CallRecord(PhoneAccountHandle phoneAccount, Bundle extras) {
            this.phoneAccount = phoneAccount;
            this.bundle = this.extras = extras == null ? null : new Bundle(extras);
        }
    }

    public static enum CallRequestMode {
        ALLOW_ALL,
        DENY_ALL,
        MANUAL;

    }
}

