/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.LinkProperties;
import android.telephony.PreciseDataConnectionState;
import android.telephony.data.ApnSetting;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public class PreciseDataConnectionStateBuilder {
    private int dataState;
    private int networkType;
    private int transportType;
    private int id;
    private LinkProperties linkProperties;
    private ApnSetting apnSetting;
    private int dataFailCause;

    private PreciseDataConnectionStateBuilder() {
    }

    public static PreciseDataConnectionStateBuilder newBuilder() {
        return new PreciseDataConnectionStateBuilder();
    }

    public PreciseDataConnectionStateBuilder setDataState(int dataState) {
        this.dataState = dataState;
        return this;
    }

    public PreciseDataConnectionStateBuilder setNetworkType(int networkType) {
        this.networkType = networkType;
        return this;
    }

    public PreciseDataConnectionStateBuilder setTransportType(int transportType) {
        this.transportType = this.networkType;
        return this;
    }

    public PreciseDataConnectionStateBuilder setLinkProperties(LinkProperties linkProperties) {
        this.linkProperties = linkProperties;
        return this;
    }

    public PreciseDataConnectionStateBuilder setId(int id2) {
        this.id = id2;
        return this;
    }

    public PreciseDataConnectionStateBuilder setApnSetting(ApnSetting apnSetting) {
        this.apnSetting = apnSetting;
        return this;
    }

    public PreciseDataConnectionStateBuilder setDataFailCause(int dataFailCause) {
        this.dataFailCause = dataFailCause;
        return this;
    }

    public PreciseDataConnectionState build() {
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (apiLevel <= 30) {
            return (PreciseDataConnectionState)ReflectionHelpers.callConstructor(PreciseDataConnectionState.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.dataState), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.networkType), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)(this.apnSetting == null ? 17 : this.apnSetting.getApnTypeBitmask())), ReflectionHelpers.ClassParameter.from(String.class, (Object)(this.apnSetting == null ? "" : this.apnSetting.getApnName())), ReflectionHelpers.ClassParameter.from(LinkProperties.class, (Object)this.linkProperties), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.dataFailCause), ReflectionHelpers.ClassParameter.from(ApnSetting.class, (Object)this.apnSetting)});
        }
        return new PreciseDataConnectionState.Builder().setTransportType(this.transportType).setId(this.id).setState(this.dataState).setNetworkType(this.networkType).setLinkProperties(this.linkProperties).setFailCause(this.dataFailCause).setApnSetting(this.apnSetting).build();
    }
}

