/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.view.Choreographer;
import android.view.ThreadedRenderer;
import com.android.internal.policy.BackdropFrameRenderer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=BackdropFrameRenderer.class, minSdk=31)
public class ShadowBackdropFrameRenderer {
    @RealObject
    private final BackdropFrameRenderer realBackdropFrameRenderer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void run() {
        BackdropFrameRenderer backdropFrameRenderer;
        try {
            Looper.prepare();
            backdropFrameRenderer = this.realBackdropFrameRenderer;
            synchronized (backdropFrameRenderer) {
                block11: {
                    ThreadedRenderer renderer = ((BackdropFrameRendererReflector)Reflector.reflector(BackdropFrameRendererReflector.class, (Object)this.realBackdropFrameRenderer)).getRenderer();
                    if (renderer != null) break block11;
                    return;
                }
                ((BackdropFrameRendererReflector)Reflector.reflector(BackdropFrameRendererReflector.class, (Object)this.realBackdropFrameRenderer)).setChoreographer(Choreographer.getInstance());
            }
            Looper.loop();
        }
        finally {
            ((BackdropFrameRendererReflector)Reflector.reflector(BackdropFrameRendererReflector.class, (Object)this.realBackdropFrameRenderer)).releaseRenderer();
        }
        backdropFrameRenderer = this.realBackdropFrameRenderer;
        synchronized (backdropFrameRenderer) {
            ((BackdropFrameRendererReflector)Reflector.reflector(BackdropFrameRendererReflector.class, (Object)this.realBackdropFrameRenderer)).setChoreographer(null);
            Choreographer.releaseInstance();
        }
    }

    @ForType(value=BackdropFrameRenderer.class)
    static interface BackdropFrameRendererReflector {
        @Direct
        public void releaseRenderer();

        @Accessor(value="mRenderer")
        public ThreadedRenderer getRenderer();

        @Accessor(value="mChoreographer")
        public void setChoreographer(Choreographer var1);

        @Accessor(value="mChoreographer")
        public Choreographer getChoreographer();
    }
}

