/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.SQLiteConnectionNatives;
import org.robolectric.shadows.PreLPointers;
import org.robolectric.shadows.ShadowSQLiteConnection;
import org.robolectric.util.PerfStatsCollector;

@Implements(className="android.database.sqlite.SQLiteConnection", isInAndroidSdk=false)
public class ShadowNativeSQLiteConnection
extends ShadowSQLiteConnection {
    @Implementation(maxSdk=26)
    protected static Number nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile) {
        return (Number)PerfStatsCollector.getInstance().measure("androidsqlite", () -> {
            long result = SQLiteConnectionNatives.nativeOpen((String)path, (int)openFlags, (String)label, (boolean)enableTrace, (boolean)enableProfile, (int)0, (int)0);
            if (RuntimeEnvironment.getApiLevel() < 21) {
                return PreLPointers.register(result);
            }
            return result;
        });
    }

    @Implementation(minSdk=27)
    protected static long nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile, int lookasideSlotSize, int lookasideSlotCount) {
        return ShadowNativeSQLiteConnection.nativeOpen(path, openFlags, label, enableTrace, enableProfile).longValue();
    }

    @Implementation(maxSdk=20)
    protected static int nativePrepareStatement(int connectionPtr, String sql) {
        long statementPtr = ShadowNativeSQLiteConnection.nativePrepareStatement(PreLPointers.get(connectionPtr), sql);
        return PreLPointers.register(statementPtr);
    }

    @Implementation(minSdk=21)
    protected static long nativePrepareStatement(long connectionPtr, String sql) {
        return (Long)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativePrepareStatement((long)connectionPtr, (String)sql));
    }

    @Implementation(maxSdk=20)
    protected static void nativeFinalizeStatement(int connectionPtr, int statementPtr) {
        ShadowNativeSQLiteConnection.nativeFinalizeStatement(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static void nativeFinalizeStatement(long connectionPtr, long statementPtr) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeFinalizeStatement((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static int nativeGetParameterCount(int connectionPtr, int statementPtr) {
        return ShadowNativeSQLiteConnection.nativeGetParameterCount(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static int nativeGetParameterCount(long connectionPtr, long statementPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeGetParameterCount((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static boolean nativeIsReadOnly(int connectionPtr, int statementPtr) {
        return ShadowNativeSQLiteConnection.nativeIsReadOnly(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static boolean nativeIsReadOnly(long connectionPtr, long statementPtr) {
        return (Boolean)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeIsReadOnly((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static String nativeExecuteForString(int connectionPtr, int statementPtr) {
        return ShadowNativeSQLiteConnection.nativeExecuteForString(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static String nativeExecuteForString(long connectionPtr, long statementPtr) {
        return (String)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForString((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static void nativeRegisterLocalizedCollators(int connectionPtr, String locale) {
        ShadowNativeSQLiteConnection.nativeRegisterLocalizedCollators(PreLPointers.get(connectionPtr), locale);
    }

    @Implementation(minSdk=21)
    protected static void nativeRegisterLocalizedCollators(long connectionPtr, String locale) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeRegisterLocalizedCollators((long)connectionPtr, (String)locale));
    }

    @Implementation(maxSdk=20)
    protected static long nativeExecuteForLong(int connectionPtr, int statementPtr) {
        return ShadowNativeSQLiteConnection.nativeExecuteForLong(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static long nativeExecuteForLong(long connectionPtr, long statementPtr) {
        return (Long)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForLong((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static void nativeExecute(int connectionPtr, int statementPtr) {
        ShadowNativeSQLiteConnection.nativeExecute(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21, maxSdk=32)
    protected static void nativeExecute(long connectionPtr, long statementPtr) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecute((long)connectionPtr, (long)statementPtr, (boolean)false));
    }

    @Implementation(minSdk=33)
    protected static void nativeExecute(long connectionPtr, long statementPtr, boolean isPragmaStmt) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecute((long)connectionPtr, (long)statementPtr, (boolean)isPragmaStmt));
    }

    @Implementation(maxSdk=20)
    protected static int nativeExecuteForChangedRowCount(int connectionPtr, int statementPtr) {
        return ShadowNativeSQLiteConnection.nativeExecuteForChangedRowCount(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static int nativeExecuteForChangedRowCount(long connectionPtr, long statementPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForChangedRowCount((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static int nativeGetColumnCount(int connectionPtr, int statementPtr) {
        return ShadowNativeSQLiteConnection.nativeGetColumnCount(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static int nativeGetColumnCount(long connectionPtr, long statementPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeGetColumnCount((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static String nativeGetColumnName(int connectionPtr, int statementPtr, int index) {
        return ShadowNativeSQLiteConnection.nativeGetColumnName(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr), index);
    }

    @Implementation(minSdk=21)
    protected static String nativeGetColumnName(long connectionPtr, long statementPtr, int index) {
        return (String)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeGetColumnName((long)connectionPtr, (long)statementPtr, (int)index));
    }

    @Implementation(maxSdk=20)
    protected static void nativeBindNull(int connectionPtr, int statementPtr, int index) {
        ShadowNativeSQLiteConnection.nativeBindNull(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr), index);
    }

    @Implementation(minSdk=21)
    protected static void nativeBindNull(long connectionPtr, long statementPtr, int index) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindNull((long)connectionPtr, (long)statementPtr, (int)index));
    }

    @Implementation(maxSdk=20)
    protected static void nativeBindLong(int connectionPtr, int statementPtr, int index, long value) {
        ShadowNativeSQLiteConnection.nativeBindLong(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr), index, value);
    }

    @Implementation(minSdk=21)
    protected static void nativeBindLong(long connectionPtr, long statementPtr, int index, long value) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindLong((long)connectionPtr, (long)statementPtr, (int)index, (long)value));
    }

    @Implementation(maxSdk=20)
    protected static void nativeBindDouble(int connectionPtr, int statementPtr, int index, double value) {
        ShadowNativeSQLiteConnection.nativeBindDouble(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr), index, value);
    }

    @Implementation(minSdk=21)
    protected static void nativeBindDouble(long connectionPtr, long statementPtr, int index, double value) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindDouble((long)connectionPtr, (long)statementPtr, (int)index, (double)value));
    }

    @Implementation(maxSdk=20)
    protected static void nativeBindString(int connectionPtr, int statementPtr, int index, String value) {
        ShadowNativeSQLiteConnection.nativeBindString(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr), index, value);
    }

    @Implementation(minSdk=21)
    protected static void nativeBindString(long connectionPtr, long statementPtr, int index, String value) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindString((long)connectionPtr, (long)statementPtr, (int)index, (String)value));
    }

    @Implementation(maxSdk=20)
    protected static void nativeBindBlob(int connectionPtr, int statementPtr, int index, byte[] value) {
        ShadowNativeSQLiteConnection.nativeBindBlob(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr), index, value);
    }

    @Implementation(minSdk=21)
    protected static void nativeBindBlob(long connectionPtr, long statementPtr, int index, byte[] value) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeBindBlob((long)connectionPtr, (long)statementPtr, (int)index, (byte[])value));
    }

    @Implementation(maxSdk=20)
    protected static void nativeResetStatementAndClearBindings(int connectionPtr, int statementPtr) {
        ShadowNativeSQLiteConnection.nativeResetStatementAndClearBindings(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static void nativeResetStatementAndClearBindings(long connectionPtr, long statementPtr) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeResetStatementAndClearBindings((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static long nativeExecuteForLastInsertedRowId(int connectionPtr, int statementPtr) {
        return ShadowNativeSQLiteConnection.nativeExecuteForLastInsertedRowId(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static long nativeExecuteForLastInsertedRowId(long connectionPtr, long statementPtr) {
        return (Long)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForLastInsertedRowId((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static long nativeExecuteForCursorWindow(int connectionPtr, int statementPtr, int windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return ShadowNativeSQLiteConnection.nativeExecuteForCursorWindow(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr), PreLPointers.get(windowPtr), startPos, requiredPos, countAllRows);
    }

    @Implementation(minSdk=21)
    protected static long nativeExecuteForCursorWindow(long connectionPtr, long statementPtr, long windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return (Long)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForCursorWindow((long)connectionPtr, (long)statementPtr, (long)windowPtr, (int)startPos, (int)requiredPos, (boolean)countAllRows));
    }

    @Implementation(maxSdk=20)
    protected static int nativeExecuteForBlobFileDescriptor(int connectionPtr, int statementPtr) {
        return ShadowNativeSQLiteConnection.nativeExecuteForBlobFileDescriptor(PreLPointers.get(connectionPtr), PreLPointers.get(statementPtr));
    }

    @Implementation(minSdk=21)
    protected static int nativeExecuteForBlobFileDescriptor(long connectionPtr, long statementPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeExecuteForBlobFileDescriptor((long)connectionPtr, (long)statementPtr));
    }

    @Implementation(maxSdk=20)
    protected static void nativeCancel(int connectionPtr) {
        ShadowNativeSQLiteConnection.nativeCancel(PreLPointers.get(connectionPtr));
    }

    @Implementation(minSdk=21)
    protected static void nativeCancel(long connectionPtr) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeCancel((long)connectionPtr));
    }

    @Implementation(maxSdk=20)
    protected static void nativeResetCancel(int connectionPtr, boolean cancelable) {
        ShadowNativeSQLiteConnection.nativeResetCancel(PreLPointers.get(connectionPtr), cancelable);
    }

    @Implementation(minSdk=21)
    protected static void nativeResetCancel(long connectionPtr, boolean cancelable) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeResetCancel((long)connectionPtr, (boolean)cancelable));
    }

    @Implementation(minSdk=30)
    protected static void nativeRegisterCustomScalarFunction(long connectionPtr, String name, UnaryOperator<String> function) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeRegisterCustomScalarFunction((long)connectionPtr, (String)name, (UnaryOperator)function));
    }

    @Implementation(minSdk=30)
    protected static void nativeRegisterCustomAggregateFunction(long connectionPtr, String name, BinaryOperator<String> function) {
        PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeRegisterCustomAggregateFunction((long)connectionPtr, (String)name, (BinaryOperator)function));
    }

    @Implementation(maxSdk=20)
    protected static int nativeGetDbLookaside(int connectionPtr) {
        return ShadowNativeSQLiteConnection.nativeGetDbLookaside(PreLPointers.get(connectionPtr));
    }

    @Implementation(minSdk=21)
    protected static int nativeGetDbLookaside(long connectionPtr) {
        return (Integer)PerfStatsCollector.getInstance().measure("androidsqlite", () -> SQLiteConnectionNatives.nativeGetDbLookaside((long)connectionPtr));
    }
}

