/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.annotation.SQLiteMode;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadows.SQLiteShadowPicker;
import org.robolectric.shadows.ShadowLegacySQLiteConnection;
import org.robolectric.shadows.ShadowNativeSQLiteConnection;

@Implements(className="android.database.sqlite.SQLiteConnection", isInAndroidSdk=false, shadowPicker=Picker.class)
public class ShadowSQLiteConnection {
    protected static AtomicBoolean useInMemoryDatabase = new AtomicBoolean();

    public static void setUseInMemoryDatabase(boolean value) {
        if (ShadowSQLiteConnection.sqliteMode() != SQLiteMode.Mode.LEGACY) {
            throw new UnsupportedOperationException("this action is not supported in " + ShadowSQLiteConnection.sqliteMode() + " mode.");
        }
        useInMemoryDatabase.set(value);
    }

    public static SQLiteMode.Mode sqliteMode() {
        return (SQLiteMode.Mode)ConfigurationRegistry.get(SQLiteMode.Mode.class);
    }

    public static void setDefaultSyncMode(String value) {
        SystemProperties.set((String)"debug.sqlite.syncmode", (String)value);
    }

    public static void setDefaultWALSyncMode(String value) {
        SystemProperties.set((String)"debug.sqlite.wal.syncmode", (String)value);
    }

    public static void setDefaultJournalMode(String value) {
        SystemProperties.set((String)"debug.sqlite.journalmode", (String)value);
    }

    @Resetter
    public static void reset() {
        useInMemoryDatabase.set(false);
    }

    public static class Picker
    extends SQLiteShadowPicker<ShadowSQLiteConnection> {
        public Picker() {
            super(ShadowLegacySQLiteConnection.class, ShadowNativeSQLiteConnection.class);
        }
    }
}

