/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.media.IPlayer;
import android.media.PlayerBase;
import android.media.audiopolicy.AudioPolicy;
import android.os.Handler;
import android.os.Parcel;
import com.android.internal.util.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AudioManager.class, looseSignatures=true)
public class ShadowAudioManager {
    public static final int MAX_VOLUME_MUSIC_DTMF = 15;
    public static final int DEFAULT_MAX_VOLUME = 7;
    public static final int MIN_VOLUME = 0;
    public static final int DEFAULT_VOLUME = 7;
    public static final int INVALID_VOLUME = 0;
    public static final int FLAG_NO_ACTION = 0;
    public static final ImmutableList<Integer> ALL_STREAMS = ImmutableList.of((Object)3, (Object)4, (Object)5, (Object)2, (Object)1, (Object)0, (Object)8);
    private static final int INVALID_PATCH_HANDLE = -1;
    private static final float MAX_VOLUME_DB = 0.0f;
    private static final float MIN_VOLUME_DB = -100.0f;
    private AudioFocusRequest lastAudioFocusRequest;
    private int nextResponseValue = 1;
    private AudioManager.OnAudioFocusChangeListener lastAbandonedAudioFocusListener;
    private android.media.AudioFocusRequest lastAbandonedAudioFocusRequest;
    private HashMap<Integer, AudioStream> streamStatus = new HashMap();
    private List<AudioPlaybackConfiguration> activePlaybackConfigurations = Collections.emptyList();
    private List<AudioRecordingConfiguration> activeRecordingConfigurations = ImmutableList.of();
    private final HashSet<AudioManager.AudioRecordingCallback> audioRecordingCallbacks = new HashSet();
    private final HashSet<AudioManager.AudioPlaybackCallback> audioPlaybackCallbacks = new HashSet();
    private int ringerMode = 2;
    private int mode = 0;
    private boolean bluetoothA2dpOn;
    private boolean isBluetoothScoOn;
    private boolean isSpeakerphoneOn;
    private boolean isMicrophoneMuted = false;
    private boolean isMusicActive;
    private boolean wiredHeadsetOn;
    private boolean isBluetoothScoAvailableOffCall = false;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Map<Integer, Boolean> streamsMuteState = new HashMap<Integer, Boolean>();
    private final Map<String, AudioPolicy> registeredAudioPolicies = new HashMap<String, AudioPolicy>();
    private int audioSessionIdCounter = 1;
    private final Map<AudioAttributes, ImmutableList<Object>> devicesForAttributes = new HashMap<AudioAttributes, ImmutableList<Object>>();
    private ImmutableList<Object> defaultDevicesForAttributes = ImmutableList.of();
    private List<AudioDeviceInfo> inputDevices = new ArrayList<AudioDeviceInfo>();
    private List<AudioDeviceInfo> outputDevices = new ArrayList<AudioDeviceInfo>();
    private AudioDeviceInfo communicationDevice = null;

    public ShadowAudioManager() {
        UnmodifiableIterator unmodifiableIterator = ALL_STREAMS.iterator();
        while (unmodifiableIterator.hasNext()) {
            int stream = (Integer)unmodifiableIterator.next();
            this.streamStatus.put(stream, new AudioStream(7, 7, 0));
        }
        this.streamStatus.get(3).setMaxVolume(15);
        this.streamStatus.get(8).setMaxVolume(15);
    }

    @Implementation
    protected int getStreamMaxVolume(int streamType) {
        AudioStream stream = this.streamStatus.get(streamType);
        return stream != null ? stream.getMaxVolume() : 0;
    }

    @Implementation
    protected int getStreamVolume(int streamType) {
        AudioStream stream = this.streamStatus.get(streamType);
        return stream != null ? stream.getCurrentVolume() : 0;
    }

    @Implementation(minSdk=28)
    protected float getStreamVolumeDb(int streamType, int index, int deviceType) {
        AudioStream stream = this.streamStatus.get(streamType);
        if (stream == null) {
            return 0.0f;
        }
        if (index < 0 || index > stream.getMaxVolume()) {
            throw new IllegalArgumentException("Invalid stream volume index " + index);
        }
        if (index == 0) {
            return Float.NEGATIVE_INFINITY;
        }
        float interpolation = (float)(index - 0) / (float)(stream.getMaxVolume() - 0);
        return -100.0f + interpolation * 100.0f;
    }

    @Implementation
    protected void setStreamVolume(int streamType, int index, int flags) {
        AudioStream stream = this.streamStatus.get(streamType);
        if (stream != null) {
            stream.setCurrentVolume(index);
            stream.setFlag(flags);
        }
    }

    @Implementation
    protected boolean isBluetoothScoAvailableOffCall() {
        return this.isBluetoothScoAvailableOffCall;
    }

    @Implementation
    protected int requestAudioFocus(AudioManager.OnAudioFocusChangeListener l, int streamType, int durationHint) {
        this.lastAudioFocusRequest = new AudioFocusRequest(l, streamType, durationHint);
        return this.nextResponseValue;
    }

    @Implementation(minSdk=26)
    protected int requestAudioFocus(android.media.AudioFocusRequest audioFocusRequest) {
        this.lastAudioFocusRequest = new AudioFocusRequest(audioFocusRequest);
        return this.nextResponseValue;
    }

    @Implementation
    protected int abandonAudioFocus(AudioManager.OnAudioFocusChangeListener l) {
        this.lastAbandonedAudioFocusListener = l;
        return this.nextResponseValue;
    }

    @Implementation(minSdk=26)
    protected int abandonAudioFocusRequest(android.media.AudioFocusRequest audioFocusRequest) {
        this.lastAbandonedAudioFocusListener = audioFocusRequest.getOnAudioFocusChangeListener();
        this.lastAbandonedAudioFocusRequest = audioFocusRequest;
        return this.nextResponseValue;
    }

    @Implementation
    protected int getRingerMode() {
        return this.ringerMode;
    }

    @Implementation
    protected void setRingerMode(int ringerMode) {
        if (!AudioManager.isValidRingerMode((int)ringerMode)) {
            return;
        }
        this.ringerMode = ringerMode;
    }

    @Implementation
    public static boolean isValidRingerMode(int ringerMode) {
        return ringerMode >= 0 && ringerMode <= (Integer)ReflectionHelpers.getStaticField(AudioManager.class, (String)"RINGER_MODE_MAX");
    }

    @Implementation
    protected void setMode(int mode) {
        this.mode = mode;
    }

    @Implementation
    protected int getMode() {
        return this.mode;
    }

    public void setStreamMaxVolume(int streamMaxVolume) {
        this.streamStatus.forEach((key, value) -> value.setMaxVolume(streamMaxVolume));
    }

    public void setStreamVolume(int streamVolume) {
        this.streamStatus.forEach((key, value) -> value.setCurrentVolume(streamVolume));
    }

    @Implementation
    protected void setWiredHeadsetOn(boolean on) {
        this.wiredHeadsetOn = on;
    }

    @Implementation
    protected boolean isWiredHeadsetOn() {
        return this.wiredHeadsetOn;
    }

    @Implementation
    protected void setBluetoothA2dpOn(boolean on) {
        this.bluetoothA2dpOn = on;
    }

    @Implementation
    protected boolean isBluetoothA2dpOn() {
        return this.bluetoothA2dpOn;
    }

    @Implementation
    protected void setSpeakerphoneOn(boolean on) {
        this.isSpeakerphoneOn = on;
    }

    @Implementation
    protected boolean isSpeakerphoneOn() {
        return this.isSpeakerphoneOn;
    }

    @Implementation
    protected void setMicrophoneMute(boolean on) {
        this.isMicrophoneMuted = on;
    }

    @Implementation
    protected boolean isMicrophoneMute() {
        return this.isMicrophoneMuted;
    }

    @Implementation
    protected boolean isBluetoothScoOn() {
        return this.isBluetoothScoOn;
    }

    @Implementation
    protected void setBluetoothScoOn(boolean isBluetoothScoOn) {
        this.isBluetoothScoOn = isBluetoothScoOn;
    }

    @Implementation
    protected boolean isMusicActive() {
        return this.isMusicActive;
    }

    @Implementation(minSdk=26)
    protected List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() {
        return new ArrayList<AudioPlaybackConfiguration>(this.activePlaybackConfigurations);
    }

    @Implementation
    protected void setParameters(String keyValuePairs) {
        String[] pairs;
        if (keyValuePairs.isEmpty()) {
            throw new IllegalArgumentException("keyValuePairs should not be empty");
        }
        if (keyValuePairs.charAt(keyValuePairs.length() - 1) != ';') {
            throw new IllegalArgumentException("keyValuePairs should end with a ';'");
        }
        for (String pair : pairs = keyValuePairs.split(";", 0)) {
            if (pair.isEmpty()) continue;
            String[] splittedPair = pair.split("=", 0);
            if (splittedPair.length != 2) {
                throw new IllegalArgumentException("keyValuePairs: each pair should be in the format of key=value;");
            }
            this.parameters.put(splittedPair[0], splittedPair[1]);
        }
    }

    @Implementation
    protected String getParameters(String keys) {
        return null;
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    @Implementation
    protected void adjustStreamVolume(int streamType, int direction, int flags) {
        int streamVolume = this.getStreamVolume(streamType);
        switch (direction) {
            case -100: {
                this.streamsMuteState.put(streamType, true);
                break;
            }
            case 100: {
                this.streamsMuteState.put(streamType, false);
                break;
            }
            case 1: {
                int streamMaxVolume = this.getStreamMaxVolume(streamType);
                if (streamVolume == 0 || streamMaxVolume == 0) {
                    return;
                }
                int raisedVolume = streamVolume + 1;
                if (raisedVolume > streamMaxVolume) break;
                this.setStreamVolume(raisedVolume);
                break;
            }
            case -1: {
                if (streamVolume == 0) {
                    return;
                }
                int lowerVolume = streamVolume - 1;
                if (lowerVolume < 1) break;
                this.setStreamVolume(lowerVolume);
                break;
            }
        }
    }

    @Implementation(minSdk=23)
    protected boolean isStreamMute(int streamType) {
        if (!this.streamsMuteState.containsKey(streamType)) {
            return false;
        }
        return this.streamsMuteState.get(streamType);
    }

    public void setIsBluetoothScoAvailableOffCall(boolean isBluetoothScoAvailableOffCall) {
        this.isBluetoothScoAvailableOffCall = isBluetoothScoAvailableOffCall;
    }

    public void setIsStreamMute(int streamType, boolean isMuted) {
        this.streamsMuteState.put(streamType, isMuted);
    }

    @Implementation(minSdk=26)
    protected void registerAudioPlaybackCallback(AudioManager.AudioPlaybackCallback cb, Handler handler) {
        this.audioPlaybackCallbacks.add(cb);
    }

    @Implementation(minSdk=26)
    protected void unregisterAudioPlaybackCallback(AudioManager.AudioPlaybackCallback cb) {
        this.audioPlaybackCallbacks.remove(cb);
    }

    @Implementation(minSdk=30)
    protected List<Object> getDevicesForAttributes(AudioAttributes attributes) {
        ImmutableList<Object> devices = this.devicesForAttributes.get(attributes);
        return devices == null ? this.defaultDevicesForAttributes : devices;
    }

    public void setDevicesForAttributes(AudioAttributes attributes, ImmutableList<Object> devices) {
        this.devicesForAttributes.put(attributes, devices);
    }

    public void setDefaultDevicesForAttributes(ImmutableList<Object> devices) {
        this.defaultDevicesForAttributes = devices;
    }

    public void setInputDevices(List<AudioDeviceInfo> inputDevices) {
        this.inputDevices = inputDevices;
    }

    public void setOutputDevices(List<AudioDeviceInfo> outputDevices) {
        this.outputDevices = outputDevices;
    }

    private List<AudioDeviceInfo> getInputDevices() {
        return this.inputDevices;
    }

    private List<AudioDeviceInfo> getOutputDevices() {
        return this.outputDevices;
    }

    @Implementation(minSdk=31)
    protected boolean setCommunicationDevice(AudioDeviceInfo communicationDevice) {
        this.communicationDevice = communicationDevice;
        return true;
    }

    @Implementation(minSdk=31)
    protected AudioDeviceInfo getCommunicationDevice() {
        return this.communicationDevice;
    }

    @Implementation(minSdk=31)
    protected void clearCommunicationDevice() {
        this.communicationDevice = null;
    }

    @Implementation(minSdk=23)
    public AudioDeviceInfo[] getDevices(int flags) {
        ArrayList<AudioDeviceInfo> result = new ArrayList<AudioDeviceInfo>();
        if ((flags & 1) == 1) {
            result.addAll(this.getInputDevices());
        }
        if ((flags & 2) == 2) {
            result.addAll(this.getOutputDevices());
        }
        return result.toArray(new AudioDeviceInfo[0]);
    }

    @TargetApi(value=26)
    public void setActivePlaybackConfigurationsFor(List<AudioAttributes> audioAttributes) {
        this.setActivePlaybackConfigurationsFor(audioAttributes, false);
    }

    @TargetApi(value=26)
    public void setActivePlaybackConfigurationsFor(List<AudioAttributes> audioAttributes, boolean notifyCallbackListeners) {
        if (RuntimeEnvironment.getApiLevel() < 26) {
            throw new UnsupportedOperationException("setActivePlaybackConfigurationsFor is not supported on API " + RuntimeEnvironment.getApiLevel());
        }
        this.activePlaybackConfigurations = new ArrayList<AudioPlaybackConfiguration>(audioAttributes.size());
        for (AudioAttributes audioAttribute : audioAttributes) {
            AudioPlaybackConfiguration configuration = this.createAudioPlaybackConfiguration(audioAttribute);
            this.activePlaybackConfigurations.add(configuration);
        }
        if (notifyCallbackListeners) {
            for (AudioManager.AudioPlaybackCallback callback : this.audioPlaybackCallbacks) {
                callback.onPlaybackConfigChanged(this.activePlaybackConfigurations);
            }
        }
    }

    protected AudioPlaybackConfiguration createAudioPlaybackConfiguration(AudioAttributes audioAttributes) {
        if (RuntimeEnvironment.getApiLevel() >= 31) {
            PlayerBase.PlayerIdCard playerIdCard = (PlayerBase.PlayerIdCard)ReflectionHelpers.callConstructor(PlayerBase.PlayerIdCard.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(AudioAttributes.class, (Object)audioAttributes), ReflectionHelpers.ClassParameter.from(IPlayer.class, null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
            AudioPlaybackConfiguration config = (AudioPlaybackConfiguration)ReflectionHelpers.callConstructor(AudioPlaybackConfiguration.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(PlayerBase.PlayerIdCard.class, (Object)playerIdCard), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
            ReflectionHelpers.setField((Object)config, (String)"mPlayerState", (Object)2);
            return config;
        }
        PlayerBase.PlayerIdCard playerIdCard = (PlayerBase.PlayerIdCard)ReflectionHelpers.callConstructor(PlayerBase.PlayerIdCard.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(AudioAttributes.class, (Object)audioAttributes), ReflectionHelpers.ClassParameter.from(IPlayer.class, null)});
        AudioPlaybackConfiguration config = (AudioPlaybackConfiguration)ReflectionHelpers.callConstructor(AudioPlaybackConfiguration.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(PlayerBase.PlayerIdCard.class, (Object)playerIdCard), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
        ReflectionHelpers.setField((Object)config, (String)"mPlayerState", (Object)2);
        return config;
    }

    public void setIsMusicActive(boolean isMusicActive) {
        this.isMusicActive = isMusicActive;
    }

    public AudioFocusRequest getLastAudioFocusRequest() {
        return this.lastAudioFocusRequest;
    }

    public void setNextFocusRequestResponse(int nextResponseValue) {
        this.nextResponseValue = nextResponseValue;
    }

    public AudioManager.OnAudioFocusChangeListener getLastAbandonedAudioFocusListener() {
        return this.lastAbandonedAudioFocusListener;
    }

    public android.media.AudioFocusRequest getLastAbandonedAudioFocusRequest() {
        return this.lastAbandonedAudioFocusRequest;
    }

    @Implementation(minSdk=24)
    protected List<AudioRecordingConfiguration> getActiveRecordingConfigurations() {
        return this.activeRecordingConfigurations;
    }

    @Implementation(minSdk=24)
    protected void registerAudioRecordingCallback(AudioManager.AudioRecordingCallback cb, Handler handler) {
        this.audioRecordingCallbacks.add(cb);
    }

    @Implementation(minSdk=24)
    protected void unregisterAudioRecordingCallback(AudioManager.AudioRecordingCallback cb) {
        this.audioRecordingCallbacks.remove(cb);
    }

    public void setActiveRecordingConfigurations(List<AudioRecordingConfiguration> activeRecordingConfigurations, boolean notifyCallbackListeners) {
        this.activeRecordingConfigurations = new ArrayList<AudioRecordingConfiguration>(activeRecordingConfigurations);
        if (notifyCallbackListeners) {
            for (AudioManager.AudioRecordingCallback callback : this.audioRecordingCallbacks) {
                callback.onRecordingConfigChanged(this.activeRecordingConfigurations);
            }
        }
    }

    public AudioRecordingConfiguration createActiveRecordingConfiguration(int sessionId, int audioSource, String clientPackageName) {
        Parcel p = Parcel.obtain();
        p.writeInt(sessionId);
        p.writeInt(audioSource);
        ShadowAudioManager.writeMono16BitAudioFormatToParcel(p);
        ShadowAudioManager.writeMono16BitAudioFormatToParcel(p);
        p.writeInt(-1);
        p.writeString(clientPackageName);
        p.writeInt(0);
        p.setDataPosition(0);
        AudioRecordingConfiguration configuration = (AudioRecordingConfiguration)AudioRecordingConfiguration.CREATOR.createFromParcel(p);
        p.recycle();
        return configuration;
    }

    @HiddenApi
    @Implementation(minSdk=28)
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    protected int registerAudioPolicy(Object audioPolicy) {
        Preconditions.checkNotNull((Object)audioPolicy, (Object)"Illegal null AudioPolicy argument");
        AudioPolicy policy = (AudioPolicy)audioPolicy;
        String id2 = ShadowAudioManager.getIdForAudioPolicy(audioPolicy);
        if (this.registeredAudioPolicies.containsKey(id2)) {
            return -1;
        }
        this.registeredAudioPolicies.put(id2, policy);
        policy.setRegistration(id2);
        return 0;
    }

    @HiddenApi
    @Implementation(minSdk=29)
    protected void unregisterAudioPolicy(Object audioPolicy) {
        Preconditions.checkNotNull((Object)audioPolicy, (Object)"Illegal null AudioPolicy argument");
        AudioPolicy policy = (AudioPolicy)audioPolicy;
        this.registeredAudioPolicies.remove(ShadowAudioManager.getIdForAudioPolicy(policy));
        policy.setRegistration(null);
    }

    public boolean isAnyAudioPolicyRegistered() {
        return !this.registeredAudioPolicies.isEmpty();
    }

    @Implementation(minSdk=21)
    protected int generateAudioSessionId() {
        if (this.audioSessionIdCounter < 0) {
            return -1;
        }
        return this.audioSessionIdCounter++;
    }

    private static String getIdForAudioPolicy(Object audioPolicy) {
        return Integer.toString(System.identityHashCode(audioPolicy));
    }

    private static void writeMono16BitAudioFormatToParcel(Parcel p) {
        p.writeInt(7);
        p.writeInt(2);
        p.writeInt(16000);
        p.writeInt(4);
        p.writeInt(0);
    }

    private static class AudioStream {
        private int currentVolume;
        private int maxVolume;
        private int flag;

        public AudioStream(int currVol, int maxVol, int flag) {
            if (0 > maxVol) {
                throw new IllegalArgumentException("Min volume is higher than max volume.");
            }
            this.setCurrentVolume(currVol);
            this.setMaxVolume(maxVol);
            this.setFlag(flag);
        }

        public int getCurrentVolume() {
            return this.currentVolume;
        }

        public int getMaxVolume() {
            return this.maxVolume;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setCurrentVolume(int vol) {
            if (vol > this.maxVolume) {
                vol = this.maxVolume;
            } else if (vol < 0) {
                vol = 0;
            }
            this.currentVolume = vol;
        }

        public void setMaxVolume(int vol) {
            this.maxVolume = vol;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }
    }

    public static class AudioFocusRequest {
        public final AudioManager.OnAudioFocusChangeListener listener;
        public final int streamType;
        public final int durationHint;
        public final android.media.AudioFocusRequest audioFocusRequest;

        private AudioFocusRequest(AudioManager.OnAudioFocusChangeListener listener, int streamType, int durationHint) {
            this.listener = listener;
            this.streamType = streamType;
            this.durationHint = durationHint;
            this.audioFocusRequest = null;
        }

        private AudioFocusRequest(android.media.AudioFocusRequest audioFocusRequest) {
            this.listener = audioFocusRequest.getOnAudioFocusChangeListener();
            this.durationHint = audioFocusRequest.getFocusGain();
            this.streamType = audioFocusRequest.getAudioAttributes().getVolumeControlStream();
            this.audioFocusRequest = audioFocusRequest;
        }
    }
}

