/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.TimeoutException;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=UsbDeviceConnection.class)
public class ShadowUsbDeviceConnection {
    private PipedInputStream outgoingDataPipedInputStream;
    private PipedOutputStream outgoingDataPipedOutputStream;
    private DataListener dataListener;

    @Implementation
    protected boolean claimInterface(UsbInterface intf, boolean force) {
        try {
            this.outgoingDataPipedInputStream = new PipedInputStream();
            this.outgoingDataPipedOutputStream = new PipedOutputStream(this.outgoingDataPipedInputStream);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Implementation
    protected boolean releaseInterface(UsbInterface intf) {
        try {
            this.outgoingDataPipedInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.outgoingDataPipedOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Implementation(minSdk=19)
    protected int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) {
        return length;
    }

    @Implementation(minSdk=19)
    protected int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int offset, int length, int timeout) {
        return length;
    }

    @Implementation
    protected UsbRequest requestWait() {
        if (this.dataListener == null) {
            throw new IllegalStateException("No UsbRequest initialized for this UsbDeviceConnection");
        }
        return this.dataListener.getUsbRequest();
    }

    @Implementation(minSdk=26)
    protected UsbRequest requestWait(long timeout) throws TimeoutException {
        return this.requestWait();
    }

    @Implementation(minSdk=18)
    protected int bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int offset, int length, int timeout) {
        try {
            this.outgoingDataPipedOutputStream.write(buffer, offset, length);
            return length;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Implementation
    protected int bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int length, int timeout) {
        try {
            this.outgoingDataPipedOutputStream.write(buffer, 0, length);
            return length;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public void readOutgoingData(byte[] buffer) throws IOException {
        this.outgoingDataPipedInputStream.read(buffer);
    }

    public void writeIncomingData(byte[] data) {
        if (this.dataListener == null) {
            throw new IllegalStateException("No UsbRequest initialized for this UsbDeviceConnection");
        }
        this.dataListener.onDataReceived(data);
    }

    void registerDataListener(DataListener dataListener) {
        this.dataListener = dataListener;
    }

    void unregisterDataListener() {
        this.dataListener = null;
    }

    static interface DataListener {
        public void onDataReceived(byte[] var1);

        public UsbRequest getUsbRequest();
    }
}

