/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.Choreographer;
import com.google.common.base.Preconditions;
import java.time.Duration;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.LooperShadowPicker;
import org.robolectric.shadows.ShadowLegacyChoreographer;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPausedChoreographer;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Choreographer.class, shadowPicker=Picker.class)
public abstract class ShadowChoreographer {
    @RealObject
    Choreographer realObject;
    private ChoreographerReflector reflector;
    private static volatile boolean isPaused = false;
    private static volatile Duration frameDelay = Duration.ofMillis(1L);

    public static void setFrameDelay(Duration delay) {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.PAUSED), (String)"Looper must be %s", (Object)LooperMode.Mode.PAUSED);
        frameDelay = delay;
    }

    public static Duration getFrameDelay() {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.PAUSED), (String)"Looper must be %s", (Object)LooperMode.Mode.PAUSED);
        return frameDelay;
    }

    public static void setPaused(boolean paused) {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.PAUSED), (String)"Looper must be %s", (Object)LooperMode.Mode.PAUSED);
        isPaused = paused;
    }

    public static boolean isPaused() {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.PAUSED), (String)"Looper must be %s", (Object)LooperMode.Mode.PAUSED);
        return isPaused;
    }

    @Deprecated
    public static void setPostCallbackDelay(int delayMillis) {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY), (String)"Looper must be %s", (Object)LooperMode.Mode.LEGACY);
        ShadowLegacyChoreographer.setPostCallbackDelay(delayMillis);
    }

    @Deprecated
    public static void setPostFrameCallbackDelay(int delayMillis) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            ShadowChoreographer.setPaused(delayMillis != 0);
            ShadowChoreographer.setFrameDelay(Duration.ofMillis(delayMillis == 0 ? 1L : (long)delayMillis));
        } else {
            ShadowLegacyChoreographer.setPostFrameCallbackDelay(delayMillis);
        }
    }

    @Deprecated
    public static long getFrameInterval() {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY), (String)"Looper must be %s", (Object)LooperMode.Mode.LEGACY);
        return ShadowLegacyChoreographer.getFrameInterval();
    }

    @Deprecated
    public static void setFrameInterval(long frameInterval) {
        Preconditions.checkState((boolean)ShadowLooper.looperMode().equals((Object)LooperMode.Mode.LEGACY), (String)"Looper must be %s", (Object)LooperMode.Mode.LEGACY);
        ShadowLegacyChoreographer.setFrameInterval(frameInterval);
    }

    @Implementation(maxSdk=30)
    protected void doFrame(long frameTimeNanos, int frame) {
        if (this.reflector == null) {
            this.reflector = (ChoreographerReflector)Reflector.reflector(ChoreographerReflector.class, (Object)this.realObject);
        }
        PerfStatsCollector.getInstance().measure("doFrame", () -> this.reflector.doFrame(frameTimeNanos, frame));
    }

    @Resetter
    public static void reset() {
        isPaused = false;
        frameDelay = Duration.ofMillis(1L);
    }

    @ForType(value=Choreographer.class)
    protected static interface ChoreographerReflector {
        @Accessor(value="sThreadInstance")
        @Static
        public ThreadLocal<Choreographer> getThreadInstance();

        @Direct
        public void doFrame(long var1, int var3);
    }

    public static class Picker
    extends LooperShadowPicker<ShadowChoreographer> {
        public Picker() {
            super(ShadowLegacyChoreographer.class, ShadowPausedChoreographer.class);
        }
    }
}

